/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9CfrClassFile;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9ROMMethod;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

public class J9ROMMethodHelper {
    static final int romHelpVersion = AlgorithmVersion.getVersionOf("ALG_ROM_HELP_VERSION").getAlgorithmVersion();

    public static int getReflectModifiers(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().bitAnd(J9CfrClassFile.CFR_METHOD_ACCESS_MASK).intValue();
    }

    public static String getName(J9ROMMethodPointer method) throws CorruptDataException {
        return J9UTF8Helper.stringValue(method.nameAndSignature().name());
    }

    public static String getSignature(J9ROMMethodPointer method) throws CorruptDataException {
        return J9UTF8Helper.stringValue(method.nameAndSignature().signature());
    }

    public static U8Pointer bytecodes(J9ROMMethodPointer method) throws CorruptDataException {
        return U8Pointer.cast(method).addOffset(J9ROMMethod.SIZEOF);
    }

    public static UDATA bytecodeSize(J9ROMMethodPointer method) throws CorruptDataException {
        return method.bytecodeSizeLow().add(new UDATA(method.bytecodeSizeHigh().leftShift(16)));
    }

    public static U8Pointer bytecodeEnd(J9ROMMethodPointer method) throws CorruptDataException {
        return J9ROMMethodHelper.bytecodes(method).add(J9ROMMethodHelper.bytecodeSize(method));
    }

    public static U32 getExtendedModifiersDataFromROMMethod(J9ROMMethodPointer method) throws CorruptDataException {
        return ROMHelp.getExtendedModifiersDataFromROMMethod(method);
    }

    public static boolean isGetter(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccGetterMethod);
    }

    public static boolean isEmpty(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccEmptyMethod);
    }

    public static boolean hasVTable(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodVTable);
    }

    public static boolean isStatic(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccStatic);
    }

    public static boolean hasExceptionInfo(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo);
    }

    public static boolean hasBackwardBranches(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasBackwardBranches);
    }

    public static boolean hasGenericSignature(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasGenericSignature);
    }

    public static boolean hasMethodAnnotations(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasMethodAnnotations);
    }

    public static boolean hasParameterAnnotations(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasParameterAnnotations);
    }

    public static boolean hasMethodTypeAnnotations(J9ROMMethodPointer method) throws CorruptDataException {
        boolean result = false;
        if (0 != romHelpVersion) {
            U32 extendedModifiers = J9ROMMethodHelper.getExtendedModifiersDataFromROMMethod(method);
            result = extendedModifiers.allBitsIn(J9CfrClassFile.CFR_METHOD_EXT_HAS_METHOD_TYPE_ANNOTATIONS);
        } else {
            result = method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasTypeAnnotations);
        }
        return result;
    }

    public static boolean hasCodeTypeAnnotations(J9ROMMethodPointer method) throws CorruptDataException {
        boolean result = false;
        if (0 != romHelpVersion) {
            U32 extendedModifiers = J9ROMMethodHelper.getExtendedModifiersDataFromROMMethod(method);
            result = extendedModifiers.allBitsIn(J9CfrClassFile.CFR_METHOD_EXT_HAS_CODE_TYPE_ANNOTATIONS);
        }
        return result;
    }

    public static boolean hasExtendedModifiers(J9ROMMethodPointer method) throws CorruptDataException {
        return 0 != romHelpVersion && method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasExtendedModifiers);
    }

    public static boolean hasDefaultAnnotation(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasDefaultAnnotation);
    }

    public static boolean hasDebugInfo(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasDebugInfo);
    }

    public static boolean hasStackMap(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasStackMap);
    }

    public static boolean hasMethodParameters(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasMethodParameters);
    }

    public static boolean isNonEmptyObjectConstructor(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().maskAndCompare(J9JavaAccessFlags.J9AccMethodObjectConstructor + J9JavaAccessFlags.J9AccEmptyMethod, J9JavaAccessFlags.J9AccMethodObjectConstructor);
    }
}

