/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.vm28.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm28.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm28.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm28.tools.ddrinteractive.gccheck.CheckEngine;
import com.ibm.j9ddr.vm28.tools.ddrinteractive.gccheck.CheckReporter;

abstract class Check {
    protected CheckEngine _engine;
    protected J9JavaVMPointer _javaVM;
    protected MM_GCExtensionsPointer _extensions;

    public abstract String getCheckName();

    public abstract void check();

    public abstract void print();

    protected CheckReporter getReporter() {
        return this._engine.getReporter();
    }

    public void run(boolean shouldCheck, boolean shouldPrint) {
        this.getReporter().print("Checking " + this.getCheckName() + "...");
        this._engine.startNewCheck(this);
        long startTime = System.currentTimeMillis();
        if (shouldCheck) {
            this.check();
        }
        long endTime = System.currentTimeMillis();
        if (shouldPrint) {
            this.print();
        }
        this.getReporter().println("done (" + (endTime - startTime) + " ms).");
    }

    public void initialize(CheckEngine engine) {
        this._engine = engine;
        this._javaVM = engine.getJavaVM();
        this._extensions = GCExtensions.getGCExtensionsPointer();
    }

    public J9JavaVMPointer getJavaVM() {
        return this._javaVM;
    }

    public MM_GCExtensionsPointer getGCExtensions() {
        return this._extensions;
    }
}

