/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm27.j9.walkers.LineNumber;
import com.ibm.j9ddr.vm27.pointer.U16Pointer;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9LineNumberPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9MethodDebugInfoHelper;
import com.ibm.j9ddr.vm27.types.I16;
import com.ibm.j9ddr.vm27.types.I32;
import com.ibm.j9ddr.vm27.types.U16;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.types.U8;
import java.util.Iterator;

public abstract class LineNumberIterator
implements Iterator<LineNumber> {
    public static LineNumberIterator lineNumberIteratorFor(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
        if (AlgorithmVersion.getVersionOf("VM_LINE_NUMBER_TABLE_VERSION").getAlgorithmVersion() < 1) {
            return new LineNumberIterator_V0(methodInfo);
        }
        return new LineNumberIterator_V1(methodInfo);
    }

    public abstract U8Pointer getLineNumberTablePtr();

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class LineNumberIterator_V0
    extends LineNumberIterator {
        private J9MethodDebugInfoPointer methodInfo;
        private J9LineNumberPointer lineNumberPtr;
        private U32 count = new U32(0L);
        private U32 location = new U32(0L);

        public LineNumberIterator_V0(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
            this.methodInfo = methodInfo;
            this.lineNumberPtr = J9MethodDebugInfoHelper.getLineNumberTableForROMClass(methodInfo);
        }

        @Override
        public boolean hasNext() {
            try {
                return this.count.lt(this.methodInfo.lineNumberCount());
            }
            catch (CorruptDataException e) {
                return false;
            }
        }

        @Override
        public LineNumber next() {
            this.count = this.count.add(1);
            try {
                LineNumber toReturn = new LineNumber(new U32(this.lineNumberPtr.lineNumber()), this.location);
                this.lineNumberPtr = this.lineNumberPtr.add(1L);
                return toReturn;
            }
            catch (CorruptDataException ex) {
                EventManager.raiseCorruptDataEvent("CorruptData encountered walking port LineNumbers.", ex, false);
                return null;
            }
        }

        @Override
        public U8Pointer getLineNumberTablePtr() {
            return U8Pointer.cast(this.lineNumberPtr);
        }
    }

    private static class LineNumberIterator_V1
    extends LineNumberIterator {
        private J9MethodDebugInfoPointer methodInfo;
        private U32 count = new U32(0L);
        private U8Pointer lineNumberTablePtr;
        private U32 lineNumber = new U32(0L);
        private U32 location = new U32(0L);

        public LineNumberIterator_V1(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
            this.methodInfo = methodInfo;
            this.lineNumberTablePtr = J9MethodDebugInfoHelper.getCompressedLineNumberTableForROMClassV1(methodInfo);
        }

        @Override
        public boolean hasNext() {
            try {
                return this.count.lt(J9MethodDebugInfoHelper.getLineNumberCount(this.methodInfo));
            }
            catch (CorruptDataException e) {
                return false;
            }
        }

        @Override
        public U8Pointer getLineNumberTablePtr() {
            return this.lineNumberTablePtr;
        }

        @Override
        public LineNumber next() {
            block7: {
                this.count = this.count.add(1);
                try {
                    U8 firstByte = this.lineNumberTablePtr.at(0L);
                    if (firstByte.bitAnd(128).eq(0L)) {
                        this.location = this.location.add(firstByte.rightShift(2).bitAnd(31));
                        this.lineNumber = this.lineNumber.add(firstByte.bitAnd(3));
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(1L);
                        break block7;
                    }
                    if (firstByte.bitAnd(192).eq(128L)) {
                        U16 encoded = new U16(firstByte).leftShift(8);
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(1L);
                        encoded = new U16(encoded.bitOr(this.lineNumberTablePtr.at(0L)));
                        this.location = this.location.add(encoded.rightShift(9).bitAnd(31));
                        this.lineNumber = this.lineNumber.add(LineNumberIterator_V1.signExtend(new I16(encoded.bitAnd(511)), 9));
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(1L);
                        break block7;
                    }
                    if (firstByte.bitAnd(224).eq(192L)) {
                        U32 encoded = new U32(firstByte).leftShift(16);
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(1L);
                        encoded = encoded.bitOr(U16Pointer.cast(this.lineNumberTablePtr).at(0L));
                        this.location = this.location.add(encoded.rightShift(14).bitAnd(127));
                        this.lineNumber = this.lineNumber.add(LineNumberIterator_V1.signExtend(new I16(encoded.bitAnd(16383)), 14));
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(2L);
                        break block7;
                    }
                    if (firstByte.bitAnd(224).eq(240L)) {
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(1L);
                        this.location = this.location.add(U16Pointer.cast(this.lineNumberTablePtr).at(0L));
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(2L);
                        I32 lineNumberOffset = new I32(U16Pointer.cast(this.lineNumberTablePtr).at(0L));
                        if (firstByte.bitAnd(1).eq(1L)) {
                            lineNumberOffset = lineNumberOffset.bitAnd(65535);
                        }
                        this.lineNumber = this.lineNumber.add(lineNumberOffset);
                        this.lineNumberTablePtr = this.lineNumberTablePtr.add(2L);
                        break block7;
                    }
                    return null;
                }
                catch (CorruptDataException ex) {
                    EventManager.raiseCorruptDataEvent("CorruptData encountered walking port LineNumbers.", ex, false);
                    return null;
                }
            }
            return new LineNumber(this.lineNumber, this.location);
        }

        private static I16 signExtend(I16 number, int numberBits) {
            int shiftAmount = 16 - numberBits;
            return number.leftShift(shiftAmount).rightShift(shiftAmount);
        }
    }
}

