/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.gc.GCIterator;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GCVMThreadSlotIterator
extends GCIterator {
    protected J9VMThreadPointer vmThread;
    protected Iterator<StructurePointer.StructureField> slotIterator;

    protected GCVMThreadSlotIterator(J9VMThreadPointer vmThread) {
        this.vmThread = vmThread;
        StructurePointer.StructureField[] fields = vmThread.getStructureFields();
        ArrayList<StructurePointer.StructureField> objectFields = new ArrayList<StructurePointer.StructureField>();
        for (StructurePointer.StructureField structureField : fields) {
            if (!structureField.type.equals("j9object_t")) continue;
            if (structureField.value != null && ((J9ObjectPointer)structureField.value).notNull()) {
                objectFields.add(structureField);
                continue;
            }
            if (structureField.cde == null) continue;
            objectFields.add(structureField);
        }
        this.slotIterator = objectFields.iterator();
    }

    public static GCVMThreadSlotIterator fromJ9VMThread(J9VMThreadPointer vmThread) throws CorruptDataException {
        return new GCVMThreadSlotIterator(vmThread);
    }

    @Override
    public boolean hasNext() {
        return this.slotIterator.hasNext();
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            StructurePointer.StructureField field = this.slotIterator.next();
            if (field.cde == null) {
                return (J9ObjectPointer)field.value;
            }
            EventManager.raiseCorruptDataEvent("Unable to retrieve thread slot", field.cde, false);
            return null;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            StructurePointer.StructureField field = this.slotIterator.next();
            if (field.cde == null) {
                return VoidPointer.cast(this.vmThread.addOffset(field.offset));
            }
            EventManager.raiseCorruptDataEvent("Unable to retrieve thread slot", field.cde, false);
            return null;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

