/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.Pointer;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.U8;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.io.UnsupportedEncodingException;

public class U8Pointer
extends Pointer {
    public static final int SIZEOF = 1;
    public static final U8Pointer NULL = new U8Pointer(0L);

    protected U8Pointer(long address) {
        super(address);
    }

    public static U8Pointer cast(AbstractPointer pointer) {
        return U8Pointer.cast(pointer.getAddress());
    }

    public static U8Pointer cast(UDATA udata) {
        return U8Pointer.cast(udata.longValue());
    }

    public static U8Pointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new U8Pointer(address);
    }

    @Override
    public U8 at(long index) throws CorruptDataException {
        return new U8(this.getByteAtOffset(index * 1L));
    }

    @Override
    public U8 at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    @Override
    public U8Pointer untag() {
        throw new UnsupportedOperationException("Use UPointer.untag(long mask) instead.");
    }

    @Override
    public U8Pointer untag(long mask) {
        return new U8Pointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public U8Pointer add(long count) {
        return new U8Pointer(this.address + 1L * count);
    }

    @Override
    public U8Pointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public U8Pointer addOffset(long offset) {
        return new U8Pointer(this.address + offset);
    }

    @Override
    public U8Pointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public String getCStringAtOffset(long offset) throws CorruptDataException {
        return this.getCStringAtOffset(offset, Long.MAX_VALUE);
    }

    public String getCStringAtOffset(long offset, long maxLength) throws CorruptDataException {
        int length = 0;
        while (0 != this.getByteAtOffset(offset + (long)length) && (long)length < maxLength) {
            ++length;
        }
        byte[] buffer = new byte[length];
        this.getBytesAtOffset(offset, buffer);
        try {
            return new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public U8Pointer sub(long count) {
        return new U8Pointer(this.address - 1L * count);
    }

    @Override
    public U8Pointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public U8Pointer subOffset(long offset) {
        return new U8Pointer(this.address - offset);
    }

    @Override
    public U8Pointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return 1L;
    }
}

