/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import com.ibm.j9ddr.corereaders.minidump.Stream;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class ThreadInfoStream
extends Stream {
    private final long baseMillisOffset;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    protected ThreadInfoStream(int dataSize, long location) {
        super(dataSize, location);
        GregorianCalendar baseTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        baseTime.clear();
        baseTime.set(1601, 0, 1, 0, 0, 0);
        this.baseMillisOffset = baseTime.getTimeInMillis();
    }

    public void readFrom(MiniDumpReader dump, IAddressSpace addressSpace, boolean is64Bit, List<IOSThread> threads) throws CorruptDataException, IOException {
        dump.seek(this.getLocation());
        int sizeOfHeader = 0;
        int sizeOfEntry = 0;
        int numberOfEntries = 0;
        HashMap<Long, Properties> threadInfo = new HashMap<Long, Properties>();
        sizeOfHeader = dump.readInt();
        sizeOfEntry = dump.readInt();
        numberOfEntries = dump.readInt();
        dump.seek(this.getLocation() + (long)sizeOfHeader);
        for (int i = 0; i < numberOfEntries; ++i) {
            Properties props = new Properties();
            int threadId = dump.readInt();
            int dumpFlags = dump.readInt();
            int dumpError = dump.readInt();
            int exitStatus = dump.readInt();
            long createTime = dump.readLong();
            long exitTime = dump.readLong();
            long kernelTime = dump.readLong();
            long userTime = dump.readLong();
            long startAddress = dump.readLong();
            long affinity = dump.readLong();
            props.put("DumpFlags", String.format("0x%08X", dumpFlags));
            props.put("DumpError", String.format("0x%08X", dumpError));
            props.put("ExitStatus", String.format("0x%08X", exitStatus));
            props.put("CreateTime", Long.toString(createTime));
            props.put("ExitTime", Long.toString(exitTime));
            props.put("KernelTime", Long.toString(kernelTime));
            props.put("UserTime", Long.toString(userTime));
            props.put("StartAddress", String.format(is64Bit ? "0x%016X" : "0x%08X", startAddress));
            props.put("Affinity", String.format("0x%016X", affinity));
            long createTimeMillis = createTime / 10000L + this.baseMillisOffset;
            String createTimeStr = this.dateFormat.format(new Date(createTimeMillis));
            props.put("CreateTime_Formatted", createTimeStr);
            if (exitTime != 0L) {
                long exitTimeMillis = exitTime / 10000L + this.baseMillisOffset;
                String exitTimeStr = this.dateFormat.format(new Date(exitTimeMillis));
                props.put("ExitTime_Formatted", exitTimeStr);
            }
            threadInfo.put(Long.valueOf(threadId), props);
        }
        for (IOSThread t : threads) {
            Properties p = (Properties)threadInfo.get(t.getThreadId());
            if (p == null) continue;
            t.getProperties().putAll((Map<?, ?>)p);
        }
    }
}

