/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.BaseMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;

public class MemoryRange
extends BaseMemoryRange
implements IMemoryRange {
    private final IAddressSpace addressSpace;
    private final String name;

    public MemoryRange(IAddressSpace addressSpace, long baseAddress, long size, String name) {
        super(baseAddress, size);
        this.addressSpace = addressSpace;
        this.name = name;
    }

    public MemoryRange(IAddressSpace addressSpace, IMemoryRange range, String name) {
        this(addressSpace, range.getBaseAddress(), range.getSize(), name);
    }

    @Override
    public int getAddressSpaceId() {
        return this.addressSpace.getAddressSpaceId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isExecutable() {
        return this.addressSpace.isExecutable(this.getBaseAddress());
    }

    @Override
    public boolean isReadOnly() {
        return this.addressSpace.isReadOnly(this.getBaseAddress());
    }

    @Override
    public boolean isShared() {
        return this.addressSpace.isShared(this.getBaseAddress());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addressSpace == null ? 0 : this.addressSpace.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryRange)) {
            return false;
        }
        MemoryRange other = (MemoryRange)obj;
        if (this.addressSpace == null ? other.addressSpace != null : !this.addressSpace.equals(other.addressSpace)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

