/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.macho.MachoDumpReader;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class MachoDumpReaderFactory
implements ICoreFileReader {
    @Override
    public ICore processDump(String path) throws InvalidDumpFormatException, IOException {
        return MachoDumpReader.getReaderForFile(new File(path));
    }

    @Override
    public ICore processDump(ImageInputStream in) throws InvalidDumpFormatException, IOException {
        return MachoDumpReader.getReaderForFile(in);
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(String path) throws IOException {
        File dumpFile = new File(path);
        if (!dumpFile.exists()) {
            return ICoreFileReader.DumpTestResult.FILE_NOT_FOUND;
        }
        return MachoDumpReader.isMACHO(CoreReader.getFileHeader(path)) ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(ImageInputStream in) throws IOException {
        return MachoDumpReader.isMACHO(CoreReader.getFileHeader(in)) ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
    }
}

