/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.macho.LoadCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class BuildVersionCommand
extends LoadCommand {
    int platform;
    int minOs;
    int sdk;
    int numTools;
    Version minOsVersion;
    Version sdkVersion;
    List<BuildToolVersion> tools;

    @Override
    public BuildVersionCommand readCommand(ImageInputStream stream, long streamSegmentOffset) throws IOException {
        super.readCommand(stream, streamSegmentOffset);
        this.platform = stream.readInt();
        this.minOs = stream.readInt();
        this.sdk = stream.readInt();
        this.numTools = stream.readInt();
        this.minOsVersion = new Version(this.minOs);
        this.sdkVersion = new Version(this.sdk);
        this.tools = new ArrayList<BuildToolVersion>(this.numTools);
        for (int i = 0; i < this.numTools; ++i) {
            this.tools.add(new BuildToolVersion(stream));
        }
        return this;
    }

    public static class BuildToolVersion {
        public static final int TOOL_CLANG = 1;
        public static final int TOOL_SWIFT = 2;
        public static final int TOOL_LD = 3;
        final int toolType;
        final int version;

        BuildToolVersion(ImageInputStream stream) throws IOException {
            this.toolType = stream.readInt();
            this.version = stream.readInt();
        }
    }

    public static class Version {
        final int major;
        final int minor;
        final int patch;

        public Version(int encoding) {
            this.major = encoding >>> 16;
            this.minor = encoding >>> 8 & 0xFF;
            this.patch = encoding & 0xFF;
        }
    }
}

