/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.FilterCellFastStr;
import com.ibm.ws.tcp.channel.impl.FilterListStr;
import java.io.UnsupportedEncodingException;

public class FilterListFastStr
implements FilterListStr {
    static final TraceComponent tc = Tr.register(FilterListFastStr.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private byte PERIOD_VALUE = (byte)46;
    private byte WILDCARD_VALUE = (byte)42;
    private FilterCellFastStr firstCell = new FilterCellFastStr();
    public boolean active = false;

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean buildData(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.addAddressToList(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean findInList(String string) {
        return this.findInList(this.convertToEntries(string));
    }

    private boolean addAddressToList(String string) {
        return this.putInList(this.convertToEntries(string));
    }

    private boolean findInList(Entry entry) {
        return this.findInList(entry.getHashcodes(), entry.getLengths(), this.firstCell, entry.getCurrentSize() - 1);
    }

    private boolean findInList(int[] nArray, int[] nArray2, FilterCellFastStr filterCellFastStr, int n) {
        if (filterCellFastStr.getWildcardCell() != null) {
            return true;
        }
        if ((filterCellFastStr = filterCellFastStr.findNextCellWithLength(nArray[n], nArray2[n])) != null) {
            if (n == 0) {
                return true;
            }
            return this.findInList(nArray, nArray2, filterCellFastStr, n - 1);
        }
        return false;
    }

    private boolean putInList(Entry entry) {
        int n;
        FilterCellFastStr filterCellFastStr = this.firstCell;
        FilterCellFastStr filterCellFastStr2 = null;
        int[] nArray = entry.getHashcodes();
        int[] nArray2 = entry.getLengths();
        for (int i = n = entry.getCurrentSize() - 1; i >= 0; --i) {
            if (nArray[i] == 0 && nArray2[i] == 0) {
                filterCellFastStr.addNewCell(nArray[i], nArray2[i]);
                return true;
            }
            filterCellFastStr2 = filterCellFastStr.findNextCell(nArray[i]);
            if (filterCellFastStr2 != null) {
                if (filterCellFastStr2.getHashLength() != nArray2[i]) {
                    // empty if block
                }
                return false;
            }
            if (filterCellFastStr2 == null) {
                for (int j = i; j >= 0; --j) {
                    filterCellFastStr = filterCellFastStr.addNewCell(nArray[j], nArray2[j]);
                    if (nArray[j] != 0 || nArray2[j] != 0) continue;
                    return true;
                }
                return true;
            }
            filterCellFastStr = filterCellFastStr2;
        }
        return true;
    }

    private Entry convertToEntries(String string) {
        byte[] byArray = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToEntries");
        }
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "ISO-8859-1 encoding not supported.  Exception: " + unsupportedEncodingException);
            }
            byArray = string.getBytes();
        }
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        Entry entry = new Entry();
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == this.WILDCARD_VALUE) {
                boolean bl = true;
                if (i != 0) {
                    bl = false;
                }
                if (n >= 2 && byArray[1] != this.PERIOD_VALUE) {
                    bl = false;
                }
                if (bl) {
                    entry.addEntry(0, 0);
                    i = 1;
                    continue;
                }
            }
            if (byArray[i] != this.PERIOD_VALUE) {
                n2 += n4 * byArray[i];
                n4 *= 31;
                ++n3;
            }
            if (byArray[i] != this.PERIOD_VALUE && i != n - 1) continue;
            if (n3 > 0) {
                entry.addEntry(n2, n3);
            }
            n3 = 0;
            n4 = 1;
            n2 = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToEntries");
        }
        return entry;
    }

    private class Entry {
        private int incrementalSize = 100;
        private int[] hashcodes1 = new int[this.incrementalSize];
        private int[] lengths1 = new int[this.incrementalSize];
        private int[] hashcodes2;
        private int[] lengths2;
        private int index = 0;
        private int iSwitch = 1;
        private int currentSize = this.incrementalSize;

        public int getCurrentSize() {
            return this.index;
        }

        public int[] getHashcodes() {
            if (this.iSwitch == 1) {
                return this.hashcodes1;
            }
            return this.hashcodes2;
        }

        public int[] getLengths() {
            if (this.iSwitch == 1) {
                return this.lengths1;
            }
            return this.lengths2;
        }

        public void addEntry(int n, int n2) {
            if (this.iSwitch == 1) {
                if (this.index < this.currentSize) {
                    this.hashcodes1[this.index] = n;
                    this.lengths1[this.index] = n2;
                    ++this.index;
                } else {
                    this.currentSize += this.incrementalSize;
                    this.hashcodes2 = new int[this.currentSize];
                    this.lengths2 = new int[this.currentSize];
                    System.arraycopy(this.hashcodes1, 0, this.hashcodes2, 0, this.hashcodes1.length);
                    System.arraycopy(this.lengths1, 0, this.lengths2, 0, this.lengths1.length);
                    this.iSwitch = 2;
                    this.hashcodes2[this.index] = n;
                    this.lengths2[this.index] = n2;
                    ++this.index;
                }
            } else if (this.index < this.currentSize) {
                this.hashcodes2[this.index] = n;
                this.lengths2[this.index] = n2;
                ++this.index;
            } else {
                this.currentSize += this.incrementalSize;
                this.hashcodes1 = new int[this.currentSize];
                this.lengths1 = new int[this.currentSize];
                System.arraycopy(this.hashcodes2, 0, this.hashcodes1, 0, this.hashcodes2.length);
                System.arraycopy(this.lengths2, 0, this.lengths1, 0, this.lengths2.length);
                this.iSwitch = 1;
                this.hashcodes1[this.index] = n;
                this.lengths1[this.index] = n2;
                ++this.index;
            }
        }
    }
}

