/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.spec.AlgorithmParameterSpec;
import javax.security.auth.DestroyFailedException;

final class RSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateKey,
Serializable {
    static final long serialVersionUID = -5387735831354112582L;
    private BigInteger modulus;
    private BigInteger privateExponent;
    private AlgorithmParameterSpec keyParams;
    private BigInteger publicExponent = BigInteger.ZERO;
    private BigInteger primeP = BigInteger.ZERO;
    private BigInteger primeQ = BigInteger.ZERO;
    private BigInteger primeExponentP = BigInteger.ZERO;
    private BigInteger primeExponentQ = BigInteger.ZERO;
    private BigInteger crtCoefficient = BigInteger.ZERO;
    private static final String[] z;

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.a(this.algid, bigInteger, bigInteger2);
    }

    public RSAPrivateKey(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.a(algorithmId, bigInteger, bigInteger2);
    }

    public static RSAPrivateKey newKey(byte[] byArray) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(byArray);
        return rSAPrivateKey;
    }

    public static RSAPrivateKey newKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(bigInteger, bigInteger2);
        return rSAPrivateKey;
    }

    private void a(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = algorithmId;
        this.modulus = bigInteger;
        this.privateExponent = bigInteger2;
        this.keyParams = RSAUtil.getParamSpec((AlgorithmId)algorithmId);
        RSAKeyFactory.b(this.modulus.bitLength(), null);
        try {
            this.key = RSAPrivateKey.a(bigInteger, bigInteger2);
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[1] + iOException.getMessage());
        }
    }

    public RSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    protected void parseKeyBits() throws IOException {
        block7: {
            try {
                block6: {
                    DerValue derValue = new DerValue(this.key);
                    int n2 = derValue.getData().getInteger().intValue();
                    if (n2 != 0) break block6;
                    this.modulus = derValue.getData().getPositiveBigInteger();
                    this.publicExponent = derValue.getData().getPositiveBigInteger();
                    this.privateExponent = derValue.getData().getPositiveBigInteger();
                    this.primeP = derValue.getData().getPositiveBigInteger();
                    this.primeQ = derValue.getData().getPositiveBigInteger();
                    this.primeExponentP = derValue.getData().getPositiveBigInteger();
                    this.primeExponentQ = derValue.getData().getPositiveBigInteger();
                    this.crtCoefficient = derValue.getData().getPositiveBigInteger();
                    if (derValue.getData().available() == 0) break block7;
                    throw new IOException(z[3]);
                }
                this.a();
            }
            catch (IOException iOException) {
                throw new IOException(z[2], iOException);
            }
        }
    }

    private void a() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.modulus = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[0]);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger2.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    @Override
    public void destroy() throws DestroyFailedException {
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            throw new InvalidObjectException(z[4]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "-)}4\u0010\r#+\u0007/%\u0017y<\n\u00053n\u001e\u0019\u001dox%\u001d\u00164n|\\\u0001)h:\u0018\r)ly\\\u0000&\u007f4\\\u000b1n'\u000e\u0011)";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                block15: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block15;
                    n5 = n5;
                    if (n5 <= n4) break block16;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 100;
                            break;
                        }
                        case 1: {
                            n6 = 71;
                            break;
                        }
                        case 2: {
                            n6 = 11;
                            break;
                        }
                        case 3: {
                            n6 = 85;
                            break;
                        }
                        default: {
                            n6 = 124;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0007(~9\u0018D)d!\\ \u0002Yu\u0019\n$d1\u0019^g";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "-)}4\u0010\r#+\u0007/%g{'\u0015\u0012&\u007f0\\\u000f\"r";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "-)}4\u0010\r#+\u0007/%\u0017y<\n\u00053n\u001e\u0019\u001dgn;\u001f\u000b#b;\u001bHgo4\b\u0005gd#\u0019\u00165~;";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "6\u0014J\u0005\u000e\r1j!\u0019/\"ru\u0017\u0001>xu\u001d\u0016\"+;\u0013\u0010go<\u000e\u0001$\u007f9\u0005D#n&\u0019\u0016.j9\u0015\u001e&i9\u0019";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

