/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.utils.URI;

public class SystemIDResolver {
    public static String getAbsoluteURIFromRelative(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = string;
        if (!SystemIDResolver.isAbsolutePath(string)) {
            try {
                string2 = SystemIDResolver.getAbsolutePathFromRelativePath(string);
            }
            catch (SecurityException securityException) {
                return "file:" + string;
            }
        }
        String string3 = null != string2 ? (string2.startsWith(File.separator) ? "file://" + string2 : "file:///" + string2) : "file:" + string;
        return SystemIDResolver.replaceChars(string3);
    }

    private static String getAbsolutePathFromRelativePath(String string) {
        final StreamSource streamSource = new StreamSource();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                streamSource.setSystemId(new File(""));
                return null;
            }
        });
        String string2 = streamSource.getSystemId() + '/';
        String string3 = string2 + string;
        return string3.substring(8);
    }

    public static boolean isAbsoluteURI(String string) {
        if (SystemIDResolver.isWindowsAbsolutePath(string)) {
            return false;
        }
        int n = string.indexOf(35);
        int n2 = string.indexOf(63);
        int n3 = string.indexOf(47);
        int n4 = string.indexOf(58);
        int n5 = string.length() - 1;
        if (n > 0) {
            n5 = n;
        }
        if (n2 > 0 && n2 < n5) {
            n5 = n2;
        }
        if (n3 > 0 && n3 < n5) {
            n5 = n3;
        }
        return n4 > 0 && n4 < n5;
    }

    public static boolean isAbsolutePath(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        return file.isAbsolute();
    }

    private static boolean isWindowsAbsolutePath(String string) {
        if (!SystemIDResolver.isAbsolutePath(string)) {
            return false;
        }
        return string.length() > 2 && string.charAt(1) == ':' && Character.isLetter(string.charAt(0)) && (string.charAt(2) == '\\' || string.charAt(2) == '/');
    }

    private static String replaceChars(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c == ' ') {
                stringBuffer.setCharAt(i, '%');
                stringBuffer.insert(i + 1, "20");
                n += 2;
                i += 2;
                continue;
            }
            if (c != '\\') continue;
            stringBuffer.setCharAt(i, '/');
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAbsoluteURI(String string) {
        int n;
        String string2 = string;
        if (!SystemIDResolver.isAbsoluteURI(string)) return SystemIDResolver.getAbsoluteURIFromRelative(string);
        if (!string.startsWith("file:")) return string;
        String string3 = string.substring(5);
        if (string3 == null || !string3.startsWith("/")) return SystemIDResolver.getAbsoluteURIFromRelative(string.substring(5));
        if (!string3.startsWith("///") && string3.startsWith("//") || (n = string.indexOf(58, 5)) <= 0) return SystemIDResolver.replaceChars(string2);
        String string4 = string.substring(n - 1);
        try {
            if (SystemIDResolver.isAbsolutePath(string4)) return SystemIDResolver.replaceChars(string2);
            string2 = string.substring(0, n - 1) + SystemIDResolver.getAbsolutePathFromRelativePath(string4);
            return SystemIDResolver.replaceChars(string2);
        }
        catch (SecurityException securityException) {
            return string;
        }
    }

    public static String getAbsoluteURI(String string, String string2) throws TransformerException {
        if (string2 == null) {
            return SystemIDResolver.getAbsoluteURI(string);
        }
        String string3 = SystemIDResolver.getAbsoluteURI(string2);
        URI uRI = null;
        try {
            URI uRI2 = new URI(string3);
            uRI = new URI(uRI2, string);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new TransformerException(malformedURIException);
        }
        return SystemIDResolver.replaceChars(uRI.toString());
    }
}

