/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.utils.XylemError;

public class PrimitiveArithmeticEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        PrimitiveArithmeticInstruction primitiveArithmeticInstruction = (PrimitiveArithmeticInstruction)instruction;
        partialInformationCollector.partiallyEvaluate(primitiveArithmeticInstruction.getOperand1(), letChainManager);
        partialInformationCollector.partiallyEvaluate(primitiveArithmeticInstruction.getOperand2(), letChainManager);
        Object object = PartialEvaluator.extractLiteralValue(partialInformationCollector, primitiveArithmeticInstruction.getOperand1(), letChainManager);
        Object object2 = PartialEvaluator.extractLiteralValue(partialInformationCollector, primitiveArithmeticInstruction.getOperand2(), letChainManager);
        Type type = partialInformationCollector.resolveType(primitiveArithmeticInstruction);
        if (!(type instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Only numerical types are supported by the numerical operators; found " + type);
        }
        INumericalType iNumericalType = (INumericalType)((Object)type);
        if (object == null || object2 == null) {
            return PartialEvaluationResult.s_emptyResult;
        }
        return new PartialEvaluationResult(new LiteralInstruction(type, iNumericalType.evaluateOperation(object, object2, primitiveArithmeticInstruction.getOperation())));
    }
}

