/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.Instruction;
import com.ibm.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.ArrayList;
import java.util.Iterator;

public class DeepEqualityEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        DeepEqualityInstruction deepEqualityInstruction = (DeepEqualityInstruction)instruction;
        partialInformationCollector.partiallyEvaluate(deepEqualityInstruction.getOperand1(), letChainManager);
        partialInformationCollector.partiallyEvaluate(deepEqualityInstruction.getOperand2(), letChainManager);
        Instruction instruction2 = letChainManager.lookupBinding(deepEqualityInstruction.getOperand1());
        Instruction instruction3 = letChainManager.lookupBinding(deepEqualityInstruction.getOperand2());
        if (instruction2 == null || instruction3 == null) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (instruction2 instanceof LiteralInstruction && instruction3 instanceof LiteralInstruction) {
            return new PartialEvaluationResult(((LiteralInstruction)instruction2).getValue().equals(((LiteralInstruction)instruction3).getValue()) ? LiteralInstruction.booleanTrueLiteral() : LiteralInstruction.booleanFalseLiteral());
        }
        if (instruction2 instanceof StreamInstruction && instruction3 instanceof StreamInstruction) {
            ArrayList arrayList = new ArrayList();
            DeepEqualityEvaluator.accumulateStream((StreamInstruction)instruction2, arrayList, partialInformationCollector, letChainManager);
            ArrayList arrayList2 = new ArrayList();
            DeepEqualityEvaluator.accumulateStream((StreamInstruction)instruction3, arrayList2, partialInformationCollector, letChainManager);
            if (arrayList.size() != arrayList2.size()) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() instanceof LiteralInstruction) continue;
                    return PartialEvaluationResult.s_emptyResult;
                }
                iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() instanceof LiteralInstruction) continue;
                    return PartialEvaluationResult.s_emptyResult;
                }
                return new PartialEvaluationResult(LiteralInstruction.booleanFalseLiteral());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Instruction instruction4;
                Instruction instruction5 = (Instruction)arrayList.get(i);
                if (instruction5 == null ^ (instruction4 = (Instruction)arrayList2.get(i)) == null) {
                    return new PartialEvaluationResult(LiteralInstruction.booleanFalseLiteral());
                }
                if (instruction5 instanceof LiteralInstruction && instruction4 instanceof LiteralInstruction) {
                    if (((LiteralInstruction)instruction5).getValue().equals(((LiteralInstruction)instruction4).getValue())) continue;
                    return new PartialEvaluationResult(LiteralInstruction.booleanFalseLiteral());
                }
                if (instruction5 == null || instruction5.equals(instruction4)) continue;
                return PartialEvaluationResult.s_emptyResult;
            }
            return new PartialEvaluationResult(LiteralInstruction.booleanTrueLiteral());
        }
        return PartialEvaluationResult.s_emptyResult;
    }
}

