/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TagType;
import com.ibm.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.LinkedList;

public class UntagStreamInstruction
extends UnaryPrimopInstruction {
    protected String m_tag;
    protected Type m_elementType;

    public UntagStreamInstruction(String string, Instruction instruction) {
        super(instruction);
        this.m_tag = string;
    }

    public UntagStreamInstruction() {
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        return this.m_operand.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker, string, bl);
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        this.m_operand.generateCode(bCELCodeGenerationHelper, codeGenerationTracker, string, instructionHandle, instructionListBuilder);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_elementType = new TypeVariable();
        TagType tagType = new TagType(this.m_tag, this.m_elementType);
        typeEnvironment.unify(this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList), tagType.getStreamType(), this);
        return this.setCachedType(this.m_elementType.getStreamType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_elementType.getStreamType();
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
        this.setupType(reductionHelper.m_typeEnvironment, bindingEnvironment);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        this.setupType(typeEnvironment, bindingEnvironment);
    }

    protected void setupType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = this.m_operand.getType(typeEnvironment, bindingEnvironment);
        if (type instanceof StreamType && ((StreamType)type).getElementType() instanceof TagType) {
            this.m_elementType = ((TagType)((StreamType)type).getElementType()).getElementType();
        } else if (this.m_elementType == null) {
            this.m_elementType = new TypeVariable();
        }
        try {
            typeEnvironment.unify(new TagType(this.m_tag, this.m_elementType).getStreamType(), this.m_operand.getType(typeEnvironment, bindingEnvironment), this);
        }
        catch (TypeCheckException typeCheckException) {
            typeCheckException.printStackTrace();
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new UntagStreamInstruction(this.m_tag, this.m_operand.cloneWithoutTypeInformation());
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new UntagStreamInstruction(this.m_tag, instruction);
    }

    @Override
    public String innerToString() {
        return "untag-stream " + this.m_tag;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && ((UntagStreamInstruction)object).m_tag.equals(this.m_tag);
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Object object = this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_tag = readObjectFileHelper.readString();
        this.m_elementType = readObjectFileHelper.readType();
        if (this.m_elementType == null) {
            throw new RuntimeException();
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_tag);
        writeObjectFileHelper.writeType(this.m_elementType);
    }

    @Override
    public boolean isStatic(BindingEnvironment bindingEnvironment) {
        return this.m_operand.isStatic(bindingEnvironment);
    }

    @Override
    public Type getTypeParameter(int n) {
        if (n == 0) {
            return this.m_elementType;
        }
        return null;
    }

    @Override
    public void setTypeParameter(int n, Type type) {
        if (n == 0) {
            this.m_elementType = type;
        }
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_elementType == null ? 0 : 1;
    }
}

