/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import java.io.IOException;
import java.util.LinkedList;

public abstract class TernaryPrimopInstruction
extends Instruction {
    protected Instruction m_operand1;
    protected Instruction m_operand2;
    protected Instruction m_operand3;

    public TernaryPrimopInstruction() {
    }

    protected TernaryPrimopInstruction(Instruction instruction, Instruction instruction2, Instruction instruction3) {
        this.m_operand1 = instruction;
        this.m_operand2 = instruction2;
        this.m_operand3 = instruction3;
    }

    public final Instruction getOperand1() {
        return this.m_operand1;
    }

    public final Instruction getOperand2() {
        return this.m_operand2;
    }

    public final Instruction getOperand3() {
        return this.m_operand3;
    }

    @Override
    public final int getChildInstructionCount() {
        return 3;
    }

    @Override
    public final Instruction getChildInstruction(int n) {
        switch (n) {
            case 0: {
                return this.m_operand1;
            }
            case 1: {
                return this.m_operand2;
            }
            case 2: {
                return this.m_operand3;
            }
        }
        return null;
    }

    @Override
    public final void setChildInstruction(int n, Instruction instruction) {
        switch (n) {
            case 0: {
                this.m_operand1 = instruction;
                break;
            }
            case 1: {
                this.m_operand2 = instruction;
                break;
            }
            case 2: {
                this.m_operand3 = instruction;
            }
        }
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        Instruction instruction = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_operand1, bindingEnvironment);
        Instruction instruction2 = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_operand2, bindingEnvironment);
        Instruction instruction3 = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_operand3, bindingEnvironment);
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
        this.m_operand1 = instruction;
        this.m_operand2 = instruction2;
        this.m_operand3 = instruction3;
    }

    public abstract Instruction cloneWithoutTypeInformation(Instruction var1, Instruction var2, Instruction var3);

    @Override
    public Instruction cloneShallow() {
        return this.cloneWithoutTypeInformation(this.m_operand1, this.m_operand2, this.m_operand3);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_operand1 = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_operand2 = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_operand3 = readObjectFileHelper.readInstruction(bindingEnvironment);
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_operand1);
        writeObjectFileHelper.writeInstruction(this.m_operand2);
        writeObjectFileHelper.writeInstruction(this.m_operand3);
    }

    @Override
    public Instruction cloneReduced() {
        return this.cloneShallow();
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
    }
}

