/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TypeVariable;
import java.util.LinkedList;

public class StreamElementInstruction
extends BinaryPrimopInstruction {
    protected Type m_elementType;

    public StreamElementInstruction() {
    }

    public StreamElementInstruction(Instruction instruction, Instruction instruction2) {
        super(instruction, instruction2);
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_elementType;
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        super.generateReducedForm(reductionHelper, instructionArray, bindingEnvironment);
        this.setupType(reductionHelper.m_typeEnvironment, bindingEnvironment);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        this.setupType(typeEnvironment, bindingEnvironment);
    }

    protected void setupType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = this.m_operand1.getType(typeEnvironment, bindingEnvironment);
        if (type instanceof StreamType) {
            this.m_elementType = ((StreamType)type).getElementType();
        } else if (this.m_elementType == null) {
            this.m_elementType = new TypeVariable();
            try {
                typeEnvironment.unify(this.m_elementType.getStreamType(), this.m_operand1.getType(typeEnvironment, bindingEnvironment), this);
            }
            catch (TypeCheckException typeCheckException) {
                typeCheckException.printStackTrace();
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new StreamElementInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        TypeVariable typeVariable = new TypeVariable();
        typeEnvironment.unify(this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList), typeVariable.getStreamType(), this);
        typeEnvironment.unify(this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList), IntType.s_intType, this);
        return this.setCachedType(typeVariable);
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
        String string3 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
        String string4 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        dataFlowCodeGenerationHelper.appendAssignment(string4, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string2 + "[" + string3 + "]", codeGenerationTracker);
        return string4;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        codeGenerationTracker.generateConventionally(this.m_operand1, bCELCodeGenerationHelper, null, instructionListBuilder);
        codeGenerationTracker.generateConventionally(this.m_operand2, bCELCodeGenerationHelper, null, instructionListBuilder);
        instructionListBuilder.appendArrayLoad(codeGenerationTracker.resolveType(this));
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        IStream iStream = (IStream)this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false);
        Integer n = (Integer)this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false);
        int n2 = n;
        Object object = iStream.get(n2);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }

    @Override
    public String innerToString() {
        return "stream-element";
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction, Instruction instruction2) {
        return new StreamElementInstruction(instruction, instruction2);
    }
}

