/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.StringStream;
import com.ibm.xylem.parser.ClassLoaderSourceResolver;
import com.ibm.xylem.parser.Parser;
import com.ibm.xylem.parser.ParserSource;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.TypeVariable;
import java.io.StringReader;
import java.util.LinkedList;

public class EvalInstruction
extends UnaryPrimopInstruction {
    private Instruction m_script;
    private Type m_type;

    public EvalInstruction(Type type, Instruction instruction) {
        this.m_script = instruction;
        this.m_type = type;
        if (type == null) {
            this.m_type = new TypeVariable();
        }
    }

    public EvalInstruction(Type type, String string) {
        this(type, StreamInstruction.charStreamLiteral(string));
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new EvalInstruction(this.m_type, instruction);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        Type type = this.m_script.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        typeEnvironment.unify(type, CharType.s_charType.getStreamType(), this);
        return this.m_type;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_type;
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        throw new UnsupportedOperationException("codegen Eval");
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new EvalInstruction(this.m_type, this.m_script.cloneWithoutTypeInformation());
    }

    @Override
    public Type getTypeParameter(int n) {
        return n == 0 ? this.m_type : null;
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Instruction instruction;
        ClassLoaderSourceResolver classLoaderSourceResolver = new ClassLoaderSourceResolver();
        StringStream stringStream = (StringStream)this.m_script.evaluate(environment, function, iDebuggerInterceptor, false);
        Parser parser = new Parser(classLoaderSourceResolver, new ParserSource(new StringReader(stringStream.toString())));
        try {
            instruction = parser.parseExpression(function.getTypeEnvironment().getModule());
        }
        catch (Exception exception) {
            s_logger.error("error parsing script : " + this.m_script, exception);
            throw new Error();
        }
        return instruction.evaluate(environment, function, iDebuggerInterceptor, false);
    }

    @Override
    public String innerToString() {
        return "eval";
    }
}

