/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen.bcel;

import com.ibm.xtq.bcel.generic.ALOAD;
import com.ibm.xtq.bcel.generic.ASTORE;
import com.ibm.xtq.bcel.generic.ATHROW;
import com.ibm.xtq.bcel.generic.BIPUSH;
import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.BranchInstruction;
import com.ibm.xtq.bcel.generic.DLOAD;
import com.ibm.xtq.bcel.generic.GOTO;
import com.ibm.xtq.bcel.generic.GOTO_W;
import com.ibm.xtq.bcel.generic.IFEQ;
import com.ibm.xtq.bcel.generic.IFLE;
import com.ibm.xtq.bcel.generic.IFNE;
import com.ibm.xtq.bcel.generic.IFNONNULL;
import com.ibm.xtq.bcel.generic.IFNULL;
import com.ibm.xtq.bcel.generic.IF_ACMPEQ;
import com.ibm.xtq.bcel.generic.IF_ACMPNE;
import com.ibm.xtq.bcel.generic.IF_ICMPEQ;
import com.ibm.xtq.bcel.generic.IF_ICMPGE;
import com.ibm.xtq.bcel.generic.IF_ICMPLE;
import com.ibm.xtq.bcel.generic.IF_ICMPNE;
import com.ibm.xtq.bcel.generic.IINC;
import com.ibm.xtq.bcel.generic.ILOAD;
import com.ibm.xtq.bcel.generic.ISTORE;
import com.ibm.xtq.bcel.generic.Instruction;
import com.ibm.xtq.bcel.generic.InstructionConstants;
import com.ibm.xtq.bcel.generic.InstructionFactory;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.MethodGen;
import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xtq.bcel.generic.PUSH;
import com.ibm.xylem.Type;
import com.ibm.xylem.codegen.CodeGeneration;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.ClassGenerationHelper;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.JavaObjectType;

public final class InstructionListBuilder {
    protected BCELCodeGenerationHelper m_cg;
    protected ClassGenerationHelper m_cgh;
    protected InstructionList m_il;
    protected boolean m_useStaticThisField = false;
    protected boolean m_staticContext = false;
    protected MethodGen m_mg;

    public InstructionListBuilder(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionList instructionList, ClassGenerationHelper classGenerationHelper) {
        this.m_cg = bCELCodeGenerationHelper;
        this.m_il = instructionList;
        this.m_cgh = classGenerationHelper;
    }

    public InstructionListBuilder(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionList instructionList, ClassGenerationHelper classGenerationHelper, MethodGen methodGen) {
        this(bCELCodeGenerationHelper, instructionList, classGenerationHelper);
        this.setMethodGen(methodGen);
    }

    public void setMethodGen(MethodGen methodGen) {
        this.m_mg = methodGen;
    }

    public void addExceptionHandler(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3, ObjectType objectType) {
        this.m_mg.addExceptionHandler(instructionHandle, instructionHandle2, instructionHandle3, objectType);
    }

    public void setStaticContext() {
        this.m_staticContext = true;
    }

    public boolean isStaticContext() {
        return this.m_staticContext;
    }

    public BCELCodeGenerationHelper getCodeGenerationHelper() {
        return this.m_cg;
    }

    public InstructionList getInstructionList() {
        return this.m_il;
    }

    public ClassGenerationHelper getClassGenerationHelper() {
        return this.m_cgh;
    }

    public InstructionHandle append(InstructionList instructionList) {
        return this.m_il.append(instructionList);
    }

    public InstructionHandle append(Instruction instruction) {
        return this.m_il.append(instruction);
    }

    public InstructionHandle append(BranchInstruction branchInstruction) {
        return this.m_il.append(branchInstruction);
    }

    public InstructionHandle appendConstant(int n) {
        return this.m_il.append(new PUSH(this.m_cgh.m_cpg, n));
    }

    public InstructionHandle appendBIPush(byte by) {
        return this.m_il.append(new BIPUSH(by));
    }

    public InstructionHandle appendCast(Type type, Type type2) {
        return this.appendCast(type.getImplementationType(this.m_cg), type2.getImplementationType(this.m_cg));
    }

    public InstructionHandle appendCast(com.ibm.xtq.bcel.generic.Type type, com.ibm.xtq.bcel.generic.Type type2) {
        if (type2.equals(BasicType.INT) && (type.equals(BasicType.CHAR) || type.equals(BasicType.SHORT) || type.equals(BasicType.BOOLEAN) || type.equals(BasicType.BYTE))) {
            return this.appendNOP();
        }
        return this.m_il.append(this.m_cgh.m_if.createCast(type, type2));
    }

    public InstructionHandle appendConstant(boolean bl) {
        return this.m_il.append(new PUSH(this.m_cgh.m_cpg, bl));
    }

    public InstructionHandle appendConstant(double d) {
        return this.m_il.append(new PUSH(this.m_cgh.m_cpg, d));
    }

    public InstructionHandle appendNull() {
        return this.m_il.append(InstructionConstants.ACONST_NULL);
    }

    public InstructionHandle appendConstant(String string) {
        if (this.m_cg.getSettings().isExternalizeStrings() && string != null && string.length() >= 3 && this.m_cg.m_staticILB != null) {
            return this.m_cg.appendExternalizedStringConstant(string, this);
        }
        return this.m_il.append(new PUSH(this.m_cgh.m_cpg, string));
    }

    public InstructionHandle appendConstant(Object object) {
        if (object == null) {
            return this.appendNull();
        }
        if (object instanceof Number) {
            return this.m_il.append(new PUSH(this.m_cgh.m_cpg, (Number)object));
        }
        if (object instanceof String) {
            return this.appendConstant((String)object);
        }
        if (object instanceof Character) {
            return this.m_il.append(new PUSH(this.m_cgh.m_cpg, (Character)object));
        }
        if (object instanceof Boolean) {
            return this.m_il.append(new PUSH(this.m_cgh.m_cpg, (Boolean)object));
        }
        if (object instanceof Class) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public InstructionHandle appendGoto(InstructionHandle instructionHandle) {
        return this.m_il.append(new GOTO(instructionHandle));
    }

    public BranchInstruction appendGoto() {
        GOTO_W gOTO_W = new GOTO_W(null);
        this.m_il.append(gOTO_W);
        return gOTO_W;
    }

    public BranchInstruction appendIfne() {
        IFNE iFNE = new IFNE(null);
        this.m_il.append(iFNE);
        return iFNE;
    }

    public InstructionHandle appendIfne(InstructionHandle instructionHandle) {
        return this.m_il.append(new IFNE(instructionHandle));
    }

    public BranchInstruction appendIfle() {
        IFLE iFLE = new IFLE(null);
        this.m_il.append(iFLE);
        return iFLE;
    }

    public BranchInstruction appendIfeq() {
        IFEQ iFEQ = new IFEQ(null);
        this.m_il.append(iFEQ);
        return iFEQ;
    }

    public BranchInstruction appendIfnull() {
        IFNULL iFNULL = new IFNULL(null);
        this.m_il.append(iFNULL);
        return iFNULL;
    }

    public BranchInstruction appendIfnonnull() {
        IFNONNULL iFNONNULL = new IFNONNULL(null);
        this.m_il.append(iFNONNULL);
        return iFNONNULL;
    }

    public BranchInstruction appendIficmpne() {
        IF_ICMPNE iF_ICMPNE = new IF_ICMPNE(null);
        this.m_il.append(iF_ICMPNE);
        return iF_ICMPNE;
    }

    public BranchInstruction appendIficmpeq() {
        IF_ICMPEQ iF_ICMPEQ = new IF_ICMPEQ(null);
        this.m_il.append(iF_ICMPEQ);
        return iF_ICMPEQ;
    }

    public BranchInstruction appendIfacmpeq() {
        IF_ACMPEQ iF_ACMPEQ = new IF_ACMPEQ(null);
        this.m_il.append(iF_ACMPEQ);
        return iF_ACMPEQ;
    }

    public BranchInstruction appendIfacmpne() {
        IF_ACMPNE iF_ACMPNE = new IF_ACMPNE(null);
        this.m_il.append(iF_ACMPNE);
        return iF_ACMPNE;
    }

    public BranchInstruction appendIficmpge() {
        IF_ICMPGE iF_ICMPGE = new IF_ICMPGE(null);
        this.m_il.append(iF_ICMPGE);
        return iF_ICMPGE;
    }

    public BranchInstruction appendIficmple() {
        IF_ICMPLE iF_ICMPLE = new IF_ICMPLE(null);
        this.m_il.append(iF_ICMPLE);
        return iF_ICMPLE;
    }

    public InstructionHandle appendNewArray(com.ibm.xtq.bcel.generic.Type type, int n) {
        InstructionHandle instructionHandle = this.appendConstant(n);
        this.append(this.m_cgh.m_if.createNewArray(type, (short)1));
        return instructionHandle;
    }

    public InstructionHandle appendNewArray(Type type) {
        return this.append(this.m_cgh.m_if.createNewArray(type.getImplementationType(this.m_cg), (short)1));
    }

    public InstructionHandle appendNewArray(com.ibm.xtq.bcel.generic.Type type) {
        return this.append(this.m_cgh.m_if.createNewArray(type, (short)1));
    }

    public InstructionHandle appendReturn(Type type) {
        return this.append(InstructionFactory.createReturn(type.getImplementationType(this.m_cg)));
    }

    public InstructionHandle appendReturn(com.ibm.xtq.bcel.generic.Type type) {
        return this.append(InstructionFactory.createReturn(type));
    }

    public InstructionHandle appendReturn() {
        return this.append(InstructionConstants.RETURN);
    }

    public InstructionHandle appendAReturn() {
        return this.append(InstructionConstants.ARETURN);
    }

    public InstructionHandle appendStore(com.ibm.xtq.bcel.generic.Type type, int n) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return this.m_il.append(InstructionFactory.createStore(type, n));
    }

    public InstructionHandle appendAStore(int n) {
        return this.m_il.append(new ASTORE(n));
    }

    public InstructionHandle appendCAStore() {
        return this.m_il.append(InstructionConstants.CASTORE);
    }

    public InstructionHandle appendIStore(int n) {
        return this.m_il.append(new ISTORE(n));
    }

    public void useStaticThisField() {
        this.m_useStaticThisField = true;
    }

    public InstructionHandle appendThis() {
        InstructionHandle instructionHandle = this.appendALoad(0);
        if (this.m_useStaticThisField) {
            this.appendGetField(this.m_cgh.m_cg.getClassName(), "m___this__", new ObjectType(this.m_cg.getClassName()));
        }
        return instructionHandle;
    }

    public InstructionHandle appendGetIntField(String string) {
        InstructionHandle instructionHandle = this.appendThis();
        this.m_il.append(this.m_cgh.m_if.createGetField(this.m_cg.getClassName(), string, BasicType.INT));
        return instructionHandle;
    }

    public InstructionHandle appendGetField(String string, com.ibm.xtq.bcel.generic.Type type) {
        InstructionHandle instructionHandle = this.appendThis();
        this.m_il.append(this.m_cgh.m_if.createGetField(this.m_cg.getClassName(), string, type));
        return instructionHandle;
    }

    public InstructionHandle appendGetField(AbstractDataType.Constructor constructor, int n, CodeGeneration codeGeneration) {
        return this.m_il.append(this.m_cgh.m_if.createGetField(constructor.getAbstractDataType().getImplementationName(this.m_cg), constructor.getConstructorQualifiedFieldName(n, codeGeneration), constructor.getParameterTypes()[n].getImplementationType(this.m_cg)));
    }

    public InstructionHandle appendGetField(String string, String string2, com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(this.m_cgh.m_if.createGetField(string, string2, type));
    }

    public InstructionHandle appendGetField(String string, String string2, Type type) {
        return this.m_il.append(this.m_cgh.m_if.createGetField(string, string2, type.getImplementationType(this.m_cg)));
    }

    public InstructionHandle appendGetStatic(String string, com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(this.m_cgh.m_if.createGetStatic(this.m_cg.getClassName(), string, type));
    }

    public InstructionHandle appendGetStatic(String string, String string2, com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(this.m_cgh.m_if.createGetStatic(string, string2, type));
    }

    public InstructionHandle appendPutStatic(String string, com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(this.m_cgh.m_if.createPutStatic(this.m_cg.getClassName(), string, type));
    }

    public InstructionHandle appendPutStatic(String string, String string2, com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(this.m_cgh.m_if.createPutStatic(string, string2, type));
    }

    public InstructionHandle appendPlusPlus() {
        InstructionHandle instructionHandle = this.appendConstant(1);
        this.m_il.append(InstructionConstants.IADD);
        return instructionHandle;
    }

    public InstructionHandle appendArrayLength() {
        return this.m_il.append(InstructionConstants.ARRAYLENGTH);
    }

    public InstructionHandle appendFieldPlusPlus(String string) {
        InstructionHandle instructionHandle = this.appendGetIntField(string);
        this.appendDUP();
        this.appendPlusPlus();
        this.appendPutIntField(string);
        return instructionHandle;
    }

    public InstructionHandle appendFieldDecrement(String string) {
        InstructionHandle instructionHandle = this.appendGetIntField(string);
        this.appendConstant(1);
        this.appendISub();
        this.appendPutIntField(string);
        return instructionHandle;
    }

    public InstructionHandle appendLocalPlusPlus(int n) {
        InstructionHandle instructionHandle = this.appendILoad(n);
        this.appendLocalIncrement(n);
        return instructionHandle;
    }

    public InstructionHandle appendLocalDecrement(int n) {
        InstructionHandle instructionHandle = this.appendILoad(n);
        this.appendConstant(1);
        this.appendISub();
        this.appendIStore(n);
        return instructionHandle;
    }

    public InstructionHandle appendLocalIncrement(int n) {
        if (n < 255) {
            return this.append(new IINC(n, 1));
        }
        InstructionHandle instructionHandle = this.appendILoad(n);
        this.appendConstant(1);
        this.appendIAdd();
        this.appendIStore(n);
        return instructionHandle;
    }

    public InstructionHandle appendAALoad() {
        return this.m_il.append(InstructionConstants.AALOAD);
    }

    public InstructionHandle appendAAStore() {
        return this.m_il.append(InstructionConstants.AASTORE);
    }

    public InstructionHandle appendSystemArrayCopy() {
        return this.m_il.append(this.m_cgh.m_if.createInvoke("java.lang.System", "arraycopy", BasicType.VOID, new com.ibm.xtq.bcel.generic.Type[]{BasicType.OBJECT, BasicType.INT, BasicType.OBJECT, BasicType.INT, BasicType.INT}, (short)184));
    }

    public InstructionHandle appendPutIntField(String string) {
        InstructionHandle instructionHandle = this.appendThis();
        this.m_il.append(InstructionConstants.SWAP);
        this.m_il.append(this.m_cgh.m_if.createPutField(this.m_cg.getClassName(), string, BasicType.INT));
        return instructionHandle;
    }

    public InstructionHandle appendPutField(com.ibm.xtq.bcel.generic.Type type, String string) {
        return this.m_il.append(this.m_cgh.m_if.createPutField(this.m_cg.getClassName(), string, type));
    }

    public InstructionHandle appendPutField(com.ibm.xtq.bcel.generic.Type type, String string, String string2) {
        return this.m_il.append(this.m_cgh.m_if.createPutField(string2, string, type));
    }

    public InstructionHandle appendPutField(com.ibm.xtq.bcel.generic.Type type, String string, com.ibm.xtq.bcel.generic.Type type2) {
        return this.m_il.append(this.m_cgh.m_if.createPutField(((ObjectType)type2).getClassName(), string, type));
    }

    public InstructionHandle appendPutField(com.ibm.xtq.bcel.generic.Type type, String string, Type type2) {
        return this.appendPutField(type, string, type2.getImplementationType(this.m_cg));
    }

    public InstructionHandle appendPutField(AbstractDataType.Constructor constructor, int n, CodeGeneration codeGeneration) {
        return this.m_il.append(this.m_cgh.m_if.createPutField(constructor.getAbstractDataType().getImplementationName(this.m_cg), constructor.getConstructorQualifiedFieldName(n, codeGeneration), constructor.getParameterTypes()[n].getImplementationType(this.m_cg)));
    }

    public InstructionHandle appendPop(Type type) {
        return this.m_il.append(InstructionFactory.createPop(type.getImplementationType(this.m_cg).getSize()));
    }

    public InstructionHandle appendPop(com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(InstructionFactory.createPop(type.getSize()));
    }

    public InstructionHandle appendPop() {
        return this.m_il.append(InstructionFactory.createPop(1));
    }

    public InstructionHandle appendStore(Type type, int n) {
        return this.m_il.append(InstructionFactory.createStore(type.getImplementationType(this.m_cg), n));
    }

    public InstructionHandle appendLoad(com.ibm.xtq.bcel.generic.Type type, int n) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return this.m_il.append(InstructionFactory.createLoad(type, n));
    }

    public InstructionHandle appendALoad(int n) {
        return this.m_il.append(new ALOAD(n));
    }

    public InstructionHandle appendDLoad(int n) {
        return this.m_il.append(new DLOAD(n));
    }

    public InstructionHandle appendILoad(int n) {
        return this.m_il.append(new ILOAD(n));
    }

    public InstructionHandle appendNewAndInvokeConstructor(String string, Type type) {
        return this.appendNewAndInvokeConstructor(string, type.getImplementationType(this.m_cg));
    }

    public InstructionHandle appendNewAndInvokeConstructor(com.ibm.xtq.bcel.generic.Type type, Type type2) {
        return this.appendNewAndInvokeConstructor(((ObjectType)type).getClassName(), type2.getImplementationType(this.m_cg));
    }

    public InstructionHandle appendNewAndInvokeConstructor(com.ibm.xtq.bcel.generic.Type type, com.ibm.xtq.bcel.generic.Type type2) {
        return this.appendNewAndInvokeConstructor(((ObjectType)type).getClassName(), type2);
    }

    public InstructionHandle appendNewAndInvokeConstructor(String string, com.ibm.xtq.bcel.generic.Type type) {
        if (type.getSize() != 1) {
            throw new UnsupportedOperationException();
        }
        InstructionHandle instructionHandle = this.appendNew(string);
        this.appendDUP_X1();
        this.appendSwap();
        this.m_il.append(this.m_cgh.m_if.createInvoke(string, "<init>", com.ibm.xtq.bcel.generic.Type.VOID, new com.ibm.xtq.bcel.generic.Type[]{type}, (short)183));
        return instructionHandle;
    }

    public InstructionHandle appendNewAndInvokeConstructor(String string) {
        InstructionHandle instructionHandle = this.appendNew(string);
        this.appendDUP();
        this.m_il.append(this.m_cgh.m_if.createInvoke(string, "<init>", com.ibm.xtq.bcel.generic.Type.VOID, com.ibm.xtq.bcel.generic.Type.NO_ARGS, (short)183));
        return instructionHandle;
    }

    public InstructionHandle appendInvokeConstructor(String string, com.ibm.xtq.bcel.generic.Type[] typeArray) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, "<init>", com.ibm.xtq.bcel.generic.Type.VOID, typeArray, (short)183));
    }

    public InstructionHandle appendInvokeConstructor(String string) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, "<init>", com.ibm.xtq.bcel.generic.Type.VOID, com.ibm.xtq.bcel.generic.Type.NO_ARGS, (short)183));
    }

    public InstructionHandle appendInvokeConstructor(String string, Type[] typeArray) {
        com.ibm.xtq.bcel.generic.Type[] typeArray2 = new com.ibm.xtq.bcel.generic.Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = typeArray[i].getImplementationType(this.m_cg);
        }
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, "<init>", com.ibm.xtq.bcel.generic.Type.VOID, typeArray2, (short)183));
    }

    public InstructionHandle appendInvokeConstructor(String string, Type type) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, "<init>", com.ibm.xtq.bcel.generic.Type.VOID, new com.ibm.xtq.bcel.generic.Type[]{type.getImplementationType(this.m_cg)}, (short)183));
    }

    public InstructionHandle appendInvokeConstructor(String string, com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, "<init>", com.ibm.xtq.bcel.generic.Type.VOID, new com.ibm.xtq.bcel.generic.Type[]{type}, (short)183));
    }

    public InstructionHandle appendInvokeMethod(String string, String string2, com.ibm.xtq.bcel.generic.Type type, com.ibm.xtq.bcel.generic.Type[] typeArray) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type, typeArray, (short)182));
    }

    public InstructionHandle appendInvokeMethod(String string, String string2, Type type, Type[] typeArray) {
        com.ibm.xtq.bcel.generic.Type[] typeArray2 = new com.ibm.xtq.bcel.generic.Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = typeArray[i].getImplementationType(this.m_cg);
        }
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type.getImplementationType(this.m_cg), typeArray2, (short)182));
    }

    public InstructionHandle appendInvokeMethod(String string, String string2, Type type, Type type2) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type.getImplementationType(this.m_cg), new com.ibm.xtq.bcel.generic.Type[]{type2.getImplementationType(this.m_cg)}, (short)182));
    }

    public InstructionHandle appendInvokeMethod(String string, String string2, com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type, com.ibm.xtq.bcel.generic.Type.NO_ARGS, (short)182));
    }

    public InstructionHandle appendInvokeMethod(String string, String string2, Type type) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type.getImplementationType(this.m_cg), com.ibm.xtq.bcel.generic.Type.NO_ARGS, (short)182));
    }

    public InstructionHandle appendStringToCharArray() {
        return this.appendInvokeMethod("java.lang.String", "toCharArray", BCELCodeGenerationHelper.s_charArrayType);
    }

    public InstructionHandle appendInvokeMethod(String string, String string2, com.ibm.xtq.bcel.generic.Type type, Type type2) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type, new com.ibm.xtq.bcel.generic.Type[]{type2.getImplementationType(this.m_cg)}, (short)182));
    }

    public InstructionHandle appendInvokeMethod(String string, String string2, com.ibm.xtq.bcel.generic.Type type, com.ibm.xtq.bcel.generic.Type type2) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type, new com.ibm.xtq.bcel.generic.Type[]{type2}, (short)182));
    }

    public InstructionHandle appendInvokeInterface(String string, String string2, Type type, Type[] typeArray) {
        com.ibm.xtq.bcel.generic.Type[] typeArray2 = new com.ibm.xtq.bcel.generic.Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = typeArray[i].getImplementationType(this.m_cg);
        }
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type.getImplementationType(this.m_cg), typeArray2, (short)185));
    }

    public InstructionHandle appendInvokeInterface(String string, String string2, com.ibm.xtq.bcel.generic.Type type, com.ibm.xtq.bcel.generic.Type type2) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type, new com.ibm.xtq.bcel.generic.Type[]{type2}, (short)185));
    }

    public InstructionHandle appendInvokeInterface(String string, String string2, com.ibm.xtq.bcel.generic.Type type, com.ibm.xtq.bcel.generic.Type[] typeArray) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type, typeArray, (short)185));
    }

    public InstructionHandle appendInvokeInterface(String string, String string2, Type type) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type.getImplementationType(this.m_cg), com.ibm.xtq.bcel.generic.Type.NO_ARGS, (short)185));
    }

    public InstructionHandle appendInvokeInterface(String string, String string2, com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type, com.ibm.xtq.bcel.generic.Type.NO_ARGS, (short)185));
    }

    public InstructionHandle appendInvokeInterface(String string, String string2) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, com.ibm.xtq.bcel.generic.Type.VOID, com.ibm.xtq.bcel.generic.Type.NO_ARGS, (short)185));
    }

    public InstructionHandle appendInvokeStatic(String string, String string2) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, com.ibm.xtq.bcel.generic.Type.VOID, com.ibm.xtq.bcel.generic.Type.NO_ARGS, (short)184));
    }

    public InstructionHandle appendInvokeStatic(String string, String string2, com.ibm.xtq.bcel.generic.Type type, com.ibm.xtq.bcel.generic.Type[] typeArray) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type, typeArray, (short)184));
    }

    public InstructionHandle appendInvokeStatic(String string, String string2, com.ibm.xtq.bcel.generic.Type type, com.ibm.xtq.bcel.generic.Type type2) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type, new com.ibm.xtq.bcel.generic.Type[]{type2}, (short)184));
    }

    public InstructionHandle appendInvokeStatic(String string, String string2, com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type, com.ibm.xtq.bcel.generic.Type.NO_ARGS, (short)184));
    }

    public InstructionHandle appendInvokeStatic(String string, String string2, Type type, Type type2) {
        return this.m_il.append(this.m_cgh.m_if.createInvoke(string, string2, type.getImplementationType(this.m_cg), new com.ibm.xtq.bcel.generic.Type[]{type2.getImplementationType(this.m_cg)}, (short)184));
    }

    public InstructionHandle appendLoad(Type type, int n) {
        return this.m_il.append(InstructionFactory.createLoad(type.getImplementationType(this.m_cg), n));
    }

    public InstructionHandle appendArrayStore(Type type) {
        return this.m_il.append(InstructionFactory.createArrayStore(type.getImplementationType(this.m_cg)));
    }

    public InstructionHandle appendArrayStore(com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(InstructionFactory.createArrayStore(type));
    }

    public InstructionHandle appendArrayLoad(Type type) {
        return this.m_il.append(InstructionFactory.createArrayLoad(type.getImplementationType(this.m_cg)));
    }

    public InstructionHandle appendArrayLoad(com.ibm.xtq.bcel.generic.Type type) {
        return this.m_il.append(InstructionFactory.createArrayLoad(type));
    }

    public InstructionHandle appendArrayLoad(int n, int n2, Type type) {
        InstructionHandle instructionHandle = this.appendALoad(n);
        this.appendILoad(n2);
        this.m_il.append(InstructionFactory.createArrayLoad(type.getImplementationType(this.m_cg)));
        return instructionHandle;
    }

    public InstructionHandle appendArrayLoad(int n, int n2, com.ibm.xtq.bcel.generic.Type type) {
        InstructionHandle instructionHandle = this.appendALoad(n);
        this.appendILoad(n2);
        this.m_il.append(InstructionFactory.createArrayLoad(type));
        return instructionHandle;
    }

    public InstructionHandle appendNOP() {
        return this.m_il.append(InstructionConstants.NOP);
    }

    public InstructionHandle appendLCmp() {
        return this.m_il.append(InstructionConstants.LCMP);
    }

    public InstructionHandle appendFCmpg() {
        return this.m_il.append(InstructionConstants.FCMPG);
    }

    public InstructionHandle appendFCmpl() {
        return this.m_il.append(InstructionConstants.FCMPL);
    }

    public InstructionHandle appendDCmpg() {
        return this.m_il.append(InstructionConstants.DCMPG);
    }

    public InstructionHandle appendDCmpl() {
        return this.m_il.append(InstructionConstants.DCMPL);
    }

    public InstructionHandle appendINeg() {
        return this.m_il.append(InstructionConstants.INEG);
    }

    public InstructionHandle appendDNeg() {
        return this.m_il.append(InstructionConstants.DNEG);
    }

    public InstructionHandle appendIAdd() {
        return this.m_il.append(InstructionConstants.IADD);
    }

    public InstructionHandle appendIAnd() {
        return this.m_il.append(InstructionConstants.IAND);
    }

    public InstructionHandle appendISub() {
        return this.m_il.append(InstructionConstants.ISUB);
    }

    public InstructionHandle appendIShl() {
        return this.m_il.append(InstructionConstants.ISHL);
    }

    public InstructionHandle appendDUP() {
        return this.m_il.append(InstructionConstants.DUP);
    }

    public InstructionHandle appendDUP2() {
        return this.m_il.append(InstructionConstants.DUP2);
    }

    public InstructionHandle appendDUP_X1() {
        return this.m_il.append(InstructionConstants.DUP_X1);
    }

    public InstructionHandle appendSwap() {
        return this.m_il.append(InstructionConstants.SWAP);
    }

    public InstructionHandle appendNew(String string) {
        return this.m_il.append(this.m_cgh.m_if.createNew(new ObjectType(string)));
    }

    public InstructionHandle appendNew(ObjectType objectType) {
        return this.m_il.append(this.m_cgh.m_if.createNew(objectType));
    }

    public InstructionHandle appendNew(Type type) {
        return this.m_il.append(this.m_cgh.m_if.createNew(new ObjectType(((JavaObjectType)type).getClassName())));
    }

    public InstructionHandle appendThrowRuntimeException(String string) {
        InstructionHandle instructionHandle = this.appendNew("java.lang.RuntimeException");
        this.appendDUP();
        this.appendConstant(string);
        this.m_il.append(this.m_cgh.m_if.createInvoke("java.lang.RuntimeException", "<init>", BasicType.VOID, new ObjectType[]{BasicType.STRING}, (short)183));
        this.m_il.append(new ATHROW());
        return instructionHandle;
    }

    public InstructionHandle appendThrowRuntimeSystemError(String string) {
        InstructionHandle instructionHandle = this.appendNew("com.ibm.xtq.xslt.runtime.RuntimeError");
        this.appendDUP();
        this.appendConstant("ERR_SYSTEM");
        this.appendConstant(string);
        this.m_il.append(this.m_cgh.m_if.createInvoke("com.ibm.xtq.xslt.runtime.RuntimeError", "<init>", BasicType.VOID, new ObjectType[]{BasicType.STRING, ObjectType.OBJECT}, (short)183));
        this.m_il.append(new ATHROW());
        return instructionHandle;
    }

    public InstructionHandle appendThrowRuntimeError(String string, String string2) {
        InstructionHandle instructionHandle = this.appendNew("com.ibm.xtq.xslt.runtime.RuntimeError");
        this.appendDUP();
        this.appendConstant(string);
        if (string2 == null) {
            this.appendNull();
        } else {
            this.appendConstant(string2);
        }
        this.m_il.append(this.m_cgh.m_if.createInvoke("com.ibm.xtq.xslt.runtime.RuntimeError", "<init>", BasicType.VOID, new ObjectType[]{BasicType.STRING, ObjectType.OBJECT}, (short)183));
        this.m_il.append(new ATHROW());
        return instructionHandle;
    }

    public InstructionHandle appendThrowRuntimeError(String string, String string2, String string3) {
        InstructionHandle instructionHandle = this.appendNew("com.ibm.xtq.xslt.runtime.RuntimeError");
        this.appendDUP();
        this.appendConstant(string);
        this.appendConstant(string2);
        this.appendConstant(string3);
        this.m_il.append(this.m_cgh.m_if.createInvoke("com.ibm.xtq.xslt.runtime.RuntimeError", "<init>", BasicType.VOID, new ObjectType[]{BasicType.STRING, ObjectType.OBJECT, ObjectType.OBJECT}, (short)183));
        this.m_il.append(new ATHROW());
        return instructionHandle;
    }
}

