/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.GenerationState;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;

public class ConventionalGenerationState
extends GenerationState {
    protected Instruction m_instruction;
    protected int m_numDependencies;
    protected String m_varName = null;
    protected int m_hits = 0;
    protected boolean m_oneTime = false;
    protected int m_register = -1;
    protected com.ibm.xtq.bcel.generic.Type m_registerType = null;
    protected Type m_type = null;

    public ConventionalGenerationState(IBinding iBinding, Instruction instruction, int n) {
        super(iBinding);
        if (iBinding instanceof Binding) {
            this.m_type = ((Binding)iBinding).getBindingType();
        }
        this.m_instruction = instruction;
        this.m_numDependencies = n;
    }

    public void setOneTime() {
        this.m_oneTime = true;
    }

    public boolean isOneTime() {
        return this.m_oneTime;
    }

    public final Instruction getInstruction() {
        return this.m_instruction;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.m_instruction;
    }

    @Override
    public boolean isGenerated() {
        return this.m_varName != null || this.m_register != -1;
    }

    public String getVariableName() {
        return this.m_varName;
    }

    public int getNumDependencies() {
        return this.m_numDependencies;
    }

    public String generate(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        if (this.isGenerated()) {
            return this.m_varName;
        }
        if (!dataFlowCodeGenerationHelper.getSettings().isSuppressComments()) {
            dataFlowCodeGenerationHelper.append("//generated conventionally by " + this.m_instruction.getClass().getName() + "\n");
        }
        this.m_varName = this.m_instruction.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker, Binding.generateVariableName(this.m_binding, dataFlowCodeGenerationHelper), bl);
        return this.m_varName;
    }

    public void generate(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, int n, InstructionListBuilder instructionListBuilder) {
        if (instructionListBuilder.isStaticContext()) {
            throw new UnsupportedOperationException();
        }
        if (this.isGenerated()) {
            if (this.m_register != n) {
                instructionListBuilder.appendLoad(this.m_registerType, this.m_register);
                instructionListBuilder.appendStore(this.m_registerType, n);
            }
            return;
        }
        this.generate(bCELCodeGenerationHelper, codeGenerationTracker, null, instructionListBuilder);
        if (this.m_registerType == null) {
            this.m_registerType = codeGenerationTracker.resolveType(this.m_instruction).getImplementationType(bCELCodeGenerationHelper);
        }
        instructionListBuilder.appendStore(this.m_registerType, n);
    }

    public int generate(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, InstructionListBuilder instructionListBuilder) {
        if (instructionListBuilder.isStaticContext()) {
            throw new UnsupportedOperationException();
        }
        if (this.isGenerated()) {
            if (this.m_register != -1) {
                return this.m_register;
            }
            int n = codeGenerationTracker.allocateRegister(this.m_registerType);
            instructionListBuilder.appendStore(this.m_registerType, n);
            return n;
        }
        this.m_instruction.generateCode(bCELCodeGenerationHelper, codeGenerationTracker, Binding.generateVariableName(this.m_binding, bCELCodeGenerationHelper), null, instructionListBuilder);
        this.m_registerType = codeGenerationTracker.resolveType(this.m_instruction).getImplementationType(bCELCodeGenerationHelper);
        this.m_register = codeGenerationTracker.allocateRegister(this.m_registerType);
        instructionListBuilder.appendStore(this.m_registerType, this.m_register);
        return this.m_register;
    }

    public void generate(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        if (instructionListBuilder.isStaticContext()) {
            this.m_instruction.generateCode(bCELCodeGenerationHelper, codeGenerationTracker, Binding.generateVariableName(this.m_binding, bCELCodeGenerationHelper), instructionHandle, instructionListBuilder);
            return;
        }
        if (this.isGenerated()) {
            instructionListBuilder.appendLoad(this.m_registerType, this.m_register);
            return;
        }
        this.m_instruction.generateCode(bCELCodeGenerationHelper, codeGenerationTracker, Binding.generateVariableName(this.m_binding, bCELCodeGenerationHelper), instructionHandle, instructionListBuilder);
        if (!this.isOneTime()) {
            com.ibm.xtq.bcel.generic.Type type = codeGenerationTracker.resolveType(this.m_instruction).getImplementationType(bCELCodeGenerationHelper);
            int n = codeGenerationTracker.allocateRegister(type);
            instructionListBuilder.appendStore(type, n);
            instructionListBuilder.appendLoad(type, n);
            this.m_register = n;
            this.m_registerType = type;
        }
    }

    public int getHits() {
        return this.m_hits;
    }

    @Override
    public Object clone() {
        ConventionalGenerationState conventionalGenerationState = new ConventionalGenerationState(this.getBinding(), this.m_instruction, this.m_numDependencies);
        conventionalGenerationState.m_varName = this.m_varName;
        conventionalGenerationState.m_oneTime = this.m_oneTime;
        conventionalGenerationState.m_register = this.m_register;
        conventionalGenerationState.m_registerType = this.m_registerType;
        return conventionalGenerationState;
    }

    public com.ibm.xtq.bcel.generic.Type getRegisterType() {
        return this.m_registerType;
    }
}

