/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.jaxp;

import com.ibm.xtq.xslt.jaxp.StAX2SAX;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class STAXEvent2SAX
extends StAX2SAX {
    private XMLEventReader m_eventReader = null;
    private ArrayList m_attributes = new ArrayList();

    public STAXEvent2SAX(XMLEventReader xMLEventReader) {
        this.m_eventReader = xMLEventReader;
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.m_eventReader != null) {
            this.parse(this.m_eventReader);
        }
    }

    private void parse(XMLEventReader xMLEventReader) throws IOException, SAXException {
        block19: {
            try {
                if (!xMLEventReader.hasNext()) break block19;
                XMLEvent xMLEvent = xMLEventReader.nextEvent();
                switch (xMLEvent.getEventType()) {
                    case 7: {
                        this.setLocation(xMLEvent.getLocation());
                        this.getContentHandler().setDocumentLocator(this);
                        this.getContentHandler().startDocument();
                        while (xMLEventReader.hasNext()) {
                            this.parse(xMLEventReader);
                        }
                        this.getContentHandler().endDocument();
                        break;
                    }
                    case 4: 
                    case 6: {
                        String string = xMLEvent.asCharacters().getData();
                        this.getContentHandler().characters(string.toCharArray(), 0, string.length());
                        break;
                    }
                    case 12: {
                        char[] cArray = xMLEvent.asCharacters().getData().toCharArray();
                        if (this.getLexicalHandler() != null) {
                            this.getLexicalHandler().startCDATA();
                            this.getContentHandler().characters(cArray, 0, cArray.length);
                            this.getLexicalHandler().endCDATA();
                            break;
                        }
                        this.getContentHandler().characters(cArray, 0, cArray.length);
                        break;
                    }
                    case 1: {
                        String string;
                        String string2;
                        Object object;
                        StartElement startElement = (StartElement)xMLEvent;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        AttributesImpl attributesImpl = new AttributesImpl();
                        Iterator iterator = startElement.getNamespaces();
                        while (iterator.hasNext()) {
                            object = (Namespace)iterator.next();
                            string2 = object.getNamespaceURI();
                            string = object.getPrefix();
                            if (!this.startPrefixMapping(string, string2)) continue;
                            arrayList.add(string);
                        }
                        iterator = startElement.getAttributes();
                        while (iterator.hasNext()) {
                            this.m_attributes.add(iterator.next());
                        }
                        object = startElement.getName();
                        string2 = ((QName)object).getNamespaceURI();
                        String string3 = ((QName)object).getLocalPart();
                        string = ((QName)object).getPrefix();
                        if (string2 != null && !string2.equals("") && this.startPrefixMapping(string, string2)) {
                            arrayList.add(string);
                        }
                        String string4 = string.equals("") ? string3 : string + ":" + string3;
                        this.getContentHandler().startElement(string2, string3, string4, this);
                        this.m_attributes.clear();
                        while (xMLEventReader.hasNext() && xMLEventReader.peek().getEventType() != 2) {
                            this.parse(xMLEventReader);
                        }
                        xMLEventReader.nextEvent();
                        this.getContentHandler().endElement(string2, string3, string4);
                        int n = arrayList.size();
                        for (int i = 0; i < n; ++i) {
                            this.endPrefixMapping((String)arrayList.get(i));
                        }
                        break;
                    }
                    case 5: {
                        if (this.getLexicalHandler() == null) break;
                        String string = ((Comment)xMLEvent).getText();
                        this.getLexicalHandler().comment(string.toCharArray(), 0, string.length());
                        break;
                    }
                    case 3: {
                        ProcessingInstruction processingInstruction = (ProcessingInstruction)xMLEvent;
                        this.getContentHandler().processingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                        break;
                    }
                    case 11: {
                        if (this.getDTDHandler() == null) break;
                        List list = (List)xMLEventReader.getProperty("javax.xml.stream.entities");
                        for (XMLEvent xMLEvent2 : list) {
                            if (xMLEvent2.getEventType() != 15) continue;
                            EntityDeclaration entityDeclaration = (EntityDeclaration)xMLEvent2;
                            this.getDTDHandler().unparsedEntityDecl(entityDeclaration.getName(), entityDeclaration.getPublicId(), entityDeclaration.getSystemId(), entityDeclaration.getNotationName());
                        }
                        break;
                    }
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SAXException(xMLStreamException);
            }
        }
    }

    @Override
    public int getIndex(String string) {
        if (string == null) {
            return -1;
        }
        Iterator iterator = this.m_attributes.iterator();
        Attribute attribute = null;
        int n = 0;
        while (iterator.hasNext()) {
            String string2;
            attribute = (Attribute)iterator.next();
            QName qName = attribute.getName();
            String string3 = qName.getLocalPart();
            String string4 = qName.getPrefix();
            String string5 = string2 = string4 == null || string4.equals("") ? string3 : string4 + ":" + string3;
            if (string2 != null && string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int getIndex(String string, String string2) {
        Iterator iterator = this.m_attributes.iterator();
        Attribute attribute = null;
        int n = 0;
        while (iterator.hasNext()) {
            attribute = (Attribute)iterator.next();
            QName qName = attribute.getName();
            String string3 = qName.getLocalPart();
            String string4 = qName.getNamespaceURI();
            if (string == null && string4 == null && string2 != null && string2.equals(string3)) {
                return n;
            }
            if (string4 != null && string4.equals(string) && string3 != null && string3.equals(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.m_attributes.size();
    }

    @Override
    public String getLocalName(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        Attribute attribute = (Attribute)this.m_attributes.get(n);
        return attribute.getName().getLocalPart();
    }

    @Override
    public String getQName(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        QName qName = ((Attribute)this.m_attributes.get(n)).getName();
        String string = qName.getPrefix();
        String string2 = qName.getLocalPart();
        return string == null || string.equals("") ? string2 : string + ":" + string2;
    }

    @Override
    public String getType(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return ((Attribute)this.m_attributes.get(n)).getDTDType();
    }

    @Override
    public String getType(String string) {
        int n = this.getIndex(string);
        return n > 0 ? this.getType(n) : null;
    }

    @Override
    public String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n > 0 ? this.getType(n) : null;
    }

    @Override
    public String getURI(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        Attribute attribute = (Attribute)this.m_attributes.get(n);
        return attribute.getName().getNamespaceURI();
    }

    @Override
    public String getValue(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        Attribute attribute = (Attribute)this.m_attributes.get(n);
        return attribute.getValue();
    }

    @Override
    public String getValue(String string) {
        int n = this.getIndex(string);
        return n > 0 ? this.getValue(n) : null;
    }

    @Override
    public String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n > 0 ? this.getValue(n) : null;
    }
}

