/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.ZeroArgPrimopInstruction;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class ParamReferenceIdentifier
extends ZeroArgPrimopInstruction {
    private int m_paramIndex;

    public static void fixParamReferences(Module module) {
        module.optimize(new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction instruction) {
                if (instruction instanceof ParamReferenceIdentifier) {
                    ParamReferenceIdentifier paramReferenceIdentifier = (ParamReferenceIdentifier)instruction;
                    if (paramReferenceIdentifier.m_paramIndex >= this.getCurrentFunction().m_parameters.length) {
                        throw new StaticError("ERR_SYSTEM", "oob " + paramReferenceIdentifier.m_paramIndex + "/" + this.getCurrentFunction().m_parameters.length + " in " + this.getCurrentFunction());
                    }
                    Object object = this.getCurrentFunction().m_parameters[paramReferenceIdentifier.m_paramIndex].getName();
                    instruction = new IdentifierInstruction(object);
                    instruction.setCachedType(paramReferenceIdentifier.getCachedType());
                    instruction.setBindingEnvironment(paramReferenceIdentifier.getBindingEnvironment());
                }
                return instruction;
            }
        });
    }

    public static void createParamReferences(Module module) {
        module.optimize(new Optimizer(){
            HashMap m_paramIndecies = new HashMap();

            @Override
            public void optimizeFunction(Function function) {
                this.m_paramIndecies.clear();
                for (int i = 0; i < function.m_parameters.length; ++i) {
                    this.m_paramIndecies.put(function.m_parameters[i].getName(), new Integer(i));
                }
                super.optimizeFunction(function);
            }

            @Override
            protected Instruction optimizeStep(Instruction instruction) {
                Object object;
                Integer n;
                if (instruction instanceof IdentifierInstruction && (n = (Integer)this.m_paramIndecies.get(object = ((IdentifierInstruction)instruction).getVariable())) != null && instruction.getBindingEnvironment().getVariableBinding(object) == this.getCurrentFunction().m_parameters[n]) {
                    ParamReferenceIdentifier paramReferenceIdentifier = new ParamReferenceIdentifier(n, instruction.getCachedType());
                    return paramReferenceIdentifier;
                }
                return instruction;
            }
        });
    }

    ParamReferenceIdentifier(int n, Type type) {
        this.setCachedType(type);
        this.m_paramIndex = n;
    }

    public ParamReferenceIdentifier() {
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return this;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        return this.getCachedType();
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.getCachedType();
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInt(this.m_paramIndex);
        writeObjectFileHelper.writeType(this.getCachedType());
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_paramIndex = readObjectFileHelper.readInt();
        this.setCachedType(readObjectFileHelper.readType());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ParamReferenceIdentifier)) {
            return false;
        }
        ParamReferenceIdentifier paramReferenceIdentifier = (ParamReferenceIdentifier)object;
        return paramReferenceIdentifier.m_paramIndex == this.m_paramIndex;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("PARAM", n);
        prettyPrinter.print("" + this.m_paramIndex);
        prettyPrinter.printFormClose(n);
    }
}

