/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm.ref;

import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMNode;
import com.ibm.xtq.xml.xdm.ref.XDMCursorProxyCursor;

public final class XDMNodeStreamCursor
extends XDMCursorProxyCursor {
    private XDMNode[] m_nodestream;
    private int m_index = 0;
    private int m_docOrdered = -1;
    private int m_orderedUnique = -1;

    public XDMNodeStreamCursor(XDMNode[] xDMNodeArray) {
        super(null);
        this.m_nodestream = xDMNodeArray;
        if (this.m_nodestream != null && this.m_nodestream.length > 0) {
            this.m_currentCursor = (XDMCursor)this.m_nodestream[0];
        }
    }

    @Override
    public boolean isEmpty() {
        return this.m_nodestream == null || this.m_nodestream.length == 0;
    }

    @Override
    public boolean isDocOrdered() {
        if (this.m_docOrdered == -1) {
            if (this.m_nodestream == null || this.m_nodestream.length < 2) {
                this.m_docOrdered = 1;
            } else {
                this.m_docOrdered = 1;
                XDMNode xDMNode = this.m_nodestream[0];
                for (int i = 1; i < this.m_nodestream.length; ++i) {
                    XDMNode xDMNode2 = this.m_nodestream[i];
                    int n = xDMNode.relativeDocOrder(xDMNode2);
                    if (n > 0) {
                        this.m_docOrdered = 0;
                        break;
                    }
                    if (n == 0) {
                        this.m_orderedUnique = 0;
                    }
                    xDMNode = xDMNode2;
                }
            }
        }
        return this.m_docOrdered > 0;
    }

    @Override
    public int getCurrentPos() {
        return this.m_index + 1;
    }

    @Override
    public boolean setCurrentPos(int n) {
        if (this.isEmpty() || n < 0 || n > this.m_nodestream.length) {
            return false;
        }
        this.m_index = n - 1;
        this.m_currentCursor = (XDMCursor)this.m_nodestream[this.m_index];
        return true;
    }

    @Override
    public XDMCursor newContext(XDMCursor xDMCursor, Object object, boolean bl) {
        try {
            return this.cloneWithReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    @Override
    public void resetIteration() {
        if (!this.isEmpty()) {
            this.m_index = 0;
            this.m_currentCursor = (XDMCursor)this.m_nodestream[0];
        }
    }

    @Override
    public boolean nextNode() {
        int n = this.m_index + 1;
        if (n < this.m_nodestream.length) {
            this.m_index = n;
            this.m_currentCursor = (XDMCursor)this.m_nodestream[this.m_index];
            return true;
        }
        return false;
    }

    @Override
    public int getLength() {
        return this.m_nodestream == null ? 0 : this.m_nodestream.length;
    }

    @Override
    public boolean isUniqueNodes() {
        block9: {
            if (this.m_nodestream == null || this.m_nodestream.length < 2) {
                return true;
            }
            if (this.m_orderedUnique >= 0) break block9;
            this.m_orderedUnique = 1;
            XDMNode xDMNode = this.m_nodestream[1];
            int n = this.m_nodestream[0].relativeDocOrder(xDMNode);
            if (n == 0) {
                this.m_orderedUnique = 0;
            }
            if (n > 0) {
                this.m_docOrdered = 0;
                for (int i = 2; i < this.m_nodestream.length; ++i) {
                    XDMNode xDMNode2 = this.m_nodestream[i];
                    int n2 = xDMNode2.relativeDocOrder(xDMNode);
                    if (n2 >= 0) {
                        this.m_orderedUnique = 0;
                        break;
                    }
                    xDMNode = xDMNode2;
                }
            } else {
                for (int i = 2; i < this.m_nodestream.length; ++i) {
                    XDMNode xDMNode3 = this.m_nodestream[i];
                    int n3 = xDMNode3.relativeDocOrder(xDMNode);
                    if (n3 <= 0) {
                        if (n3 < 0) {
                            this.m_docOrdered = 0;
                        }
                        this.m_orderedUnique = 0;
                        break;
                    }
                    xDMNode = xDMNode3;
                }
            }
        }
        return this.m_orderedUnique > 0;
    }

    @Override
    public XDMCursor cloneWithReset() throws CloneNotSupportedException {
        XDMNodeStreamCursor xDMNodeStreamCursor = new XDMNodeStreamCursor(this.m_nodestream);
        return xDMNodeStreamCursor;
    }

    @Override
    public Object clone() {
        XDMNodeStreamCursor xDMNodeStreamCursor = new XDMNodeStreamCursor(this.m_nodestream);
        xDMNodeStreamCursor.m_index = this.m_index;
        xDMNodeStreamCursor.m_currentCursor = this.m_currentCursor;
        xDMNodeStreamCursor.m_docOrdered = this.m_docOrdered;
        xDMNodeStreamCursor.m_orderedUnique = this.m_orderedUnique;
        return xDMNodeStreamCursor;
    }

    @Override
    public boolean isReverseEnumerated() {
        return false;
    }
}

