/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastError;
import com.ibm.xtq.xml.datamodel.XAnyURI;
import com.ibm.xtq.xml.datamodel.XBase64Binary;
import com.ibm.xtq.xml.datamodel.XDate;
import com.ibm.xtq.xml.datamodel.XDateTime;
import com.ibm.xtq.xml.datamodel.XDayTimeDuration;
import com.ibm.xtq.xml.datamodel.XDuration;
import com.ibm.xtq.xml.datamodel.XGDay;
import com.ibm.xtq.xml.datamodel.XGMonth;
import com.ibm.xtq.xml.datamodel.XGMonthDay;
import com.ibm.xtq.xml.datamodel.XGYear;
import com.ibm.xtq.xml.datamodel.XGYearMonth;
import com.ibm.xtq.xml.datamodel.XHexBinary;
import com.ibm.xtq.xml.datamodel.XInteger;
import com.ibm.xtq.xml.datamodel.XTime;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.datamodel.XYearMonthDuration;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Calendar;

public class CastLibrary {
    private static final BigDecimal BIGDECIMAL_ONE = new BigDecimal(BigInteger.ONE);
    private static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal(BigInteger.ZERO);
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final DecimalFormat DOUBLE_FORMATER = new DecimalFormat("0.0#################E0");

    public static boolean castableAsLong(BigInteger bigInteger) {
        return bigInteger.compareTo(XInteger.LONG_MAX) <= 0 && bigInteger.compareTo(XInteger.LONG_MIN) >= 0;
    }

    public static boolean castableAsInt(BigInteger bigInteger) {
        return bigInteger.compareTo(XInteger.INT_MAX) <= 0 && bigInteger.compareTo(XInteger.INT_MIN) >= 0;
    }

    public static boolean castableAsShort(BigInteger bigInteger) {
        return bigInteger.compareTo(XInteger.SHORT_MAX) <= 0 && bigInteger.compareTo(XInteger.SHORT_MIN) >= 0;
    }

    public static boolean castableAsByte(BigInteger bigInteger) {
        return bigInteger.compareTo(XInteger.BYTE_MAX) <= 0 && bigInteger.compareTo(XInteger.BYTE_MIN) >= 0;
    }

    public static boolean castableAsUnsignedLong(BigInteger bigInteger) {
        return bigInteger.signum() >= 0 && bigInteger.compareTo(XInteger.UNSIGNEDLONG_MAX) <= 0;
    }

    public static boolean castableAsUnsignedInt(BigInteger bigInteger) {
        return bigInteger.signum() >= 0 && bigInteger.compareTo(XInteger.UNSIGNEDINT_MAX) <= 0;
    }

    public static boolean castableAsUnsignedShort(BigInteger bigInteger) {
        return bigInteger.signum() >= 0 && bigInteger.compareTo(XInteger.UNSIGNEDSHORT_MAX) <= 0;
    }

    public static boolean castableAsUnsignedByte(BigInteger bigInteger) {
        return bigInteger.signum() >= 0 && bigInteger.compareTo(XInteger.UNSIGNEDBYTE_MAX) <= 0;
    }

    public static boolean castableAsNonPositiveInteger(BigInteger bigInteger) {
        return bigInteger.signum() <= 0;
    }

    public static boolean castableAsNonNegativeInteger(BigInteger bigInteger) {
        return bigInteger.signum() >= 0;
    }

    public static boolean castableAsPositiveInteger(BigInteger bigInteger) {
        return bigInteger.signum() > 0;
    }

    public static boolean castableAsNegativeInteger(BigInteger bigInteger) {
        return bigInteger.signum() < 0;
    }

    public static XAnyURI toAnyURI(String string) {
        return XAnyURI.parse(string);
    }

    public static XBase64Binary toBase64Binary(String string) {
        return XBase64Binary.parse(string);
    }

    public static boolean toBoolean(BigDecimal bigDecimal) {
        return bigDecimal.signum() != 0;
    }

    public static boolean toBoolean(BigInteger bigInteger) {
        return bigInteger.signum() != 0;
    }

    public static boolean toBoolean(double d) {
        return d != 0.0 && !Double.isNaN(d);
    }

    public static boolean toBoolean(float f) {
        return (double)f != 0.0 && !Float.isNaN(f);
    }

    public static boolean toBoolean(String string) {
        if (string.equals(TRUE) || string.equals("1")) {
            return true;
        }
        if (string.equals(FALSE) || string.equals("0")) {
            return false;
        }
        throw new CastError();
    }

    public static XDate toDate(String string) {
        return XDate.parse(string);
    }

    public static XDateTime toDateTime(String string) {
        return XDateTime.parse(string);
    }

    public static XDayTimeDuration toDayTimeDuration(String string) {
        return XDayTimeDuration.parseTMP(string);
    }

    public static BigDecimal toDecimal(BigInteger bigInteger) {
        return new BigDecimal(bigInteger);
    }

    public static BigDecimal toDecimal(boolean bl) {
        return bl ? BIGDECIMAL_ONE : BIGDECIMAL_ZERO;
    }

    public static BigDecimal toDecimal(double d) {
        return CastLibrary.toDecimal(String.valueOf(d));
    }

    public static BigDecimal toDecimal(float f) {
        return CastLibrary.toDecimal(String.valueOf(f));
    }

    public static BigDecimal toDecimal(String string) {
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CastError();
        }
    }

    public static double toDouble(BigDecimal bigDecimal) {
        return bigDecimal.doubleValue();
    }

    public static double toDouble(BigInteger bigInteger) {
        return bigInteger.doubleValue();
    }

    public static double toDouble(boolean bl) {
        return bl ? 1.0 : 0.0;
    }

    public static double toDouble(float f) {
        return f;
    }

    public static double toDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CastError();
        }
    }

    public static XDuration toDuration(String string) {
        return XDuration.parse(string);
    }

    public static float toFloat(BigDecimal bigDecimal) {
        return bigDecimal.floatValue();
    }

    public static float toFloat(BigInteger bigInteger) {
        return bigInteger.floatValue();
    }

    public static float toFloat(boolean bl) {
        return bl ? 1.0f : 0.0f;
    }

    public static float toFloat(double d) {
        return (float)d;
    }

    public static float toFloat(String string) {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CastError();
        }
    }

    public static XGDay toGDay(String string) {
        return XGDay.parse(string);
    }

    public static XGMonth toGMonth(String string) {
        return XGMonth.parse(string);
    }

    public static XGMonthDay toGMonthDay(String string) {
        return XGMonthDay.parse(string);
    }

    public static XGYear toGYear(String string) {
        return XGYear.parse(string);
    }

    public static XGYearMonth toGYearMonth(String string) {
        return XGYearMonth.parse(string);
    }

    public static XHexBinary toHexBinary(String string) {
        return XHexBinary.parse(string);
    }

    public static BigInteger toInteger(BigDecimal bigDecimal) {
        return bigDecimal.toBigInteger();
    }

    public static BigInteger toInteger(boolean bl) {
        return bl ? BigInteger.ONE : BigInteger.ZERO;
    }

    public static BigInteger toInteger(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new CastError();
        }
        if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
            return BigInteger.valueOf((long)d);
        }
        return new BigDecimal(String.valueOf(d)).toBigInteger();
    }

    public static BigInteger toInteger(float f) {
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            throw new CastError();
        }
        if (f <= 9.223372E18f && f >= -9.223372E18f) {
            return BigInteger.valueOf((long)f);
        }
        return new BigDecimal(String.valueOf(f)).toBigInteger();
    }

    public static BigInteger toInteger(String string) {
        try {
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CastError();
        }
    }

    public static final String toString(BigDecimal bigDecimal) {
        String string = bigDecimal.toString();
        if (bigDecimal.scale() <= 0) {
            return string;
        }
        int n = string.length();
        if (string.charAt(n - 1) != '0') {
            return string;
        }
        while (string.charAt(n - 1) == '0') {
            --n;
        }
        if (string.charAt(n - 1) == '.') {
            --n;
        }
        return string.substring(0, n);
    }

    public static String toString(BigInteger bigInteger) {
        return bigInteger.toString();
    }

    public static String toString(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static String toString(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (StrictMath.abs(d) < 1.0E-6 || StrictMath.abs(d) >= 1000000.0) {
            return DOUBLE_FORMATER.format(d);
        }
        return CastLibrary.toString(CastLibrary.toDecimal(d));
    }

    public static String toString(float f) {
        if (f == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (Float.isNaN(f)) {
            return "NaN";
        }
        if ((double)StrictMath.abs(f) < 1.0E-6 || StrictMath.abs(f) >= 1000000.0f) {
            return DOUBLE_FORMATER.format(f);
        }
        return CastLibrary.toString(CastLibrary.toDecimal(f));
    }

    public static XTime toTime(String string) {
        return XTime.parse(string);
    }

    public static XUntypedAtomic toUntypedAtomic(BigDecimal bigDecimal) {
        return new XUntypedAtomic(CastLibrary.toString(bigDecimal));
    }

    public static XUntypedAtomic toUntypedAtomic(BigInteger bigInteger) {
        return new XUntypedAtomic(CastLibrary.toString(bigInteger));
    }

    public static XUntypedAtomic toUntypedAtomic(boolean bl) {
        return new XUntypedAtomic(CastLibrary.toString(bl));
    }

    public static XUntypedAtomic toUntypedAtomic(double d) {
        return new XUntypedAtomic(CastLibrary.toString(d));
    }

    public static XUntypedAtomic toUntypedAtomic(float f) {
        return new XUntypedAtomic(CastLibrary.toString(f));
    }

    public static XUntypedAtomic toUntypedAtomic(String string) {
        return new XUntypedAtomic(string);
    }

    public static XYearMonthDuration toYearMonthDuration(String string) {
        return XYearMonthDuration.parseTMP(string);
    }

    public static XDateTime current_dateTime() {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        CastLibrary.appendDate(calendar, stringBuffer);
        stringBuffer.append("T");
        CastLibrary.appendTime(calendar, stringBuffer);
        CastLibrary.appendTimeZone(calendar, stringBuffer);
        return XDateTime.parse(stringBuffer.toString());
    }

    private static void normalize(int n, StringBuffer stringBuffer) {
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
    }

    private static void appendDate(Calendar calendar, StringBuffer stringBuffer) {
        stringBuffer.append(calendar.get(1)).append("-");
        int n = calendar.get(2) + 1;
        CastLibrary.normalize(n, stringBuffer);
        stringBuffer.append("-");
        n = calendar.get(5);
        CastLibrary.normalize(n, stringBuffer);
    }

    private static void appendTime(Calendar calendar, StringBuffer stringBuffer) {
        int n = calendar.get(10);
        CastLibrary.normalize(n, stringBuffer);
        stringBuffer.append(":");
        n = calendar.get(12);
        CastLibrary.normalize(n, stringBuffer);
        stringBuffer.append(":");
        n = calendar.get(13);
        CastLibrary.normalize(n, stringBuffer);
    }

    private static void appendTimeZone(Calendar calendar, StringBuffer stringBuffer) {
        int n = calendar.get(15) + calendar.get(16);
        if (n < 0) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append("+");
        }
        n = Math.abs(n);
        int n2 = n / 3600000;
        int n3 = n % 3600000;
        CastLibrary.normalize(n2, stringBuffer);
        stringBuffer.append(":");
        CastLibrary.normalize(n3, stringBuffer);
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        return n > 0 ? string.substring(0, n) : null;
    }

    public static String getLocalName(String string) {
        int n = string.lastIndexOf(58);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(64)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String convertYearToString(int n) {
        String string = n >= 0 ? "" : "-";
        String string2 = Integer.toString(Math.abs(n));
        int n2 = string2.length();
        if (n2 == 1) {
            return string + "000" + string2;
        }
        if (n2 == 2) {
            return string + "00" + string2;
        }
        if (n2 == 3) {
            return string + "0" + string2;
        }
        return string + string2;
    }

    public static String convertTo2CharString(int n) {
        String string = Integer.toString(n);
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    public static String convertSecondsToString(double d, boolean bl) {
        int n = (int)d;
        String string = Integer.toString(n);
        int n2 = string.length();
        if ((double)n == d) {
            if (n2 == 1 && bl) {
                return "0" + string;
            }
            return string;
        }
        if (n2 == 1 && bl) {
            return "0" + String.valueOf(d);
        }
        return String.valueOf(d);
    }

    public static String convertTZtoString(XDayTimeDuration xDayTimeDuration) {
        if (xDayTimeDuration == null) {
            return "";
        }
        int n = xDayTimeDuration.getHours();
        int n2 = xDayTimeDuration.getMinutes();
        if (n == 0 && n2 == 0) {
            return "Z";
        }
        String string = n > 0 ? "+" : "-";
        String string2 = Integer.toString(Math.abs(n));
        String string3 = string2.length() < 2 ? "0" + string2 : string2;
        String string4 = Integer.toString(Math.abs(n2));
        String string5 = string4.length() < 2 ? "0" + string4 : string4;
        return string + string3 + ":" + string5;
    }

    public static String composeDateTimeStrRep(int n, int n2, int n3, int n4, int n5, double d, XDayTimeDuration xDayTimeDuration) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CastLibrary.composeDateStrRep(n, n2, n3, null));
        stringBuffer.append("T");
        stringBuffer.append(CastLibrary.composeTimeStrRep(n4, n5, d, xDayTimeDuration));
        return stringBuffer.toString();
    }

    public static String composeDateStrRep(int n, int n2, int n3, XDayTimeDuration xDayTimeDuration) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CastLibrary.convertYearToString(n));
        stringBuffer.append("-");
        stringBuffer.append(CastLibrary.convertTo2CharString(n2));
        stringBuffer.append("-");
        stringBuffer.append(CastLibrary.convertTo2CharString(n3));
        if (xDayTimeDuration != null) {
            stringBuffer.append(CastLibrary.convertTZtoString(xDayTimeDuration));
        }
        return stringBuffer.toString();
    }

    public static String composeTimeStrRep(int n, int n2, double d, XDayTimeDuration xDayTimeDuration) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CastLibrary.convertTo2CharString(n));
        stringBuffer.append(":");
        stringBuffer.append(CastLibrary.convertTo2CharString(n2));
        stringBuffer.append(":");
        stringBuffer.append(CastLibrary.convertSecondsToString(d, true));
        if (xDayTimeDuration != null) {
            stringBuffer.append(CastLibrary.convertTZtoString(xDayTimeDuration));
        }
        return stringBuffer.toString();
    }

    public static String composeDurationCRep(int n, int n2, int n3, int n4, int n5, double d, BigDecimal bigDecimal, int n6) {
        if (bigDecimal.doubleValue() == 0.0) {
            if (n6 == 6) {
                return "PT0S";
            }
            if (n6 == 7) {
                return "P0M";
            }
        }
        boolean bl = n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0 || d < 0.0;
        boolean bl2 = n != 0 || n2 != 0 || n3 != 0;
        boolean bl3 = n4 != 0 || n5 != 0 || d != 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("-");
        }
        stringBuffer.append("P");
        if (bl2) {
            if (n != 0) {
                stringBuffer.append(Math.abs(n));
                stringBuffer.append("Y");
            }
            if (n2 != 0) {
                stringBuffer.append(Math.abs(n2));
                stringBuffer.append("M");
            }
            if (n3 != 0) {
                stringBuffer.append(Math.abs(n3));
                stringBuffer.append("D");
            }
        }
        if (bl3) {
            stringBuffer.append("T");
            if (n4 != 0) {
                stringBuffer.append(Math.abs(n4));
                stringBuffer.append("H");
            }
            if (n5 != 0) {
                stringBuffer.append(Math.abs(n5));
                stringBuffer.append("M");
            }
            if (d != 0.0) {
                stringBuffer.append(CastLibrary.convertSecondsToString(Math.abs(d), false));
                stringBuffer.append("S");
            }
        }
        return stringBuffer.toString();
    }
}

