/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionCall;
import com.ibm.xtq.ast.nodes.Literal;
import com.ibm.xtq.ast.nodes.OperatorExpr;
import com.ibm.xtq.ast.nodes.PathExpr;
import com.ibm.xtq.ast.nodes.StepExpr;

public class XPath20Utilities {
    public static boolean isMatchDocumentNode(Expr expr) {
        boolean bl;
        block0 : switch (expr.getId()) {
            case 40: {
                OperatorExpr operatorExpr = (OperatorExpr)expr;
                if (operatorExpr.getOperandCount() == 1) {
                    bl = XPath20Utilities.isMatchDocumentNode(operatorExpr.getOperand(0));
                    break;
                }
                bl = false;
                break;
            }
            case 63: 
            case 64: {
                bl = false;
                OperatorExpr operatorExpr = (OperatorExpr)expr;
                for (int i = operatorExpr.getOperandCount() - 1; i >= 0; --i) {
                    if (!XPath20Utilities.isMatchDocumentNode(operatorExpr.getOperand(i))) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
            case 82: {
                PathExpr pathExpr = (PathExpr)expr;
                bl = pathExpr.isAbsolute() && pathExpr.getOperandCount() == 1;
                break;
            }
            case 85: {
                bl = ((StepExpr)expr).isRootOnSelfNode();
                break;
            }
            case 105: {
                bl = ((FunctionCall)expr).isRootOnSelfNode();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isSingletonSequence(Expr expr) {
        return expr != null && expr.getId() == 40 && ((OperatorExpr)expr).getOperandCount() == 1;
    }

    public static boolean isAbsolutePath(Expr expr) {
        return expr.getId() == 82 && ((PathExpr)expr).isAbsolute() || XPath20Utilities.isSingletonSequence(expr) && XPath20Utilities.isAbsolutePath(((OperatorExpr)expr).getOperand(0)) || XPath20Utilities.isRootOnSelfNode(expr);
    }

    public static boolean isRootOnSelfNode(Expr expr) {
        return expr.isRootOnSelfNode();
    }

    public static boolean isNumeric(Literal literal) {
        int n = literal.getId();
        return n == 98 || n == 99 || n == 97;
    }

    public static Expr parentless(Expr expr) {
        if (expr == null) {
            return null;
        }
        if (expr.jjtGetParent() == null) {
            return expr;
        }
        return expr.cloneExpression();
    }
}

