/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.DataStore;
import com.ibm.xml.xlxp.scan.util.IntegerHashtable;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;

public final class EntityDeclPool {
    private static final boolean DEBUG_ADDITIONS = false;
    public static final int EntityType_Mask = 65535;
    public static final int EntityType_Predefined = 0;
    public static final int EntityType_InternalGeneral = 1;
    public static final int EntityType_ExternalGeneral = 2;
    public static final int EntityType_InternalParameter = 3;
    public static final int EntityType_ExternalParameter = 4;
    public static final int EntityType_Unparsed = 5;
    public static final int EntityType_DeclaredExternally = 65536;
    public static final int ENTITY_ENTITYTYPE_OFFSET = 0;
    public static final int ENTITY_NAME_OFFSET = 1;
    public static final int PREDEFINEDENTITY_CHARVALUE_OFFSET = 2;
    public static final int PREDEFINEDENTITY_RECORD_SIZE = 3;
    public static final int INTERNALENTITY_CONTENT_OFFSET = 2;
    public static final int INTERNALENTITY_RECORD_SIZE = 3;
    public static final int EXTERNALENTITY_BASEURI_OFFSET = 2;
    public static final int EXTERNALENTITY_PUBLICID_OFFSET = 3;
    public static final int EXTERNALENTITY_SYSTEMID_OFFSET = 4;
    public static final int EXTERNALENTITY_RECORD_SIZE = 5;
    public static final int UNPARSEDENTITY_RECORD_SIZE = 2;
    private DataBufferFactory fBufferFactory;
    private SymbolTable fSymbolTable;
    private XMLStringBuffer fStringBuffer;
    private DataStore fDataStore;
    private IntegerHashtable fEntityDecls;
    private IntegerHashtable fPEDecls;
    private int fXMLStringCount;
    private XMLString[] fXMLStrings;
    private int fStringCount;
    private String[] fStrings;

    public EntityDeclPool(DataBufferFactory dataBufferFactory, SymbolTable symbolTable, XMLStringBuffer xMLStringBuffer) {
        this.fBufferFactory = dataBufferFactory;
        this.fSymbolTable = symbolTable;
        this.fStringBuffer = xMLStringBuffer;
        this.fDataStore = new DataStore();
        this.fEntityDecls = new IntegerHashtable();
        this.fXMLStrings = new XMLString[16];
        this.fStrings = new String[16];
        this.createPredefinedEntities();
    }

    public void reset(boolean bl) {
        int n;
        this.fDataStore.reset(bl);
        this.fEntityDecls.clear(bl);
        if (this.fPEDecls != null) {
            this.fPEDecls.clear(bl);
        }
        if (this.fXMLStringCount != 0) {
            for (n = 0; n < this.fXMLStringCount; ++n) {
                this.fXMLStrings[n].clear();
                if (bl) continue;
                this.fXMLStrings[n] = null;
            }
            this.fXMLStringCount = 0;
        }
        if (this.fStringCount != 0) {
            for (n = 0; n < this.fStringCount; ++n) {
                this.fStrings[n] = null;
            }
            this.fStringCount = 0;
        }
        this.createPredefinedEntities();
    }

    public int lookupEntity(int n) {
        return this.fEntityDecls.get(n);
    }

    public int lookupPE(int n) {
        return this.fPEDecls == null ? -1 : this.fPEDecls.get(n);
    }

    public boolean isUnparsedEntity(int n) {
        int n2;
        int[] nArray = this.fDataStore.getRecordArray(n);
        int n3 = nArray[(n2 = this.fDataStore.getRecordBase(n)) + 0];
        return (n3 & 0xFFFF) == 5;
    }

    public int[] getDeclArray(int n) {
        return this.fDataStore.getRecordArray(n);
    }

    public int getDeclBase(int n) {
        return this.fDataStore.getRecordBase(n);
    }

    public XMLString getInternalEntityContent(int n) {
        return this.lookupXMLString(n);
    }

    public XMLString getPublicID(int n) {
        return this.lookupXMLString(n);
    }

    public XMLString getSystemID(int n) {
        return this.lookupXMLString(n);
    }

    public String getBaseURI(int n) {
        if (n >= 0) {
            return this.fStrings[n];
        }
        return null;
    }

    public boolean addInternalEntityDecl(XMLString xMLString, XMLString xMLString2, boolean bl) {
        int n = this.fSymbolTable.addSymbol(xMLString);
        if (this.fEntityDecls.get(n) != -1) {
            return false;
        }
        int n2 = this.saveXMLString(xMLString2);
        int n3 = this.addInternalEntity(1, n, n2, bl);
        this.fEntityDecls.put(n, n3);
        return true;
    }

    public boolean addExternalEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, String string, boolean bl) {
        int n = this.fSymbolTable.addSymbol(xMLString);
        if (this.fEntityDecls.get(n) != -1) {
            return false;
        }
        int n2 = this.saveXMLString(xMLString2);
        int n3 = this.saveXMLString(xMLString3);
        int n4 = this.saveString(string);
        int n5 = this.addExternalEntity(2, n, n2, n3, n4, bl);
        this.fEntityDecls.put(n, n5);
        return true;
    }

    public boolean addUnparsedEntityDecl(XMLString xMLString) {
        int n = this.fSymbolTable.addSymbol(xMLString);
        if (this.fEntityDecls.get(n) != -1) {
            return false;
        }
        int n2 = this.fDataStore.allocateRecord(2);
        int[] nArray = this.fDataStore.getRecordArray(n2);
        int n3 = this.fDataStore.getRecordBase(n2);
        nArray[n3 + 0] = 5;
        nArray[n3 + 1] = n;
        this.fEntityDecls.put(n, n2);
        return true;
    }

    public boolean addInternalPEDecl(XMLString xMLString, XMLString xMLString2, boolean bl) {
        int n = this.fSymbolTable.addSymbol(xMLString);
        if (this.fPEDecls != null && this.fPEDecls.get(n) != -1) {
            return false;
        }
        int n2 = this.saveXMLString(xMLString2);
        int n3 = this.addInternalEntity(3, n, n2, bl);
        if (this.fPEDecls == null) {
            this.fPEDecls = new IntegerHashtable();
        }
        this.fPEDecls.put(n, n3);
        return true;
    }

    public boolean addExternalPEDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, String string, boolean bl) {
        int n = this.fSymbolTable.addSymbol(xMLString);
        if (this.fPEDecls != null && this.fPEDecls.get(n) != -1) {
            return false;
        }
        int n2 = this.saveXMLString(xMLString2);
        int n3 = this.saveXMLString(xMLString3);
        int n4 = this.saveString(string);
        int n5 = this.addExternalEntity(4, n, n2, n3, n4, bl);
        if (this.fPEDecls == null) {
            this.fPEDecls = new IntegerHashtable();
        }
        this.fPEDecls.put(n, n5);
        return true;
    }

    private void createPredefinedEntities() {
        this.addPredefinedEntity(5, 60);
        this.addPredefinedEntity(6, 62);
        this.addPredefinedEntity(7, 38);
        this.addPredefinedEntity(8, 39);
        this.addPredefinedEntity(9, 34);
    }

    private void addPredefinedEntity(int n, int n2) {
        int n3 = this.fDataStore.allocateRecord(3);
        int[] nArray = this.fDataStore.getRecordArray(n3);
        int n4 = this.fDataStore.getRecordBase(n3);
        nArray[n4 + 0] = 0;
        nArray[n4 + 1] = n;
        nArray[n4 + 2] = n2;
        this.fEntityDecls.put(n, n3);
    }

    private XMLString lookupXMLString(int n) {
        if (n >= 0) {
            return this.fXMLStrings[n];
        }
        return null;
    }

    private int saveXMLString(XMLString xMLString) {
        if (xMLString != null) {
            int n;
            if ((n = this.fXMLStringCount++) == this.fXMLStrings.length) {
                XMLString[] xMLStringArray = new XMLString[n << 1];
                System.arraycopy(this.fXMLStrings, 0, xMLStringArray, 0, n);
                this.fXMLStrings = xMLStringArray;
                this.fXMLStrings[n] = new XMLString();
            } else if (this.fXMLStrings[n] == null) {
                this.fXMLStrings[n] = new XMLString();
            }
            if (this.fStringBuffer != null && this.fStringBuffer.contains(xMLString)) {
                this.fXMLStrings[n].setValues(xMLString);
            } else {
                if (this.fStringBuffer == null) {
                    this.fStringBuffer = new XMLStringBuffer(this.fBufferFactory);
                }
                this.fStringBuffer.addXMLString(xMLString, this.fXMLStrings[n]);
            }
            return n;
        }
        return -1;
    }

    private int saveString(String string) {
        if (string != null) {
            int n;
            if ((n = this.fStringCount++) == this.fStrings.length) {
                String[] stringArray = new String[n << 1];
                System.arraycopy(this.fStrings, 0, stringArray, 0, n);
                this.fStrings = stringArray;
            }
            this.fStrings[n] = this.fStrings[n] == null ? string : string;
            return n;
        }
        return -1;
    }

    private int addInternalEntity(int n, int n2, int n3, boolean bl) {
        int n4 = this.fDataStore.allocateRecord(3);
        int[] nArray = this.fDataStore.getRecordArray(n4);
        int n5 = this.fDataStore.getRecordBase(n4);
        int n6 = bl ? n | 0x10000 : n;
        nArray[n5 + 0] = n6;
        nArray[n5 + 1] = n2;
        nArray[n5 + 2] = n3;
        return n4;
    }

    private int addExternalEntity(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = this.fDataStore.allocateRecord(5);
        int[] nArray = this.fDataStore.getRecordArray(n6);
        int n7 = this.fDataStore.getRecordBase(n6);
        int n8 = bl ? n | 0x10000 : n;
        nArray[n7 + 0] = n8;
        nArray[n7 + 1] = n2;
        nArray[n7 + 3] = n3;
        nArray[n7 + 4] = n4;
        nArray[n7 + 2] = n5;
        return n6;
    }
}

