/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CMP;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509CRLImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;

public final class CurrentCRLInfoValue
extends CMPDerObject
implements InfoValue,
Cloneable {
    private static final ObjectIdentifier oid = CMP.current_crl_oid;
    private CRL value;
    private byte[] encodedValue;

    public CurrentCRLInfoValue(CRL cRL) throws IOException {
        if (cRL == null) {
            throw new IllegalArgumentException("CurrentCRLInfoValue error, crl not specified");
        }
        if (!(cRL instanceof X509CRL)) {
            throw new IllegalArgumentException("CurrentCRLInfoValue error, invalid CRL type. Only X509 CRL is supported");
        }
        this.value = cRL;
        this.setEncodedValue();
    }

    public CurrentCRLInfoValue(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            return new CurrentCRLInfoValue(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        try {
            this.value = new X509CRLImpl(derValue);
        }
        catch (CRLException cRLException) {
            throw new IOException("CurrentCRLInfoValue parsing error, " + cRLException.toString());
        }
        this.setEncodedValue();
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encodedValue);
    }

    public boolean equals(CurrentCRLInfoValue currentCRLInfoValue) {
        DerValue derValue;
        DerValue derValue2;
        if (currentCRLInfoValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            currentCRLInfoValue.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CurrentCRLInfoValue) {
            return this.equals((CurrentCRLInfoValue)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return (byte[])this.encodedValue.clone();
    }

    public String getName() {
        return "CurrentCRL";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        Object var1_1 = null;
        try {
            return new X509CRLImpl(this.encodedValue);
        }
        catch (CRLException cRLException) {
            return null;
        }
    }

    private void setEncodedValue() throws IOException {
        try {
            this.encodedValue = ((X509CRL)this.value).getEncoded();
        }
        catch (CRLException cRLException) {
            throw new IOException("CurrentCRLInfoValue error, " + cRLException);
        }
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "CurrentCRLInfoValue:";
        string = String.valueOf(string) + "\r\nobject identifier: " + oid;
        string = String.valueOf(string) + "\r\ncertificate:\r\n";
        string = object == null ? String.valueOf(string) + "no cert" : String.valueOf(string) + object.toString();
        return string;
    }
}

