/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.internal.ProcessorUsageUtil;
import com.ibm.oti.util.Msg;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public class ProcessorUsage {
    private static final int HASHMASK = 0xFFFFFFF;
    private long user;
    private long system;
    private long idle;
    private long wait;
    private long busy;
    private int id;
    private int online;
    private long timestamp;

    public ProcessorUsage() {
    }

    private ProcessorUsage(long user, long system, long idle, long wait, long busy, int id, int online, long timestamp) throws IllegalArgumentException {
        if (user < -1L) {
            throw new IllegalArgumentException("For id(" + id + "), user(" + user + ") < -1");
        }
        if (system < -1L) {
            throw new IllegalArgumentException("For id(" + id + "), system(" + system + ") < -1");
        }
        if (idle < -1L) {
            throw new IllegalArgumentException("For id(" + id + "), idle(" + idle + ") < -1");
        }
        if (wait < -1L) {
            throw new IllegalArgumentException("For id(" + id + "), wait(" + wait + ") < -1");
        }
        if (busy < -1L) {
            throw new IllegalArgumentException("For id(" + id + "), busy(" + busy + ") < -1");
        }
        if (id < -1) {
            throw new IllegalArgumentException("id(" + id + ") < -1");
        }
        if (online < 0 || online > 1) {
            throw new IllegalArgumentException("For id(" + id + "), online(" + online + ") not in [0,1]");
        }
        if (timestamp < 0L) {
            throw new IllegalArgumentException("For id(" + id + "), timestamp(" + timestamp + ") < 0");
        }
        if (user >= 0L && system >= 0L && wait >= 0L && busy >= 0L && busy < user + system + wait) {
            throw new IllegalArgumentException("For id(" + id + "), busy(" + busy + ") < user(" + user + ") + system(" + system + ") + wait(" + wait + ")");
        }
        this.user = user;
        this.system = system;
        this.idle = idle;
        this.wait = wait;
        this.busy = busy;
        this.id = id;
        this.online = online;
        this.timestamp = timestamp;
    }

    public long getUser() {
        return this.user;
    }

    public long getSystem() {
        return this.system;
    }

    public long getIdle() {
        return this.idle;
    }

    public long getWait() {
        return this.wait;
    }

    public long getBusy() {
        return this.busy;
    }

    public int getId() {
        return this.id;
    }

    public int getOnline() {
        return this.online;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    void updateValues(long user, long system, long idle, long wait, long busy, int id, int online, long timestamp) {
        this.user = user;
        this.system = system;
        this.idle = idle;
        this.wait = wait;
        this.busy = busy;
        this.id = id;
        this.online = online;
        this.timestamp = timestamp;
    }

    public static ProcessorUsage from(CompositeData cd) {
        ProcessorUsage result = null;
        if (null != cd) {
            long timestamp;
            int online;
            int id;
            long busy;
            long wait;
            long idle;
            long system;
            long user;
            if (!ProcessorUsageUtil.getCompositeType().isValue(cd)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                user = (Long)cd.get("user");
                system = (Long)cd.get("system");
                idle = (Long)cd.get("idle");
                wait = (Long)cd.get("wait");
                busy = (Long)cd.get("busy");
                id = (Integer)cd.get("id");
                online = (Integer)cd.get("online");
                timestamp = (Long)cd.get("timestamp");
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            result = new ProcessorUsage(user, system, idle, wait, busy, id, online, timestamp);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n========== ");
        sb.append(this.getClass().getSimpleName());
        sb.append(" ==========\n\n");
        sb.append("timestamp = ");
        sb.append(this.timestamp);
        sb.append("\n");
        sb.append("id = ");
        sb.append(this.id);
        sb.append("\n");
        sb.append("online = ");
        sb.append(this.online);
        sb.append("\n");
        sb.append("user = ");
        sb.append(this.user);
        sb.append("\n");
        sb.append("system = ");
        sb.append(this.system);
        sb.append("\n");
        sb.append("wait = ");
        sb.append(this.wait);
        sb.append("\n");
        sb.append("busy = ");
        sb.append(this.busy);
        sb.append("\n");
        sb.append("idle = ");
        sb.append(this.idle);
        sb.append("\n");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof ProcessorUsage)) {
            return false;
        }
        ProcessorUsage pu = (ProcessorUsage)obj;
        if (pu.getUser() != this.getUser()) {
            return false;
        }
        if (pu.getSystem() != this.getSystem()) {
            return false;
        }
        if (pu.getIdle() != this.getIdle()) {
            return false;
        }
        if (pu.getWait() != this.getWait()) {
            return false;
        }
        if (pu.getBusy() != this.getBusy()) {
            return false;
        }
        if (pu.getId() != this.getId()) {
            return false;
        }
        if (pu.getOnline() != this.getOnline()) {
            return false;
        }
        return pu.getTimestamp() == this.getTimestamp();
    }

    public int hashCode() {
        long pHash = this.getUser() + this.getSystem() + this.getIdle() + this.getWait() + this.getBusy() + (long)this.getId() + (long)this.getOnline() + this.getTimestamp();
        return (int)(((pHash >> 32) + pHash & 0xFFFFFFFL) * 23L);
    }
}

