/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.SignatureProperty;
import org.w3c.dom.Node;

class SignaturePropertyImpl
extends XMLStructureImpl
implements SignatureProperty {
    List<XMLStructure> content;
    private String target;
    private String id;

    SignaturePropertyImpl(AlgorithmFactory f, List content, String target, String id) {
        super(f);
        if (content.size() == 0) {
            throw new IllegalArgumentException("No content");
        }
        this.content = new ArrayList<XMLStructure>(content.size());
        for (XMLStructure obj : content) {
            this.content.add(obj);
        }
        if (target == null) {
            throw new NullPointerException("The target must not be null.");
        }
        this.target = target;
        this.id = id;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureProperty)) {
            return false;
        }
        SignatureProperty osp = (SignatureProperty)o;
        boolean idsEqual = this.id == null ? osp.getId() == null : this.id.equals(osp.getId());
        List<XMLStructure> ospContent = osp.getContent();
        boolean contentEqual = this.equalsContent(ospContent);
        boolean targetEqual = this.target.equals(osp.getTarget());
        return contentEqual && targetEqual && idsEqual;
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        result = 31 * result + this.target.hashCode();
        result = 31 * result + this.content.hashCode();
        return result;
    }

    private boolean equalsContent(List<XMLStructure> otherContent) {
        int osize = otherContent.size();
        if (this.content.size() != osize) {
            return false;
        }
        for (int i = 0; i < osize; ++i) {
            XMLStructure oxs = otherContent.get(i);
            XMLStructure xs = this.content.get(i);
            if (oxs instanceof DOMStructure) {
                if (!(xs instanceof DOMStructure)) {
                    return false;
                }
                Node onode = ((DOMStructure)oxs).getNode();
                Node node = ((DOMStructure)xs).getNode();
                if (DOMUtil.nodesEqual(node, onode)) continue;
                return false;
            }
            if (xs.equals(oxs)) continue;
            return false;
        }
        return true;
    }
}

