/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.AlgorithmMethodImpl;
import com.ibm.xml.crypto.spi.SignatureEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;

class SignatureMethodImpl
extends AlgorithmMethodImpl
implements SignatureMethod {
    SignatureMethodImpl(AlgorithmFactory f, String alg, SignatureMethodParameterSpec param) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        super(f, alg, param);
        SignatureEngine eng = this.afactory.getSignatureEngine(alg);
        try {
            eng.setParameter(param);
        }
        catch (InvalidAlgorithmParameterException iae) {
            throw iae;
        }
        finally {
            this.afactory.releaseSignatureEngine(eng);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureMethod)) {
            return false;
        }
        SignatureMethod osm = (SignatureMethod)o;
        boolean algEqual = this.getAlgorithm().equals(osm.getAlgorithm());
        boolean paramSpecEqual = this.getParameterSpec() == osm.getParameterSpec();
        return algEqual && paramSpecEqual;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getAlgorithm().hashCode();
        AlgorithmParameterSpec spec = this.getParameterSpec();
        if (spec != null) {
            result = 31 * result + spec.hashCode();
        }
        return result;
    }
}

