/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ComputedCalls;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.PrimitiveHandle;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Constructor;

final class ConstructorHandle
extends PrimitiveHandle {
    private static final ThunkTable _thunkTable;

    public ConstructorHandle(Class<?> referenceClass, MethodType type) throws NoSuchMethodException, IllegalAccessException {
        super(ConstructorHandle.constructorMethodType(type, referenceClass), referenceClass, "<init>", (byte)8, null);
        this.defc = this.finishMethodInitialization(referenceClass, type);
    }

    public ConstructorHandle(Constructor<?> ctor) throws IllegalAccessException {
        super(ConstructorHandle.constructorMethodType(ctor), ctor.getDeclaringClass(), "<init>", (byte)8, ctor.getModifiers(), ctor.getDeclaringClass());
        boolean succeed = ConstructorHandle.setVMSlotAndRawModifiersFromConstructor(this, ctor);
        if (!succeed) {
            throw new IllegalAccessException();
        }
    }

    ConstructorHandle(ConstructorHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
    }

    private static final MethodType constructorMethodType(MethodType type, Class<?> referenceClazz) {
        return type.changeReturnType(referenceClazz);
    }

    private static final MethodType constructorMethodType(Constructor<?> constructor) {
        Class<?> declaringClass = constructor.getDeclaringClass();
        return MethodType.methodType(declaringClass, constructor.getParameterTypes());
    }

    @Override
    boolean canRevealDirect() {
        return true;
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @MethodHandle.FrameIteratorSkip
    private final Object invokeExact_thunkArchetype_L(int argPlaceholder) {
        if (ILGenMacros.isCustomThunk()) {
            DirectHandle.directCall_V(ILGenMacros.push(ILGenMacros.rawNew(this.referenceClass)), argPlaceholder);
        } else if (DirectHandle.isAlreadyCompiled(this.vmSlot)) {
            ComputedCalls.dispatchDirect_V(DirectHandle.compiledEntryPoint(this.vmSlot), ILGenMacros.push(ILGenMacros.rawNew(this.referenceClass)), argPlaceholder);
        } else {
            ComputedCalls.dispatchJ9Method_V(this.vmSlot, ILGenMacros.push(ILGenMacros.rawNew(this.referenceClass)), argPlaceholder);
        }
        return ILGenMacros.pop_L();
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new ConstructorHandle(this, newType);
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof ConstructorHandle) {
            ((ConstructorHandle)right).compareWithConstructor(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithConstructor(ConstructorHandle left, Comparator c) {
        c.compareStructuralParameter(left.referenceClass, this.referenceClass);
    }

    static {
        DirectHandle.load();
        _thunkTable = new ThunkTable();
    }
}

