/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.MemoryUsageUtil;
import com.ibm.oti.util.Msg;
import com.sun.management.GcInfo;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class GcInfoUtil {
    private static CompositeType compositeType;
    private static Constructor<GcInfo> gcInfoPrivateConstructor;

    private static Constructor<GcInfo> getGcInfoPrivateConstructor() {
        if (null == gcInfoPrivateConstructor) {
            gcInfoPrivateConstructor = AccessController.doPrivileged(new PrivilegedAction<Constructor<GcInfo>>(){

                @Override
                public Constructor<GcInfo> run() {
                    try {
                        Constructor<GcInfo> constructor = GcInfo.class.getDeclaredConstructor(Long.TYPE, Long.TYPE, Long.TYPE, Map.class, Map.class);
                        constructor.setAccessible(true);
                        return constructor;
                    }
                    catch (NoSuchMethodException e) {
                        InternalError error = new InternalError(Msg.getString("K0660"));
                        error.initCause(e);
                        throw error;
                    }
                }
            });
        }
        return gcInfoPrivateConstructor;
    }

    public static CompositeType getCompositeType() {
        block3: {
            if (null == compositeType) {
                String[] names = new String[]{"index", "startTime", "endTime", "usageBeforeGc", "usageAfterGc"};
                String[] descs = new String[]{"index", "startTime", "endTime", "usageBeforeGc", "usageAfterGc"};
                OpenType[] types = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, MemoryUsageUtil.getTabularType(), MemoryUsageUtil.getTabularType()};
                try {
                    compositeType = new CompositeType(GcInfo.class.getName(), GcInfo.class.getName(), names, descs, types);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static CompositeData toCompositeData(GcInfo info) {
        CompositeDataSupport result;
        block3: {
            result = null;
            if (null != info) {
                CompositeType type = GcInfoUtil.getCompositeType();
                String[] names = new String[]{"index", "startTime", "endTime", "usageBeforeGc", "usageAfterGc"};
                Object[] values = new Object[]{info.getId(), info.getStartTime(), info.getEndTime(), MemoryUsageUtil.toTabularData(info.getMemoryUsageBeforeGc()), MemoryUsageUtil.toTabularData(info.getMemoryUsageAfterGc())};
                try {
                    result = new CompositeDataSupport(type, names, values);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return result;
    }

    public static GcInfo newGcInfoInstance(long index, long startTime, long endTime, Map<String, MemoryUsage> usageBeforeGc, Map<String, MemoryUsage> usageAfterGc) {
        GcInfo gcInfo = null;
        Constructor<GcInfo> gcInfoConstructor = GcInfoUtil.getGcInfoPrivateConstructor();
        try {
            gcInfo = gcInfoConstructor.newInstance(index, startTime, endTime, usageBeforeGc, usageAfterGc);
        }
        catch (Exception e) {
            InternalError error = new InternalError(Msg.getString("K0661"));
            error.initCause(e);
            throw error;
        }
        return gcInfo;
    }

    private GcInfoUtil() {
    }

    static {
        gcInfoPrivateConstructor = null;
    }
}

