/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.internal.JvmCpuMonitorInfoUtil;
import com.ibm.oti.util.Msg;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public final class JvmCpuMonitorInfo {
    private static final int HASHMASK = 0xFFFFFFF;
    private static final int NUM_USER_DEFINED_CATEGORY = 5;
    private long timestamp;
    private long applicationCpuTime;
    private long resourceMonitorCpuTime;
    private long systemJvmCpuTime;
    private long gcCpuTime;
    private long jitCpuTime;
    private final long[] applicationUserCpuTime = new long[5];

    public JvmCpuMonitorInfo() {
    }

    private JvmCpuMonitorInfo(long timestamp, long applicationCpuTime, long resourceMonitorCpuTime, long systemJvmCpuTime, long gcCpuTime, long jitCpuTime, long[] applicationUserCpuTime) throws IllegalArgumentException {
        if (timestamp < 0L || applicationCpuTime < 0L || resourceMonitorCpuTime < 0L || systemJvmCpuTime < 0L || gcCpuTime < 0L || jitCpuTime < 0L) {
            throw new IllegalArgumentException();
        }
        this.timestamp = timestamp;
        this.applicationCpuTime = applicationCpuTime;
        this.resourceMonitorCpuTime = resourceMonitorCpuTime;
        this.systemJvmCpuTime = systemJvmCpuTime;
        this.gcCpuTime = gcCpuTime;
        this.jitCpuTime = jitCpuTime;
        System.arraycopy((Object)applicationUserCpuTime, 0, (Object)this.applicationUserCpuTime, 0, applicationUserCpuTime.length);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getApplicationCpuTime() {
        return this.applicationCpuTime;
    }

    public long getResourceMonitorCpuTime() {
        return this.resourceMonitorCpuTime;
    }

    public long getSystemJvmCpuTime() {
        return this.systemJvmCpuTime;
    }

    public long getGcCpuTime() {
        return this.gcCpuTime;
    }

    public long getJitCpuTime() {
        return this.jitCpuTime;
    }

    public long[] getApplicationUserCpuTime() {
        long[] applicationUserCpuTimeData = (long[])this.applicationUserCpuTime.clone();
        return applicationUserCpuTimeData;
    }

    void updateValues(long tstamp, long appTime, long rmonTime, long sysTime, long gcTime, long jitTime, long[] appUserTime) {
        this.timestamp = tstamp;
        this.applicationCpuTime = appTime;
        this.resourceMonitorCpuTime = rmonTime;
        this.systemJvmCpuTime = sysTime;
        this.gcCpuTime = gcTime;
        this.jitCpuTime = jitTime;
        System.arraycopy((Object)appUserTime, 0, (Object)this.applicationUserCpuTime, 0, appUserTime.length);
    }

    public static JvmCpuMonitorInfo from(CompositeData cd) {
        JvmCpuMonitorInfo result = null;
        if (null != cd) {
            long[] applicationUserCpuTime;
            long jitCpuTime;
            long gcCpuTime;
            long systemJvmCpuTime;
            long resourceMonitorCpuTime;
            long applicationCpuTime;
            long timestamp;
            if (!JvmCpuMonitorInfoUtil.getCompositeType().isValue(cd)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                timestamp = (Long)cd.get("timestamp");
                applicationCpuTime = (Long)cd.get("applicationCpuTime");
                resourceMonitorCpuTime = (Long)cd.get("resourceMonitorCpuTime");
                systemJvmCpuTime = (Long)cd.get("systemJvmCpuTime");
                gcCpuTime = (Long)cd.get("gcCpuTime");
                jitCpuTime = (Long)cd.get("jitCpuTime");
                applicationUserCpuTime = (long[])cd.get("applicationUserCpuTime");
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            result = new JvmCpuMonitorInfo(timestamp, applicationCpuTime, resourceMonitorCpuTime, systemJvmCpuTime, gcCpuTime, jitCpuTime, applicationUserCpuTime);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n========== ");
        sb.append(this.getClass().getSimpleName());
        sb.append(" ==========\n\n");
        sb.append("             timestamp = ");
        sb.append(this.timestamp);
        sb.append("\n");
        sb.append("      systemJvmCpuTime = ");
        sb.append(this.systemJvmCpuTime);
        sb.append("\n");
        sb.append("             gcCpuTime = ");
        sb.append(this.gcCpuTime);
        sb.append("\n");
        sb.append("            jitCpuTime = ");
        sb.append(this.jitCpuTime);
        sb.append("\n");
        sb.append("resourceMonitorCpuTime = ");
        sb.append(this.resourceMonitorCpuTime);
        sb.append("\n");
        sb.append("    applicationCpuTime = ");
        sb.append(this.applicationCpuTime);
        sb.append("\n");
        for (int i = 0; i < this.applicationUserCpuTime.length; ++i) {
            sb.append("      applicationUser");
            sb.append(i + 1);
            sb.append(" = ");
            sb.append(this.applicationUserCpuTime[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof JvmCpuMonitorInfo)) {
            return false;
        }
        JvmCpuMonitorInfo jcmInfo = (JvmCpuMonitorInfo)obj;
        if (jcmInfo.getTimestamp() != this.getTimestamp()) {
            return false;
        }
        if (jcmInfo.getApplicationCpuTime() != this.getApplicationCpuTime()) {
            return false;
        }
        if (jcmInfo.getResourceMonitorCpuTime() != this.getResourceMonitorCpuTime()) {
            return false;
        }
        if (jcmInfo.getSystemJvmCpuTime() != this.getSystemJvmCpuTime()) {
            return false;
        }
        if (jcmInfo.getGcCpuTime() != this.getGcCpuTime()) {
            return false;
        }
        if (jcmInfo.getJitCpuTime() != this.getJitCpuTime()) {
            return false;
        }
        long[] applicationUserCpuTimeData = jcmInfo.getApplicationUserCpuTime();
        for (int i = 0; i < applicationUserCpuTimeData.length; ++i) {
            if (applicationUserCpuTimeData[i] == this.applicationUserCpuTime[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long uHash = this.getTimestamp() + this.getApplicationCpuTime() + this.getResourceMonitorCpuTime() + this.getSystemJvmCpuTime() + this.getGcCpuTime() + this.getJitCpuTime();
        for (int i = 0; i < this.applicationUserCpuTime.length; ++i) {
            uHash += this.applicationUserCpuTime[i];
        }
        return (int)(((uHash >> 32) + uHash & 0xFFFFFFFL) * 23L);
    }
}

