/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.DisplayText;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Vector;

public final class NoticeReference
implements Cloneable {
    private DisplayText organization;
    private BigInteger[] noticeNumbers;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.NoticeReference";
    private volatile int cachedHashVal = 0;

    public NoticeReference(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "NoticeReference", (Object)der);
        }
        DerInputStream derin = new DerInputStream(der);
        DerValue encoding = derin.getDerValue();
        this.decode(encoding);
        if (debug != null) {
            debug.exit(16384L, className, "NoticeReference");
        }
    }

    public NoticeReference(DisplayText organization, BigInteger[] noticeNumbers) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "NoticeReference", organization, noticeNumbers);
        }
        if (organization == null) {
            if (debug != null) {
                debug.text(16384L, className, "NoticeReference", "organization not specified");
            }
            throw new IllegalArgumentException("organization not specified");
        }
        if (noticeNumbers == null) {
            if (debug != null) {
                debug.text(16384L, className, "NoticeReference", "noticeNumbers not specified");
            }
            throw new IllegalArgumentException("noticeNumbers not specified");
        }
        this.organization = organization;
        this.noticeNumbers = (BigInteger[])noticeNumbers.clone();
        if (debug != null) {
            debug.exit(16384L, className, "NoticeReference");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            NoticeReference result = new NoticeReference(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", result);
            }
            return new NoticeReference(derout.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        this.organization.encode(bytes);
        DerOutputStream derout = new DerOutputStream();
        for (int i = 0; i < this.noticeNumbers.length; ++i) {
            derout.putInteger(this.noticeNumbers[i]);
        }
        bytes.write((byte)48, derout);
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "NoticeReference parsing error.  Expected sequence.");
            }
            throw new IOException("NoticeReference parsing error.  Expected sequence.");
        }
        DerValue der = encoding.getData().getDerValue();
        this.organization = new DisplayText(der.toByteArray());
        der = encoding.getData().getDerValue();
        if (der.getTag() == 48) {
            Vector<BigInteger> numbers = new Vector<BigInteger>();
            if (der.getData().available() == 0 && debug != null) {
                debug.text(16384L, className, "decode", "NoticeNumbers is empty.");
            }
            while (der.getData().available() != 0) {
                BigInteger num = der.getData().getInteger();
                numbers.addElement(num);
            }
            this.noticeNumbers = new BigInteger[numbers.size()];
            for (int i = 0; i < this.noticeNumbers.length; ++i) {
                this.noticeNumbers[i] = (BigInteger)numbers.elementAt(i);
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "NoticeReference parsing error.  Expected notice numbers.");
            }
            throw new IOException("NoticeReference parsing error.  Expected notice numbers.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof NoticeReference)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((NoticeReference)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public DisplayText getOrganization() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOrganization");
            debug.exit(16384L, (Object)className, "getOrganization", this.organization);
        }
        return this.organization;
    }

    public BigInteger[] getNoticeNumbers() {
        if (debug != null) {
            debug.entry(16384L, className, "getNoticeNumbers");
            debug.exit(16384L, (Object)className, "getNoticeNumbers", (BigInteger[])this.noticeNumbers.clone());
        }
        return (BigInteger[])this.noticeNumbers.clone();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "";
        out = out + "Notice Reference: [";
        out = out + "\r\n\torganization  : " + this.organization.toString();
        out = out + "\r\n\tnotice numbers: ";
        for (int i = 0; i < this.noticeNumbers.length; ++i) {
            out = out + "\r\n\t\t" + this.noticeNumbers[i];
        }
        out = out + "\r\n]";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }
}

