/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public final class ExtKeyUsageExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.ExtKeyUsage";
    public static final String NAME = "ExtKeyUsage";
    public static final String EXT_KEY_USAGE = "extkeyusage";
    private static final Map<ObjectIdentifier, String> map = new HashMap<ObjectIdentifier, String>();
    private static final int[] anyExtendedKeyUsageOidData = new int[]{2, 5, 29, 37, 0};
    private static final int[] serverAuthOidData = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 1};
    private static final int[] clientAuthOidData = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 2};
    private static final int[] codeSigningOidData = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 3};
    private static final int[] emailProtectionOidData = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 4};
    private static final int[] ipsecEndSystemOidData = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 5};
    private static final int[] ipsecTunnelOidData = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 6};
    private static final int[] ipsecUserOidData = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 7};
    private static final int[] timeStampingOidData = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 8};
    private static final int[] OCSPSigningOidData = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 9};
    private Vector<ObjectIdentifier> keyUsages;

    private void encodeThis() throws IOException {
        if (this.keyUsages == null || this.keyUsages.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream os = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.keyUsages.size(); ++i) {
            tmp.putOID(this.keyUsages.elementAt(i));
        }
        os.write((byte)48, tmp);
        this.extensionValue = os.toByteArray();
    }

    public ExtKeyUsageExtension(Vector<ObjectIdentifier> keyUsages) throws IOException {
        this(Boolean.FALSE, keyUsages);
    }

    public ExtKeyUsageExtension() {
        this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
        this.critical = false;
        this.keyUsages = new Vector();
    }

    public ExtKeyUsageExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for ExtKeyUsageExtension.");
        }
        this.keyUsages = new Vector();
        while (val.data.available() != 0) {
            DerValue seq = val.data.getDerValue();
            ObjectIdentifier usage = seq.getOID();
            this.keyUsages.addElement(usage);
        }
    }

    public ExtKeyUsageExtension(Boolean critical, Vector<ObjectIdentifier> keyUsages) throws IOException {
        this.keyUsages = keyUsages;
        this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
        this.critical = critical;
        this.encodeThis();
    }

    @Override
    public String toString() {
        if (this.keyUsages == null) {
            return "";
        }
        String usage = "  ";
        boolean first = true;
        for (ObjectIdentifier oid : this.keyUsages) {
            String result;
            if (!first) {
                usage = usage + "\n  ";
            }
            usage = (result = map.get(oid)) != null ? usage + result : usage + oid.toString();
            first = false;
        }
        return super.toString() + "ExtendedKeyUsages [\n" + usage + "\n]\n";
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.ExtKeyUsage_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(EXT_KEY_USAGE)) {
            if (!(obj instanceof Vector)) {
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:ExtKeyUsageExtension.");
        }
        this.keyUsages = (Vector)obj;
        this.encodeThis();
    }

    @Override
    public Vector<ObjectIdentifier> get(String name) throws IOException {
        if (name.equalsIgnoreCase(EXT_KEY_USAGE)) {
            return this.keyUsages;
        }
        throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:ExtKeyUsageExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(EXT_KEY_USAGE)) {
            throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:ExtKeyUsageExtension.");
        }
        this.keyUsages = null;
        this.encodeThis();
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(EXT_KEY_USAGE);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public List<String> getExtendedKeyUsage() {
        ArrayList<String> al = new ArrayList<String>(this.keyUsages.size());
        for (ObjectIdentifier oid : this.keyUsages) {
            al.add(oid.toString());
        }
        return al;
    }

    static {
        map.put(ObjectIdentifier.newInternal(anyExtendedKeyUsageOidData), "anyExtendedKeyUsage");
        map.put(ObjectIdentifier.newInternal(serverAuthOidData), "serverAuth");
        map.put(ObjectIdentifier.newInternal(clientAuthOidData), "clientAuth");
        map.put(ObjectIdentifier.newInternal(codeSigningOidData), "codeSigning");
        map.put(ObjectIdentifier.newInternal(emailProtectionOidData), "emailProtection");
        map.put(ObjectIdentifier.newInternal(ipsecEndSystemOidData), "ipsecEndSystem");
        map.put(ObjectIdentifier.newInternal(ipsecTunnelOidData), "ipsecTunnel");
        map.put(ObjectIdentifier.newInternal(ipsecUserOidData), "ipsecUser");
        map.put(ObjectIdentifier.newInternal(timeStampingOidData), "timeStamping");
        map.put(ObjectIdentifier.newInternal(OCSPSigningOidData), "OCSPSigning");
    }
}

