/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.attach.spi;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachPermission;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import jdk.Exported;

@Exported
public abstract class AttachProvider {
    private static final Object lock = new Object();
    private static List<AttachProvider> providers = null;

    protected AttachProvider() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AttachPermission("createAttachProvider"));
        }
    }

    public abstract String name();

    public abstract String type();

    public abstract VirtualMachine attachVirtualMachine(String var1) throws AttachNotSupportedException, IOException;

    public VirtualMachine attachVirtualMachine(VirtualMachineDescriptor virtualMachineDescriptor) throws AttachNotSupportedException, IOException {
        if (virtualMachineDescriptor.provider() != this) {
            throw new AttachNotSupportedException("provider mismatch");
        }
        return this.attachVirtualMachine(virtualMachineDescriptor.id());
    }

    public abstract List<VirtualMachineDescriptor> listVirtualMachines();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AttachProvider> providers() {
        Object object = lock;
        synchronized (object) {
            if (providers == null) {
                providers = new ArrayList<AttachProvider>();
                ServiceLoader<AttachProvider> serviceLoader = ServiceLoader.load(AttachProvider.class, AttachProvider.class.getClassLoader());
                Iterator<AttachProvider> iterator = serviceLoader.iterator();
                while (iterator.hasNext()) {
                    try {
                        providers.add(iterator.next());
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            ThreadDeath threadDeath = (ThreadDeath)throwable;
                            throw threadDeath;
                        }
                        System.err.println(throwable);
                    }
                }
            }
            return Collections.unmodifiableList(providers);
        }
    }
}

