/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.fmt;

import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkEvent;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkIoException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.fmt.PkPkcsEventFormatter;
import com.ibm.security.certclient.util.PkArray;
import com.ibm.security.certclient.util.PkBase64InputStream;
import com.ibm.security.certclient.util.PkBase64OutputStream;
import com.ibm.security.certclient.util.PkString;
import com.ibm.security.util.DerValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PkBase64PkcsEventFormatter
extends PkPkcsEventFormatter
implements PkConstants {
    private static final String sccsid = "%Z% %M% %I%    %W% %G% %U%";
    private static final String BEGIN_STR = "-----BEGIN ";
    private static final String END_REP_STR = "-----END CERTIFICATE-----\r\n";
    private static final String END_REQ_STR = "-----END NEW CERTIFICATE REQUEST-----\r\n";
    private static final String REPLY_STR = "CERTIFICATE-----\r\n";
    private static final String REQUEST_STR = "NEW CERTIFICATE RE";
    private static final String REQUEST_2_STR = "QUEST-----\r\n";
    private static final byte[] BEGIN = PkString.toUtf("-----BEGIN ");
    private static final byte[] END_REP = PkString.toUtf("-----END CERTIFICATE-----\r\n");
    private static final byte[] END_REQ = PkString.toUtf("-----END NEW CERTIFICATE REQUEST-----\r\n");
    private static final byte[] REPLY = PkString.toUtf("CERTIFICATE-----\r\n");
    private static final byte[] REQUEST = PkString.toUtf("NEW CERTIFICATE RE");
    private static final byte[] REQUEST_2 = PkString.toUtf("QUEST-----\r\n");
    private static final byte[] BEGIN_REQ = PkString.toUtf("-----BEGIN NEW CERTIFICATE REQUEST-----\r\n");
    private static final byte[] BEGIN_REP = PkString.toUtf("-----BEGIN CERTIFICATE-----\r\n");
    private static int UNKNOWN_TYPE = 0;
    private static int REQUEST_TYPE = 1;
    private static int REPLY_TYPE = 2;

    @Override
    public PkEvent readEvent(Object object, InputStream inputStream, PkReqEvent pkReqEvent) throws PkException, IOException {
        byte[] byArray = new byte[END_REQ.length];
        int n = inputStream.read(byArray, 0, BEGIN.length);
        if (n == -1) {
            throw new EOFException();
        }
        if (!PkArray.isPrefix(BEGIN, byArray)) {
            this.throwExpected(BEGIN_STR, byArray, BEGIN.length);
        }
        inputStream.read(byArray, 0, REPLY.length);
        int n2 = UNKNOWN_TYPE;
        if (PkArray.isPrefix(REPLY, byArray)) {
            n2 = REPLY_TYPE;
        } else if (PkArray.isPrefix(REQUEST, byArray)) {
            inputStream.read(byArray, 0, REQUEST_2.length);
            if (!PkArray.isPrefix(REQUEST_2, byArray)) {
                this.throwExpected(REQUEST_2_STR, byArray, REQUEST_2.length);
            }
            n2 = REQUEST_TYPE;
        } else {
            this.throwExpected("CERTIFICATE-----\r\n\" or \"NEW CERTIFICATE REQUEST-----\r\n", byArray, REPLY.length);
        }
        DerValue derValue = new DerValue((InputStream)new PkBase64InputStream(inputStream));
        byArray[0] = 45;
        if (n2 == REQUEST_TYPE) {
            inputStream.read(byArray, 1, END_REQ.length - 1);
            return this.readCertReqEvent(object, derValue);
        }
        inputStream.read(byArray, 1, END_REP.length - 1);
        return this.readCertRepEvent(object, derValue, pkReqEvent);
    }

    @Override
    public void writeCertReq(PkCertReqEvent pkCertReqEvent, OutputStream outputStream) throws IOException {
        outputStream.write(BEGIN_REQ);
        PkBase64OutputStream pkBase64OutputStream = new PkBase64OutputStream(outputStream);
        super.writeCertReq(pkCertReqEvent, pkBase64OutputStream);
        pkBase64OutputStream.end();
        outputStream.write(END_REQ);
    }

    @Override
    public void writeCertRep(PkCertRepEvent pkCertRepEvent, OutputStream outputStream) throws IOException {
        outputStream.write(BEGIN_REP);
        PkBase64OutputStream pkBase64OutputStream = new PkBase64OutputStream(outputStream);
        super.writeCertRep(pkCertRepEvent, pkBase64OutputStream);
        pkBase64OutputStream.end();
        outputStream.write(END_REP);
    }

    private void throwExpected(String string, byte[] byArray, int n) throws PkIoException {
        throw new PkIoException(PkNLSConstants.BASE64TOPKCS_EXPECTED + string);
    }
}

