/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.methodprofiling.postprocessor.nodejs;

import com.ibm.java.diagnostics.common.datamodel.data.ControllableData;
import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.ProfilingLabels;
import com.ibm.java.diagnostics.healthcenter.methodprofiling.postprocessor.nodejs.Messages;
import com.ibm.java.diagnostics.healthcenter.postprocessor.MissingTraceBasedDataPostProcessor;
import java.text.MessageFormat;
import java.util.List;

public class MissingProfilingDataPostProcessor
extends MissingTraceBasedDataPostProcessor {
    private static final String BLANK = "";
    private static final String SPACE = " ";
    private static final String XNOJIT = "-Xnojit";
    private static final String XSAMPLING_EXPIRATION_TIME = "-XsamplingExpirationTime";
    private static final String XINT = "-Xint";
    private static final String XJIT_OFF = "-Xjit:off";

    @Override
    protected String getMissingDataAdvice(Data data) {
        Object object;
        String string = Messages.getString("Profiling.no.data");
        String string2 = this.getDebugOptionAffectingSamplingThread(data);
        String string3 = this.getByteCodeOptionAffectingSamplingThread(data);
        String string4 = this.getJitOptionAffectingProfiling(data);
        boolean bl = false;
        if (string4 != null) {
            object = Messages.getString("MissingProfilingDataPostProcessor.jit.stops.profiling");
            string = MessageFormat.format((String)object, string4);
            bl = true;
        }
        if (string2 != null) {
            object = Messages.getString("MissingProfilingDataPostProcessor.debug.stops.profiling");
            string = MessageFormat.format((String)object, string2);
            string = string + this.getFullSpeedDebugWorkaround(data);
            bl = true;
        }
        if (string3 != null) {
            object = Messages.getString("MissingProfilingDataPostProcessor.bytecode.stops.profiling");
            string = MessageFormat.format((String)object, string3);
            string = string + this.getFullSpeedDebugWorkaround(data);
            bl = true;
        }
        if (this.isVMOlderThan(20080301, data)) {
            string = string + SPACE + OLD_VM;
            bl = true;
        }
        if (data != null && (object = data.getData("profiling_subsystem")) instanceof ControllableData) {
            if (!object.isEnabled()) {
                return Messages.getString("MissingProfilingDataPostProcessor.profiling.disabled");
            }
            return Messages.getString("MissingProfilingDataPostProcessor.profiling.enabledNoData");
        }
        if (!this.isJVMTITraceSubscriberAvailable(data) && !this.isXtraceOutputSpecified(data)) {
            string = string + SPACE + TRACE_NOT_SET;
            bl = true;
        }
        if (!bl) {
            string = string + SPACE + Messages.getString("Profiling.advice");
        }
        return string;
    }

    private String getFullSpeedDebugWorkaround(Data data) {
        String string = BLANK;
        int n = this.getJavaVersion(data);
        if (n == 6) {
            string = Messages.getString("MissingProfilingDataPostProcessor.fsd.workaround");
        }
        return string;
    }

    private String getDebugOptionAffectingSamplingThread(Data data) {
        EnvironmentData environmentData;
        List<String> list;
        String string = null;
        Data data2 = data.getData(JVMLabels.ENVIRONMENT);
        if (data2 instanceof EnvironmentData && (list = (environmentData = (EnvironmentData)data2).getCommandLineOptions()) != null) {
            for (String string2 : list) {
                if (!string2.startsWith("-Xdbg") && (!string2.startsWith("-agent") && !string2.startsWith("-Xrun") || !string2.contains("jdwp"))) continue;
                string = string2;
            }
        }
        return string;
    }

    private String getByteCodeOptionAffectingSamplingThread(Data data) {
        EnvironmentData environmentData;
        List<String> list;
        String string = null;
        Data data2 = data.getData(JVMLabels.ENVIRONMENT);
        if (data2 instanceof EnvironmentData && (list = (environmentData = (EnvironmentData)data2).getCommandLineOptions()) != null) {
            for (String string2 : list) {
                if (!string2.startsWith("-javaagent") || !string2.contains("probeagent.jar")) continue;
                string = string2;
            }
        }
        return string;
    }

    private String getJitOptionAffectingProfiling(Data data) {
        EnvironmentData environmentData;
        List<String> list;
        String string = null;
        Data data2 = data.getData(JVMLabels.ENVIRONMENT);
        if (data2 instanceof EnvironmentData && (list = (environmentData = (EnvironmentData)data2).getCommandLineOptions()) != null) {
            for (String string2 : list) {
                if (!XJIT_OFF.equals(string2) && !XINT.equals(string2) && !XSAMPLING_EXPIRATION_TIME.equals(string2) && !XNOJIT.equals(string2)) continue;
                string = string2;
            }
        }
        return string;
    }

    @Override
    protected String getDataLabel() {
        return ProfilingLabels.DATA_LABEL;
    }

    @Override
    protected String getRecommendationLabel() {
        return ProfilingLabels.PROFILE_INTERPRETATION;
    }

    @Override
    protected String getSubsystemCapabilityId() {
        return "profiling_node_subsystem";
    }
}

