/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jvmtrace.impl;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetricsUtil;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.Messages;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class TraceDataLossPostProcessor
implements PostProcessor {
    private static final Logger TRACE = LogFactory.getTrace(TraceDataLossPostProcessor.class);
    private final String className = this.getClass().getName();

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        ConnectionDataBuilder connectionDataBuilder;
        TRACE.entering(this.className, "postprocess");
        DataBuilder dataBuilder2 = dataBuilder.getData(JVMLabels.CONNECTION);
        if (dataBuilder2 instanceof ConnectionDataBuilder && (connectionDataBuilder = (ConnectionDataBuilder)dataBuilder2).getStatus().compareTo(Status.WARNING) <= 0) {
            double d = TraceMetricsUtil.getMissingDataRatio(dataBuilder) * 100.0;
            connectionDataBuilder.setStatus(Status.HEALTHY);
            connectionDataBuilder.clearValue();
            if (d >= 0.1) {
                String string = d >= 1.0 ? NumberFormatter.prettyString(d, 0) : NumberFormatter.prettyString(d, 1);
                String string2 = Messages.getString("TraceParser.data.dropped.percentage");
                String string3 = MessageFormat.format(string2, string);
                connectionDataBuilder.addValue(string3);
                connectionDataBuilder.setStatus(Status.WARNING);
            }
        }
        TRACE.exiting(this.className, "postprocess");
    }
}

