/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.strings;

import com.ibm.java.diagnostics.common.datamodel.impl.strings.Messages;
import com.ibm.java.diagnostics.common.datamodel.impl.strings.ReplacerNode;
import com.ibm.java.diagnostics.common.datamodel.impl.strings.StringPair;
import java.text.MessageFormat;
import java.util.Vector;

public class TextReplacer {
    private ReplacerNode root;
    public static final int HIGHEST_REPLACE_CHAR = 255;
    private static final byte NO_MATCH = 0;
    private static final byte PARTIAL_MATCH = 1;
    private Vector<String> matchTable = new Vector();

    public TextReplacer(StringPair[] stringPairArray) {
        if (stringPairArray.length >= 128) {
            throw new Error(Messages.getString("TextReplacer.can.only.replace.128.sequences"));
        }
        this.root = new ReplacerNode(255);
        for (int i = 0; i < stringPairArray.length; ++i) {
            this.growTable(stringPairArray[i]);
        }
    }

    private void growTable(StringPair stringPair) {
        int n = stringPair.key.length();
        Object object = this.root;
        for (int i = 0; i < n; ++i) {
            Object object2;
            char c = stringPair.key.charAt(i);
            if (c > '\u00ff') {
                object2 = Messages.getString("TextReplacer.replace.value.too.high");
                String string = MessageFormat.format((String)object2, 255);
                throw new Error(string);
            }
            object2 = ((ReplacerNode)object).nextNode[c];
            if (object2 != null) {
                object = object2;
                continue;
            }
            if (i == n - 1) {
                this.matchTable.addElement(stringPair.value);
                ((ReplacerNode)object).action[c] = (byte)(this.matchTable.size() + 1);
                continue;
            }
            ((ReplacerNode)object).nextNode[c] = new ReplacerNode(255);
            ((ReplacerNode)object).action[c] = 1;
            object = ((ReplacerNode)object).nextNode[c];
        }
    }

    public String replaceText(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        ReplacerNode replacerNode = this.root;
        int n2 = -1;
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > 'z') continue;
            byte by = c <= '\u00ff' ? replacerNode.action[c] : (byte)0;
            switch (by) {
                case 0: {
                    if (n2 == -1) {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    stringBuffer.append(string.charAt(n2));
                    replacerNode = this.root;
                    i = n2;
                    n2 = -1;
                    continue block4;
                }
                case 1: {
                    if (n2 == -1) {
                        n2 = i;
                    }
                    replacerNode = replacerNode.nextNode[c];
                    continue block4;
                }
                default: {
                    stringBuffer.append(this.matchTable.elementAt(by - 2));
                    n2 = -1;
                    replacerNode = this.root;
                }
            }
        }
        return stringBuffer.toString();
    }
}

