/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.converters;

import com.ibm.java.diagnostics.common.datamodel.impl.util.Messages;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;

public class DaysFormatter {
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    public static final MessageFormat NORMALISED_TIME_FORMAT = new MessageFormat(Messages.getString("DateUnitConverter.normalised.timestamp.format"));
    private static final int SECONDS_PER_DAY = 86400;
    public static final double MILLISECONDS_PER_DAY = 8.64E7;
    public static final double DAYS_PER_MILLISECOND = 1.1574074074074074E-8;
    private static final int MINUTES_PER_DAY = 1440;

    public static String format(double d) {
        double d2 = d * 8.64E7;
        long l = Math.round(d2);
        long l2 = l / 1000L;
        long l3 = (l2 += 86400L) / 86400L;
        long l4 = l2 % 86400L / 3600L;
        long l5 = l2 % 3600L / 60L;
        DecimalFormat decimalFormat = new DecimalFormat();
        ((NumberFormat)decimalFormat).setMinimumIntegerDigits(2);
        return NORMALISED_TIME_FORMAT.format(new Object[]{decimalFormat.format(l4), decimalFormat.format(l5), String.valueOf(l3)});
    }

    public static double parse(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length != 3) {
            return 0.0;
        }
        String[] stringArray2 = stringArray[0].split(":");
        long l = new Long(stringArray[2]) - 1L;
        double d = new Double(stringArray2[0]) / 24.0;
        double d2 = new Double(stringArray2[1]) / 1440.0;
        double d3 = (double)l + d + d2;
        return d3;
    }
}

