/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.ExtendedCharsets;

public abstract class DBCS_IBM_EBCDIC_EncoderX
extends CharsetEncoder {
    protected static final char REPLACE_CHAR = '\ufffd';
    private byte b1;
    private byte b2;
    protected short[] index1;
    protected String index2;
    protected String index2a;
    protected int mask1;
    protected int mask2;
    private final int[] mask1All = new int[]{65535, 65534, 65532, 65528, 65520, 65504, 65472, 65408, 65280};
    private final int[] mask2All = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    protected int shift;
    private boolean islegal = true;
    private static final int SBCS = 0;
    private static final int DBCS = 1;
    private static final byte SO = 14;
    private static final byte SI = 15;
    private int currentState;
    private int convertType = 0;
    private static String swapValue;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    protected String byteArray = "";
    protected String leftPair = "";
    protected String rightPair = "";
    protected String bytePair = "";
    protected int[] leftPairCodepoint = new int[0];
    protected String rightPairCodepoint = "";
    protected String bytePairCodepoint = "";
    protected int[] surrogateArray = new int[0];
    protected int numberOfSurrogates = 0;
    private int savedFirstOfPairBytes;
    private int savedFirstOfPair;
    protected boolean subMode = false;
    protected char[] index;
    private int charOff;
    private int byteOff;
    protected int badInputLength;
    public static final float MIX_AVERAGE_BYTES_PER_CHAR = 4.0f;
    public static final float MIX_MAX_BYTES_PER_CHAR = 5.0f;
    public static final float SBCS_AVERAGE_BYTES_PER_CHAR = 1.0f;
    public static final float SBCS_MAX_BYTES_PER_CHAR = 1.0f;
    public static final float DBCS_AVERAGE_BYTES_PER_CHAR = 2.0f;
    public static final float DBCS_MAX_BYTES_PER_CHAR = 2.0f;
    static final float[] AVERAGE_BYTES_PER_CHARS;
    static final float[] MAX_BYTES_PER_CHARS;
    protected static final int LINE_FEED_INDEX = 10;
    protected static final char SWAPPED_LINE_FEED_CHAR = '%';

    protected DBCS_IBM_EBCDIC_EncoderX(Charset charset, float f, float f2) {
        super(charset, f, f2, new byte[]{111});
    }

    protected DBCS_IBM_EBCDIC_EncoderX(Charset charset, byte[] byArray, float f, float f2) {
        super(charset, f, f2, new byte[]{111});
        if (null != byArray) {
            this.replaceWith(byArray);
        }
    }

    protected DBCS_IBM_EBCDIC_EncoderX(Charset charset, int n) {
        this(charset, AVERAGE_BYTES_PER_CHARS[n > 2 ? 0 : n], MAX_BYTES_PER_CHARS[n > 2 ? 0 : n]);
        this.setType(n);
    }

    protected DBCS_IBM_EBCDIC_EncoderX(Charset charset, byte[] byArray, int n) {
        this(charset, byArray, AVERAGE_BYTES_PER_CHARS[n > 2 ? 0 : n], MAX_BYTES_PER_CHARS[n > 2 ? 0 : n]);
        this.setType(n);
    }

    protected DBCS_IBM_EBCDIC_EncoderX(Charset charset) {
        super(charset, 4.0f, 5.0f, new byte[]{111});
        this.index = null;
    }

    protected DBCS_IBM_EBCDIC_EncoderX(Charset charset, byte[] byArray) {
        super(charset, 4.0f, 5.0f, new byte[]{111});
        this.index = null;
        if (null != byArray) {
            this.replaceWith(byArray);
        }
    }

    @Override
    public boolean isLegalReplacement(byte[] byArray) {
        if (2 == this.convertType) {
            if (2 != byArray.length) {
                return false;
            }
            if (-2 == byArray[0] && -2 == byArray[1]) {
                return true;
            }
            return super.isLegalReplacement(byArray);
        }
        if (this.islegal) {
            return true;
        }
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    protected String setIndex2(String string, int n) {
        if (DBCS_IBM_EBCDIC_EncoderX.isSwapLF()) {
            char[] cArray = string.toCharArray();
            cArray[n] = 37;
            return new String(cArray);
        }
        return string;
    }

    @Override
    protected void implReset() {
        this.byteOff = 0;
        this.charOff = 0;
        this.savedFirstOfPair = 0;
        this.savedFirstOfPairBytes = 0;
        if (this.convertType == 0) {
            this.currentState = 0;
        }
    }

    @Override
    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        if (0 != this.savedFirstOfPair) {
            int n = this.savedFirstOfPairBytes;
            if (this.currentState == 0) {
                if (byteBuffer.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)14);
                this.currentState = 1;
            }
            if (byteBuffer.remaining() < 2) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)((n & 0xFF00) >> 8));
            byteBuffer.put((byte)(n & 0xFF));
            this.savedFirstOfPair = 0;
            this.savedFirstOfPairBytes = 0;
        }
        if (this.currentState == 1 && this.convertType != 2) {
            if (byteBuffer.remaining() < 1) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)15);
        }
        this.implReset();
        return CoderResult.UNDERFLOW;
    }

    @Override
    public boolean canEncode(char c) {
        if (1 == this.convertType) {
            return this.canEncodeType1(c);
        }
        if (2 == this.convertType) {
            return this.canEncodeType2(c);
        }
        int n = (char)this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
        char c2 = n < 15000 ? this.index2.charAt(n) : this.index2a.charAt(n - 15000);
        if (c2 != '\u0000') {
            return true;
        }
        return c == '\u0000';
    }

    private boolean canEncodeType1(char c) {
        int n = (char)this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
        char c2 = n < 15000 ? this.index2.charAt(n) : this.index2a.charAt(n - 15000);
        if (c2 != '\u0000' && c2 <= '\u00ff') {
            return true;
        }
        return c == '\u0000';
    }

    private boolean canEncodeType2(char c) {
        int n = (char)this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
        char c2 = n < 15000 ? this.index2.charAt(n) : this.index2a.charAt(n - 15000);
        return c2 < '\u0000' || c2 > '\u00ff';
    }

    protected void setType(int n) {
        this.convertType = n;
        this.currentState = n == 2 ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        try {
            int n5;
            int n6;
            int n7;
            block117: {
                int n8;
                int n9;
                char c;
                boolean bl;
                if (this.convertType != 0) {
                    if (this.convertType == 1) {
                        CoderResult coderResult = this.convertType1(cArray, n, n2, byArray, n3, n4);
                        return coderResult;
                    }
                    CoderResult coderResult = this.convertType2(cArray, n, n2, byArray, n3, n4);
                    return coderResult;
                }
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                n7 = n;
                n6 = n3;
                int n13 = n2;
                int n14 = n4;
                int n15 = this.replacement().length;
                byte by = this.replacement()[0];
                byte by2 = 0;
                if (n15 > 1) {
                    by2 = this.replacement()[1];
                }
                if (!(bl = this.subMode)) {
                    bl = this.unmappableCharacterAction() == CodingErrorAction.REPLACE;
                }
                boolean bl2 = this.malformedInputAction() == CodingErrorAction.REPLACE;
                char[] cArray2 = this.index;
                n5 = this.currentState;
                int n16 = 0;
                int n17 = 1;
                int n18 = 14;
                int n19 = 15;
                if (0 != this.savedFirstOfPair && n7 < n13) {
                    c = cArray[n7];
                    n9 = this.getBytesForPairedCharacters(this.savedFirstOfPair, c);
                    n8 = 0 != n9 ? n9 : this.savedFirstOfPairBytes;
                    if (n5 == n16) {
                        if (n6 >= n14) {
                            CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                            return coderResult;
                        }
                        byArray[n6++] = n18;
                        n5 = n17;
                    }
                    if (n6 + 1 >= n14) {
                        CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                        return coderResult;
                    }
                    byArray[n6++] = (byte)((n8 & 0xFF00) >> 8);
                    byArray[n6++] = (byte)(n8 & 0xFF);
                    if (0 != n9) {
                        ++n7;
                    }
                    this.savedFirstOfPair = 0;
                    this.savedFirstOfPairBytes = 0;
                }
                if (n5 == n16) {
                    n11 = n14 - n6;
                    n10 = n13 - n7;
                    int n20 = n12 = n11 < n10 ? n7 + n11 : n13;
                    while (n7 < n12 && (n8 = cArray2[c = cArray[n7]]) < 256) {
                        byArray[n6++] = (byte)n8;
                        ++n7;
                    }
                }
                if (n7 >= n13) break block117;
                n11 = (n14 - n6) / 3;
                n10 = n13 - n7;
                int n21 = n12 = n11 < n10 ? n7 + n11 : n13;
                while (n7 < n12) {
                    c = cArray[n7];
                    n8 = cArray2[c];
                    if (n8 < 256) {
                        if (n5 != n16) {
                            byArray[n6++] = n19;
                            n5 = n16;
                        }
                        byArray[n6++] = (byte)n8;
                    } else {
                        if (n8 < 65534 && this.isFirstOfAPair(c)) break;
                        if (n8 < 65534) {
                            if (n5 == n16) {
                                byArray[n6++] = n18;
                                n5 = n17;
                            }
                            byArray[n6++] = (byte)(n8 >> 8);
                            byArray[n6++] = (byte)(n8 & 0xFF);
                        } else {
                            if (n8 != 65535) break;
                            if (!bl) {
                                CoderResult coderResult = this.throwUnknownCharacterException(n7, n6, n5, 1);
                                return coderResult;
                            }
                            if (n15 == 1) {
                                if (n5 != n16) {
                                    byArray[n6++] = n19;
                                    n5 = n16;
                                }
                                byArray[n6++] = by;
                            } else {
                                if (n5 == n16) {
                                    byArray[n6++] = n18;
                                    n5 = n17;
                                }
                                byArray[n6++] = by;
                                byArray[n6++] = by2;
                            }
                        }
                    }
                    ++n7;
                }
                while (n7 < n13) {
                    block116: {
                        block122: {
                            int n22;
                            block121: {
                                block120: {
                                    block119: {
                                        block118: {
                                            c = cArray[n7];
                                            n8 = cArray2[c];
                                            if (n8 >= 256) break block118;
                                            if (n5 != n16) {
                                                if (n6 >= n14) {
                                                    CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                                    return coderResult;
                                                }
                                                byArray[n6++] = n19;
                                                n5 = n16;
                                            }
                                            if (n6 >= n14) {
                                                CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                                return coderResult;
                                            }
                                            byArray[n6++] = (byte)n8;
                                            break block116;
                                        }
                                        if (!this.isFirstOfAPair(c) || n7 + 1 < n13) break block119;
                                        this.savedFirstOfPair = c;
                                        this.savedFirstOfPairBytes = n8;
                                        break block116;
                                    }
                                    if (n8 >= 65534) break block120;
                                    if (this.isFirstOfAPair(c)) {
                                        if (n6 + 1 >= n14) {
                                            this.savedFirstOfPair = c;
                                            this.savedFirstOfPairBytes = n8;
                                        }
                                        if (0 != (n22 = this.getBytesForPairedCharacters(c, (char)(n9 = cArray[n7 + 1])))) {
                                            n8 = n22;
                                            ++n7;
                                        }
                                    }
                                    if (n5 == n16) {
                                        if (n6 >= n14) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                            return coderResult;
                                        }
                                        byArray[n6++] = n18;
                                        n5 = n17;
                                    }
                                    if (n6 + 1 >= n14) {
                                        CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                        return coderResult;
                                    }
                                    byArray[n6++] = (byte)(n8 >> 8);
                                    byArray[n6++] = (byte)(n8 & 0xFF);
                                    break block116;
                                }
                                if (n8 != 65535) break block121;
                                if (!bl) {
                                    CoderResult coderResult = this.throwUnknownCharacterException(n7, n6, n5, 1);
                                    return coderResult;
                                }
                                if (n15 == 1) {
                                    if (n5 != n16) {
                                        if (n6 >= n14) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                            return coderResult;
                                        }
                                        byArray[n6++] = n19;
                                        n5 = n16;
                                    }
                                    if (n6 >= n14) {
                                        CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                        return coderResult;
                                    }
                                    byArray[n6++] = by;
                                    break block116;
                                } else {
                                    if (n5 == n16) {
                                        if (n6 >= n14) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                            return coderResult;
                                        }
                                        byArray[n6++] = n18;
                                        n5 = n17;
                                    }
                                    if (n6 + 1 >= n14) {
                                        CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                        return coderResult;
                                    }
                                    byArray[n6++] = by;
                                    byArray[n6++] = by2;
                                }
                                break block116;
                            }
                            if (c >= '\udc00') break block122;
                            n9 = c;
                            if (n7 + 1 >= n13) {
                                this.charOff = n7;
                                this.byteOff = n6;
                                this.currentState = n5;
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            c = cArray[n7 + 1];
                            if (c >= '\udc00' && c <= '\udfff') {
                                n22 = this.getBytesForSurrogatePair(n9, c);
                                if (0 != n22) {
                                    int n23;
                                    if (n5 == n16) {
                                        if (n6 >= n14) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                            return coderResult;
                                        }
                                        byArray[n6++] = n18;
                                        n5 = n17;
                                    }
                                    if (this.isFirstOfAPair(n23 = Character.toCodePoint((char)n9, c))) {
                                        if (n7 + 2 >= n13) {
                                            this.savedFirstOfPair = n23;
                                            this.savedFirstOfPairBytes = n22;
                                            this.charOff = n7 += 2;
                                            this.byteOff = n6;
                                            this.currentState = n5;
                                            CoderResult coderResult = CoderResult.UNDERFLOW;
                                            return coderResult;
                                        }
                                        char c2 = cArray[n7 + 2];
                                        int n24 = this.getBytesForPairedCharacters(n23, c2);
                                        if (0 != n24) {
                                            n22 = n24;
                                            ++n7;
                                        }
                                    }
                                    if (n6 + 1 >= n14) {
                                        CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                        return coderResult;
                                    }
                                    byArray[n6++] = (byte)((n22 & 0xFF00) >> 8);
                                    byArray[n6++] = (byte)(n22 & 0xFF);
                                    ++n7;
                                    break block116;
                                } else {
                                    if (!bl) {
                                        CoderResult coderResult = this.throwUnknownCharacterException(n7, n6, n5, 2);
                                        return coderResult;
                                    }
                                    if (n15 == 1) {
                                        if (n5 != n16) {
                                            if (n6 >= n14) {
                                                CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                                return coderResult;
                                            }
                                            byArray[n6++] = n19;
                                            n5 = n16;
                                        }
                                        if (n6 >= n14) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                            return coderResult;
                                        }
                                        byArray[n6++] = by;
                                    } else {
                                        if (n5 == n16) {
                                            if (n6 >= n14) {
                                                CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                                return coderResult;
                                            }
                                            byArray[n6++] = n18;
                                            n5 = n17;
                                        }
                                        if (n6 + 1 >= n14) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                            return coderResult;
                                        }
                                        byArray[n6++] = by;
                                        byArray[n6++] = by2;
                                    }
                                    ++n7;
                                }
                                break block116;
                            } else {
                                if (!bl2) {
                                    CoderResult coderResult = this.throwMalformedInputException(n7, n6, n5, 1);
                                    return coderResult;
                                }
                                if (n15 == 1) {
                                    if (n5 != n16) {
                                        if (n6 >= n14) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                            return coderResult;
                                        }
                                        byArray[n6++] = n19;
                                        n5 = n16;
                                    }
                                    if (n6 >= n14) {
                                        CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                        return coderResult;
                                    }
                                    byArray[n6++] = by;
                                    break block116;
                                } else {
                                    if (n5 == n16) {
                                        if (n6 >= n14) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                            return coderResult;
                                        }
                                        byArray[n6++] = n18;
                                        n5 = n17;
                                    }
                                    if (n6 + 1 >= n14) {
                                        CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                        return coderResult;
                                    }
                                    byArray[n6++] = by;
                                    byArray[n6++] = by2;
                                }
                            }
                            break block116;
                        }
                        if (!bl2) {
                            CoderResult coderResult = this.throwMalformedInputException(n7, n6, n5, 1);
                            return coderResult;
                        }
                        if (n15 == 1) {
                            if (n5 != n16) {
                                if (n6 >= n14) {
                                    CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                    return coderResult;
                                }
                                byArray[n6++] = n19;
                                n5 = n16;
                            }
                            if (n6 >= n14) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                return coderResult;
                            }
                            byArray[n6++] = by;
                        } else {
                            if (n5 == n16) {
                                if (n6 >= n14) {
                                    CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                    return coderResult;
                                }
                                byArray[n6++] = n18;
                                n5 = n17;
                            }
                            if (n6 + 1 >= n14) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n7, n6, n5);
                                return coderResult;
                            }
                            byArray[n6++] = by;
                            byArray[n6++] = by2;
                        }
                    }
                    ++n7;
                }
            }
            this.charOff = n7;
            this.byteOff = n6;
            this.currentState = n5;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(this.charOff - charBuffer.arrayOffset());
            byteBuffer.position(this.byteOff - byteBuffer.arrayOffset());
        }
    }

    protected static char[] expandMap(short[] sArray, String string, String string2, int n, int n2, int n3) {
        char c = '\u0000';
        char[] cArray = new char[65536];
        for (int i = 0; i < cArray.length; ++i) {
            if (i >= 55296 && i <= 57343) {
                cArray[i] = 65534;
                continue;
            }
            int n4 = (char)sArray[(i & n2) >> n] + (i & n3);
            c = n4 < 15000 ? string.charAt(n4) : string2.charAt(n4 - 15000);
            cArray[i] = c == '\u0000' && i != 0 ? 65535 : c;
        }
        return cArray;
    }

    private int getBytesForPairedCharacters(char c, char c2) {
        int n = this.leftPair.indexOf(c);
        while (n > -1) {
            if (this.rightPair.charAt(n) == c2) {
                return this.bytePair.charAt(n);
            }
            n = this.leftPair.indexOf(c, n + 1);
        }
        return 0;
    }

    private int searchInx(int[] nArray, int n, int n2) {
        for (int i = n2; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    private int getBytesForPairedCharacters(int n, char c) {
        if (n < 65536) {
            return this.getBytesForPairedCharacters((char)n, c);
        }
        int n2 = this.searchInx(this.leftPairCodepoint, n, 0);
        while (n2 > -1) {
            if (this.rightPairCodepoint.charAt(n2) == c) {
                return this.bytePairCodepoint.charAt(n2);
            }
            n2 = this.searchInx(this.leftPairCodepoint, n, n2 + 1);
        }
        return 0;
    }

    private CoderResult throwConversionBufferFullException(int n, int n2, int n3) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        return CoderResult.OVERFLOW;
    }

    private CoderResult throwUnknownCharacterException(int n, int n2, int n3, int n4) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        this.badInputLength = n4;
        return CoderResult.unmappableForLength(n4);
    }

    private CoderResult throwMalformedInputException(int n, int n2, int n3, int n4) {
        new Exception().printStackTrace();
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        this.badInputLength = n4;
        return CoderResult.malformedForLength(n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoderResult convertType1(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) {
        char c;
        char c2;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n3;
        int n10 = n2;
        int n11 = n4;
        byte by = this.replacement()[0];
        boolean bl = this.subMode;
        char[] cArray2 = this.index;
        int n12 = this.currentState;
        n7 = n11 - n9;
        n6 = n10 - n5;
        int n13 = n8 = n7 < n6 ? n5 + n7 : n10;
        for (n5 = n; n5 < n8 && (c2 = cArray2[c = cArray[n5]]) < '\u0100'; ++n5) {
            byArray[n9++] = (byte)c2;
        }
        if (n5 < n10) {
            n7 = n11 - n9;
            n6 = n10 - n5;
            int n14 = n8 = n7 < n6 ? n5 + n7 : n10;
            while (n5 < n8) {
                c = cArray[n5];
                c2 = cArray2[c];
                if (c2 < '\u0100') {
                    byArray[n9++] = (byte)c2;
                } else {
                    if (c2 == '\ufffe') break;
                    if (!bl) return this.throwUnknownCharacterException(n5, n9, 0, 1);
                    byArray[n9++] = by;
                }
                ++n5;
            }
            while (n5 < n10) {
                c = cArray[n5];
                c2 = cArray2[c];
                if (c2 < '\u0100') {
                    if (n9 >= n11) {
                        return this.throwConversionBufferFullException(n5, n9, 0);
                    }
                    byArray[n9++] = (byte)c2;
                } else if (c2 != '\ufffe') {
                    if (!bl) return this.throwUnknownCharacterException(n5, n9, 0, 1);
                    if (n9 >= n11) {
                        return this.throwConversionBufferFullException(n5, n9, 0);
                    }
                    byArray[n9++] = by;
                } else {
                    if (c >= '\udc00') return this.throwMalformedInputException(n5, n9, 0, 1);
                    if (n5 + 1 >= n10) {
                        this.charOff = n5;
                        this.byteOff = n9;
                        return CoderResult.UNDERFLOW;
                    }
                    c = cArray[n5 + 1];
                    if (c < '\udc00' || c > '\udfff') return this.throwMalformedInputException(n5, n9, 0, 1);
                    if (!bl) return this.throwUnknownCharacterException(n5, n9, 0, 2);
                    if (n9 >= n11) {
                        return this.throwConversionBufferFullException(n5, n9, 0);
                    }
                    byArray[n9++] = by;
                    ++n5;
                }
                ++n5;
            }
        }
        this.charOff = n5;
        this.byteOff = n9;
        return CoderResult.UNDERFLOW;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoderResult convertType2(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) {
        int n5;
        int n6;
        char c;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = n;
        int n11 = n3;
        int n12 = n2;
        int n13 = n4;
        int n14 = this.replacement().length;
        byte by = this.replacement()[0];
        byte by2 = this.replacement()[1];
        boolean bl = this.subMode;
        if (!bl) {
            bl = this.unmappableCharacterAction() == CodingErrorAction.REPLACE;
        }
        boolean bl2 = this.malformedInputAction() == CodingErrorAction.REPLACE;
        char[] cArray2 = this.index;
        this.currentState = 1;
        if (0 != this.savedFirstOfPair && n10 < n12) {
            c = cArray[n10];
            n6 = this.getBytesForPairedCharacters(this.savedFirstOfPair, c);
            n5 = 0 != n6 ? n6 : this.savedFirstOfPairBytes;
            if (n11 + 1 >= n13) {
                return this.throwConversionBufferFullException(n10, n11, 1);
            }
            byArray[n11++] = (byte)((n5 & 0xFF00) >> 8);
            byArray[n11++] = (byte)(n5 & 0xFF);
            if (0 != n6) {
                ++n10;
            }
            this.savedFirstOfPair = 0;
            this.savedFirstOfPairBytes = 0;
        }
        if (n10 < n12) {
            n8 = (n13 - n11) / 2;
            n7 = n12 - n10;
            int n15 = n9 = n8 < n7 ? n10 + n8 : n12;
            while (!(n10 >= n9 || (n5 = cArray2[c = cArray[n10]]) < 65534 && this.isFirstOfAPair(c))) {
                if (n5 < 65534 && n5 >= 256) {
                    byArray[n11++] = (byte)(n5 >> 8);
                    byArray[n11++] = (byte)(n5 & 0xFF);
                } else if (n5 < 65534 && -1 != this.encodeCT2(c)) {
                    n5 = this.encodeCT2(c);
                    byArray[n11++] = (byte)(n5 >> 8);
                    byArray[n11++] = (byte)(n5 & 0xFF);
                } else {
                    if (n5 != 65535) break;
                    if (!bl) return this.throwUnknownCharacterException(n10, n11, 1, 1);
                    byArray[n11++] = by;
                    byArray[n11++] = by2;
                }
                ++n10;
            }
            while (n10 < n12) {
                int n16;
                c = cArray[n10];
                n5 = cArray2[c];
                if (n5 < 256) {
                    n5 = this.encodeCT2(c);
                }
                if (n5 < 256) {
                    n5 = 65535;
                }
                if (this.isFirstOfAPair(c) && n10 + 1 >= n12) {
                    this.savedFirstOfPair = c;
                    this.savedFirstOfPairBytes = n5;
                } else if (n5 < 65534) {
                    if (this.isFirstOfAPair(c) && n10 + 1 < n12) {
                        if (n11 + 1 >= n13) {
                            this.savedFirstOfPair = c;
                            this.savedFirstOfPairBytes = n5;
                        }
                        if (0 != (n16 = this.getBytesForPairedCharacters(c, (char)(n6 = cArray[n10 + 1])))) {
                            n5 = n16;
                            ++n10;
                        }
                    }
                    if (n11 + 1 >= n13) {
                        return this.throwConversionBufferFullException(n10, n11, 1);
                    }
                    byArray[n11++] = (byte)(n5 >> 8);
                    byArray[n11++] = (byte)(n5 & 0xFF);
                } else if (n5 == 65535) {
                    if (!bl) return this.throwUnknownCharacterException(n10, n11, 1, 1);
                    if (n11 + 1 >= n13) {
                        return this.throwConversionBufferFullException(n10, n11, 1);
                    }
                    byArray[n11++] = by;
                    byArray[n11++] = by2;
                } else if (c < '\udc00') {
                    n6 = c;
                    if (n10 + 1 >= n12) {
                        this.charOff = n10;
                        this.byteOff = n11;
                        return CoderResult.UNDERFLOW;
                    }
                    c = cArray[n10 + 1];
                    if (c >= '\udc00' && c <= '\udfff') {
                        n16 = this.getBytesForSurrogatePair(n6, c);
                        if (0 != n16) {
                            int n17 = Character.toCodePoint((char)n6, c);
                            if (this.isFirstOfAPair(n17)) {
                                if (n10 + 2 < n12) {
                                    char c2 = cArray[n10 + 2];
                                    int n18 = this.getBytesForPairedCharacters(n17, c2);
                                    if (0 != n18) {
                                        n16 = n18;
                                        ++n10;
                                    }
                                } else {
                                    this.savedFirstOfPair = n17;
                                    this.savedFirstOfPairBytes = n16;
                                    this.charOff = n10 += 2;
                                    this.byteOff = n11;
                                    return CoderResult.UNDERFLOW;
                                }
                            }
                            if (n11 + 1 >= n13) {
                                return this.throwConversionBufferFullException(n10, n11, 1);
                            }
                            byArray[n11++] = (byte)((n16 & 0xFF00) >> 8);
                            byArray[n11++] = (byte)(n16 & 0xFF);
                            ++n10;
                        } else {
                            if (!bl) return this.throwUnknownCharacterException(n10, n11, 1, 2);
                            if (n11 + 1 >= n13) {
                                return this.throwConversionBufferFullException(n10, n11, 1);
                            }
                            byArray[n11++] = by;
                            byArray[n11++] = by2;
                            ++n10;
                        }
                    } else {
                        if (!bl2) return this.throwMalformedInputException(n10, n11, 1, 1);
                        if (n11 + 1 >= n13) {
                            return this.throwConversionBufferFullException(n10, n11, 1);
                        }
                        byArray[n11++] = by;
                        byArray[n11++] = by2;
                    }
                } else {
                    if (!bl2) return this.throwMalformedInputException(n10, n11, 1, 1);
                    if (n11 + 1 >= n13) {
                        return this.throwConversionBufferFullException(n10, n11, 1);
                    }
                    byArray[n11++] = by;
                    byArray[n11++] = by2;
                }
                ++n10;
            }
        }
        this.charOff = n10;
        this.byteOff = n11;
        return CoderResult.UNDERFLOW;
    }

    private int getBytesForSurrogatePair(int n, int n2) {
        if (0 == this.numberOfSurrogates) {
            return 0;
        }
        int n3 = this.numberOfSurrogates;
        int n4 = -1;
        int n5 = ((n & 0x3FF) << 10 | n2 & 0x3FF) + 65536;
        int n6 = n3 / 2;
        int n7 = 0;
        if (this.surrogateArray[0] == n5) {
            n4 = 0;
            n6 = 0;
        } else if (this.surrogateArray[n3 - 1] == n5) {
            n4 = n3 - 1;
            n6 = 0;
        }
        while (n6 >= 1) {
            if (this.surrogateArray[n6] == n5) {
                n4 = n6;
                break;
            }
            if (this.surrogateArray[n6] < n5) {
                if ((n3 + n6) / 2 == n6) {
                    n6 = 0;
                    continue;
                }
                n6 = (n3 + n6) / 2;
                continue;
            }
            if (this.surrogateArray[n6] <= n5) continue;
            n3 = n6;
            n6 = n3 / 2;
        }
        if (n4 >= 0) {
            n7 = this.byteArray.charAt(n4);
        }
        return n7;
    }

    protected boolean isFirstOfAPair(char c) {
        return false;
    }

    protected boolean isFirstOfAPair(int n) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer var1_1, ByteBuffer var2_2) {
        block66: {
            block68: {
                block67: {
                    if (this.convertType == 1) {
                        return this.encodeBufferLoop_CT1(var1_1, var2_2);
                    }
                    if (this.convertType == 2) {
                        return this.encodeBufferLoop_CT2(var1_1, var2_2);
                    }
                    var3_3 = var1_1.position();
                    var4_4 = false;
                    var6_5 = this.subMode;
                    if (!var6_5) {
                        var6_5 = this.unmappableCharacterAction() == CodingErrorAction.REPLACE;
                    }
                    var7_6 = this.malformedInputAction() == CodingErrorAction.REPLACE;
                    var8_7 = this.replacement();
                    if (!var1_1.hasRemaining()) {
                        var9_8 = CoderResult.UNDERFLOW;
                        return var9_8;
                    }
                    if (0 != this.savedFirstOfPair) {
                        var9_9 = 0;
                        var10_11 = var1_1.get();
                        var11_12 = this.getBytesForPairedCharacters(this.savedFirstOfPair, var10_11);
                        var9_9 = 0 != var11_12 ? var11_12 : this.savedFirstOfPairBytes;
                        var12_13 = (byte)((var9_9 & 65280) >> 8);
                        var13_14 = var9_9 & 255;
                        if (this.currentState == 1 && var12_13 == 0) {
                            if (var2_2.remaining() < 1) {
                                var14_24 = CoderResult.OVERFLOW;
                                return var14_24;
                            }
                            this.currentState = 0;
                            var2_2.put((byte)15);
                        } else if (this.currentState == 0 && var12_13 != 0) {
                            if (var2_2.remaining() < 1) {
                                var14_25 = CoderResult.OVERFLOW;
                                return var14_25;
                            }
                            this.currentState = 1;
                            var2_2.put((byte)14);
                        }
                        var5_29 = this.currentState == 1 ? 2 : 1;
                        if (var2_2.remaining() < var5_29) {
                            var14_26 = CoderResult.OVERFLOW;
                            return var14_26;
                        }
                        if (this.currentState == 0) {
                            var2_2.put((byte)var13_14);
                        } else {
                            if (this.currentState == 1) {
                                var2_2.put(var12_13);
                            }
                            var2_2.put((byte)var13_14);
                        }
                        if (0 != var11_12) {
                            ++var3_3;
                        }
                        this.savedFirstOfPair = 0;
                        this.savedFirstOfPairBytes = 0;
                        var1_1.position(var3_3);
                    }
lbl57:
                    // 4 sources

                    while (true) {
                        if (var1_1.hasRemaining()) {
                            var10_11 = '\u0000';
                            var11_12 = var1_1.get();
                            var12_13 = 0;
                            if (Surrogate.is(var11_12)) {
                                if (this.sgp.parse((char)var11_12, var1_1) < 0) {
                                    var13_15 = this.sgp.error();
                                    return var13_15;
                                }
                                if (0 == this.numberOfSurrogates) {
                                    var13_16 = this.sgp.unmappableResult();
                                    return var13_16;
                                }
                                var13_14 = this.sgp.character();
                                var14_27 = Arrays.binarySearch(this.surrogateArray, var13_14);
                                if (var14_27 < 0) {
                                    var15_32 = this.sgp.unmappableResult();
                                    return var15_32;
                                }
                                var10_11 = this.byteArray.charAt(var14_27);
                                var12_13 = (byte)(var12_13 + 1);
                                if (Arrays.binarySearch(this.leftPairCodepoint, var13_14) <= -1) break block66;
                                if (!var1_1.hasRemaining()) {
                                    this.savedFirstOfPair = var13_14;
                                    this.savedFirstOfPairBytes = var10_11;
                                    var3_3 += 2;
                                    var15_31 = CoderResult.UNDERFLOW;
                                    return var15_31;
                                }
                                var15_30 = this.searchInx(this.leftPairCodepoint, var13_14, 0);
                                var16_33 = var1_1.get(var3_3 + 2);
                                break block67;
                            }
                            if (var11_12 >= 65534) {
                                if (!var6_5) {
                                    var13_19 = CoderResult.unmappableForLength(1);
                                    return var13_19;
                                }
                                if (1 == var8_7.length) {
                                    v0 = var5_29 = 1 == this.currentState ? 2 : 1;
                                    if (var2_2.remaining() < var5_29) {
                                        var13_17 = CoderResult.OVERFLOW;
                                        return var13_17;
                                    }
                                    if (2 == var5_29) {
                                        var2_2.put((byte)15);
                                    }
                                    var2_2.put(var8_7[0]);
                                    this.currentState = 0;
                                } else {
                                    v1 = var5_29 = 0 == this.currentState ? 3 : 2;
                                    if (var2_2.remaining() < var5_29) {
                                        var13_18 = CoderResult.OVERFLOW;
                                        return var13_18;
                                    }
                                    if (3 == var5_29) {
                                        var2_2.put((byte)14);
                                    }
                                    var2_2.put(var8_7[0]);
                                    var2_2.put(var8_7[1]);
                                    this.currentState = 1;
                                }
                                ++var3_3;
                                continue;
                            }
                            var9_9 = (char)this.index1[(var11_12 & this.mask1) >> this.shift] + (var11_12 & this.mask2);
                            var10_11 = var9_9 < 15000 ? this.index2.charAt(var9_9) : this.index2a.charAt(var9_9 - 15000);
                            var13_14 = this.leftPair.indexOf(var11_12);
                            if (var13_14 <= -1 || var10_11 == '\u0000') break block66;
                            if (!var1_1.hasRemaining()) {
                                this.savedFirstOfPair = var11_12;
                                this.savedFirstOfPairBytes = var10_11;
                                ++var3_3;
                                var14_28 = CoderResult.UNDERFLOW;
                                return var14_28;
                            }
                            var14_27 = var1_1.get(var3_3 + 1);
                            break block68;
                        }
                        var9_10 = CoderResult.UNDERFLOW;
                        return var9_10;
                    }
                    finally {
                        var1_1.position(var3_3);
                    }
                }
                while (var15_30 > -1) {
                    if (this.rightPairCodepoint.charAt(var15_30) == var16_33) {
                        var10_11 = this.bytePairCodepoint.charAt(var15_30);
                        var12_13 = (byte)(var12_13 + 1);
                        var1_1.get();
                        var15_30 = -1;
                        continue;
                    }
                    var15_30 = this.searchInx(this.leftPairCodepoint, var13_14, var15_30 + 1);
                }
                break block66;
            }
            while (var13_14 > -1) {
                if (this.rightPair.charAt(var13_14) == var14_27) {
                    var10_11 = this.bytePair.charAt(var13_14);
                    var12_13 = (byte)(var12_13 + 1);
                    var1_1.get();
                    var13_14 = -1;
                    continue;
                }
                var13_14 = this.leftPair.indexOf(var11_12, var13_14 + 1);
            }
        }
        this.b1 = (byte)((var10_11 & 65280) >> 8);
        this.b2 = (byte)(var10_11 & 255);
        if (this.b1 == 0 && this.b2 == 0 && var11_12 != 0) {
            if (!var6_5) {
                var13_20 = CoderResult.unmappableForLength(1);
                return var13_20;
            }
            if (1 == var8_7.length) {
                this.b1 = 0;
                this.b2 = var8_7[0];
            } else {
                this.b1 = 0;
                this.b2 = var8_7[0];
            }
        }
        if (this.currentState == 1 && this.b1 == 0) {
            if (var2_2.remaining() < 1) {
                var13_21 = CoderResult.OVERFLOW;
                return var13_21;
            }
            this.currentState = 0;
            var2_2.put((byte)15);
        } else if (this.currentState == 0 && this.b1 != 0) {
            if (var2_2.remaining() < 1) {
                var13_22 = CoderResult.OVERFLOW;
                return var13_22;
            }
            this.currentState = 1;
            var2_2.put((byte)14);
        }
        var5_29 = this.currentState == 1 ? 2 : 1;
        if (var2_2.remaining() < var5_29) {
            var13_23 = CoderResult.OVERFLOW;
            return var13_23;
        }
        if (this.currentState == 0) {
            var2_2.put(this.b2);
        } else {
            var2_2.put(this.b1);
            var2_2.put(this.b2);
        }
        var3_3 += var12_13;
        var12_13 = 0;
        ++var3_3;
        ** continue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop_CT1(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                int n3 = this.leftPair.indexOf(c);
                boolean bl3 = false;
                boolean bl4 = false;
                if (charBuffer.hasRemaining() && n3 > -1 && null != this.surrogateArray) {
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n4 = (char)this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char c2 = n4 < 15000 ? this.index2.charAt(n4) : this.index2a.charAt(n4 - 15000);
                this.b1 = (byte)((c2 & 0xFF00) >> 8);
                this.b2 = (byte)(c2 & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 0 && this.b1 != 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState != 0) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n2 = 1;
                if (byteBuffer.remaining() < n2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    if (this.b2 > 255) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                } else {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                byteBuffer.put(this.b2);
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop_CT2(CharBuffer var1_1, ByteBuffer var2_2) {
        block35: {
            block37: {
                block36: {
                    var3_3 = var1_1.position();
                    var4_4 = false;
                    if (!var1_1.hasRemaining()) {
                        var6_5 = CoderResult.UNDERFLOW;
                        return var6_5;
                    }
                    if (0 != this.savedFirstOfPair) {
                        var6_6 = 0;
                        var7_8 = var1_1.get();
                        var8_9 = this.getBytesForPairedCharacters(this.savedFirstOfPair, var7_8);
                        var6_6 = 0 != var8_9 ? var8_9 : this.savedFirstOfPairBytes;
                        var9_10 = (byte)((var6_6 & 65280) >> 8);
                        var10_11 = var6_6 & 255;
                        var5_16 = 2;
                        if (var2_2.remaining() < var5_16) {
                            var11_17 = CoderResult.OVERFLOW;
                            return var11_17;
                        }
                        var2_2.put(var9_10);
                        var2_2.put((byte)var10_11);
                        if (0 != var8_9) {
                            ++var3_3;
                        }
                        this.savedFirstOfPair = 0;
                        this.savedFirstOfPairBytes = 0;
                        var1_1.position(var3_3);
                    }
lbl28:
                    // 4 sources

                    while (true) {
                        if (var1_1.hasRemaining()) {
                            var7_8 = '\u0000';
                            var8_9 = var1_1.get();
                            var9_10 = 0;
                            if (Surrogate.is(var8_9)) {
                                if (this.sgp.parse((char)var8_9, var1_1) < 0) {
                                    var10_12 = this.sgp.error();
                                    return var10_12;
                                }
                                if (0 == this.numberOfSurrogates) {
                                    var10_13 = this.sgp.unmappableResult();
                                    return var10_13;
                                }
                                var10_11 = this.sgp.character();
                                var11_18 = Arrays.binarySearch(this.surrogateArray, var10_11);
                                if (var11_18 < 0) {
                                    var12_24 = this.sgp.unmappableResult();
                                    return var12_24;
                                }
                                var7_8 = this.byteArray.charAt(var11_18);
                                var9_10 = (byte)(var9_10 + 1);
                                if (Arrays.binarySearch(this.leftPairCodepoint, var10_11) <= -1) break block35;
                                if (!var1_1.hasRemaining()) {
                                    this.savedFirstOfPair = var10_11;
                                    this.savedFirstOfPairBytes = var7_8;
                                    var3_3 += 2;
                                    var12_23 = CoderResult.UNDERFLOW;
                                    return var12_23;
                                }
                                var12_22 = this.searchInx(this.leftPairCodepoint, var10_11, 0);
                                var13_25 = var1_1.get(var3_3 + 2);
                                break block36;
                            }
                            if (var8_9 >= 65534) {
                                var10_14 = CoderResult.unmappableForLength(1);
                                return var10_14;
                            }
                            var6_6 = (char)this.index1[(var8_9 & this.mask1) >> this.shift] + (var8_9 & this.mask2);
                            var7_8 = var6_6 < 15000 ? this.index2.charAt(var6_6) : this.index2a.charAt(var6_6 - 15000);
                            var10_11 = this.leftPair.indexOf(var8_9);
                            if (var10_11 <= -1 || var7_8 == '\u0000') break block35;
                            if (!var1_1.hasRemaining()) {
                                this.savedFirstOfPair = var8_9;
                                this.savedFirstOfPairBytes = var7_8;
                                ++var3_3;
                                var11_19 = CoderResult.UNDERFLOW;
                                return var11_19;
                            }
                            var11_18 = var1_1.get(var3_3 + 1);
                            break block37;
                        }
                        var6_7 = CoderResult.UNDERFLOW;
                        return var6_7;
                    }
                    finally {
                        var1_1.position(var3_3);
                    }
                }
                while (var12_22 > -1) {
                    if (this.rightPairCodepoint.charAt(var12_22) == var13_25) {
                        var7_8 = this.bytePairCodepoint.charAt(var12_22);
                        var9_10 = (byte)(var9_10 + 1);
                        var1_1.get();
                        var12_22 = -1;
                        continue;
                    }
                    var12_22 = this.searchInx(this.leftPairCodepoint, var10_11, var12_22 + 1);
                }
                break block35;
            }
            while (var10_11 > -1) {
                if (this.rightPair.charAt(var10_11) == var11_18) {
                    var7_8 = this.bytePair.charAt(var10_11);
                    var9_10 = (byte)(var9_10 + 1);
                    var1_1.get();
                    var10_11 = -1;
                    continue;
                }
                var10_11 = this.leftPair.indexOf(var8_9, var10_11 + 1);
            }
        }
        this.b1 = (byte)((var7_8 & 65280) >> 8);
        this.b2 = (byte)(var7_8 & 255);
        if (var7_8 == '\u0000' && var8_9 != 0) {
            var10_15 = CoderResult.unmappableForLength(1);
            return var10_15;
        }
        var10_11 = this.encodeCT2((char)var8_9);
        if (-1 != var10_11) {
            this.b1 = (byte)((var10_11 & 65280) >> 8);
            this.b2 = (byte)(var10_11 & 255);
        }
        if (this.b1 == 0) {
            var11_20 = CoderResult.unmappableForLength(1);
            return var11_20;
        }
        var5_16 = 2;
        if (var2_2.remaining() < var5_16) {
            var11_21 = CoderResult.OVERFLOW;
            return var11_21;
        }
        var2_2.put(this.b1);
        var2_2.put(this.b2);
        var3_3 += var9_10;
        var9_10 = 0;
        ++var3_3;
        ** continue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop_CT2(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        boolean bl = false;
        try {
            for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                char c;
                char c2 = cArray[n];
                int n5 = this.leftPair.indexOf(c2);
                boolean bl2 = false;
                boolean bl3 = false;
                if (n + 1 < n2 && n5 > -1 && null != this.surrogateArray) {
                    while (n5 > -1) {
                        if (this.rightPair.charAt(n5) == cArray[n + 1]) {
                            c = this.bytePair.charAt(n5);
                            ++n;
                            bl2 = true;
                            n5 = -1;
                            continue;
                        }
                        n5 = this.leftPair.indexOf(c2, n5 + 1);
                    }
                }
                if (Surrogate.is(c2)) {
                    if (this.sgp.parse(c2, cArray, n, n2) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    if (null != this.surrogateArray && !bl2) {
                        int n6 = this.numberOfSurrogates;
                        int n7 = -1;
                        boolean bl4 = false;
                        int n8 = n6 / 2;
                        if (this.surrogateArray[0] == this.sgp.character()) {
                            n7 = 0;
                            n8 = 0;
                        } else if (this.surrogateArray[n6 - 1] == this.sgp.character()) {
                            n7 = n6 - 1;
                            n8 = 0;
                        }
                        while (n8 >= 1) {
                            if (this.surrogateArray[n8] == this.sgp.character()) {
                                n7 = n8;
                                break;
                            }
                            if (this.surrogateArray[n8] < this.sgp.character()) {
                                if ((n6 + n8) / 2 == n8) {
                                    n8 = 0;
                                    continue;
                                }
                                n8 = (n6 + n8) / 2;
                                continue;
                            }
                            if (this.surrogateArray[n8] <= this.sgp.character()) continue;
                            n6 = n8;
                            n8 = n6 / 2;
                        }
                        if (n7 >= 0) {
                            c = this.byteArray.charAt(n7);
                            ++n;
                        } else {
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        bl3 = true;
                    } else {
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                }
                if (c2 >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n9 = (char)this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2);
                c = n9 < 15000 ? this.index2.charAt(n9) : this.index2a.charAt(n9 - 15000);
                this.b1 = (byte)((c & 0xFF00) >> 8);
                this.b2 = (byte)(c & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c2 != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 && this.b1 == 0) {
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                } else if (this.currentState == 0 && this.b1 != 0) {
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                }
                int n10 = this.currentState == 1 ? 2 : 1;
                if (n4 - n3 < n10) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 || bl2 || bl3) {
                    byArray[n3++] = this.b1;
                }
                byArray[n3++] = this.b2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop_CT1(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        boolean bl = false;
        int n5 = 0;
        try {
            for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                char c = cArray[n];
                int n6 = this.leftPair.indexOf(c);
                boolean bl2 = false;
                boolean bl3 = false;
                if (n + 1 < n2 && n6 > -1 && null != this.surrogateArray) {
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, cArray, n, n2) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n7 = (char)this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char c2 = n7 < 15000 ? this.index2.charAt(n7) : this.index2a.charAt(n7 - 15000);
                this.b1 = (byte)((c2 & 0xFF00) >> 8);
                this.b2 = (byte)(c2 & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 0 && this.b1 != 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState != 0) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n5 = 1;
                if (n4 - n3 < n5) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    if (this.b2 > 255) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                } else {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                byArray[n3++] = this.b2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
        }
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }

    protected int encodeCT2(char c) {
        return -1;
    }

    protected String handleIBMSwapLF(String string) {
        return string;
    }

    public static final boolean isSwapLF() {
        return ExtendedCharsets.isSwapLF();
    }

    public int encode(char[] cArray, int n, int n2, byte[] byArray) {
        switch (this.convertType) {
            case 0: {
                return null == this.leftPair ? this.encode_CT0(cArray, n, n2, byArray) : this.encode_CT0_Ex(cArray, n, n2, byArray);
            }
            case 1: {
                return this.encode_CT1(cArray, n, n2, byArray);
            }
            case 2: {
                return null == this.leftPair ? this.encode_CT2(cArray, n, n2, byArray) : this.encode_CT2_Ex(cArray, n, n2, byArray);
            }
        }
        return -1;
    }

    int encodeChar(char c) {
        return this.index[c];
    }

    int encodeSurrogatePair(char c, char c2) {
        if (null == this.surrogateArray) {
            return -1;
        }
        int n = Character.toCodePoint(c, c2);
        int n2 = Arrays.binarySearch(this.surrogateArray, n);
        return n2 > -1 ? (int)this.byteArray.charAt(n2) : -1;
    }

    public int encode_CT0(char[] cArray, int n, int n2, byte[] byArray) {
        int n3;
        int n4 = 0;
        int n5 = n + n2;
        byte[] byArray2 = this.replacement();
        int n6 = 255;
        int n7 = n3 = byArray2.length > 1 ? (byArray2[0] & 0xFF) << 8 | byArray2[1] & 0xFF : byArray2[0] & 0xFF;
        while (n < n5) {
            char c;
            int n8;
            if ((n8 = this.encodeChar(c = cArray[n++])) >= 65533) {
                if (Character.isHighSurrogate(c) && n < n5 && Character.isLowSurrogate(cArray[n])) {
                    n8 = this.encodeSurrogatePair(c, cArray[n]);
                    ++n;
                    if (n8 > -1) {
                        if (this.currentState == 0) {
                            this.currentState = 1;
                            byArray[n4++] = 14;
                        }
                        byArray[n4++] = (byte)(n8 >> 8);
                        byArray[n4++] = (byte)n8;
                        continue;
                    }
                }
                n8 = n3;
            }
            if (n8 > n6) {
                if (this.currentState == 0) {
                    this.currentState = 1;
                    byArray[n4++] = 14;
                }
                byArray[n4++] = (byte)(n8 >> 8);
                byArray[n4++] = (byte)n8;
                continue;
            }
            if (this.currentState == 1) {
                this.currentState = 0;
                byArray[n4++] = 15;
            }
            byArray[n4++] = (byte)n8;
        }
        if (this.currentState == 1) {
            this.currentState = 0;
            byArray[n4++] = 15;
        }
        return n4;
    }

    public int encode_CT0_Ex(char[] cArray, int n, int n2, byte[] byArray) {
        char c;
        int n3;
        int n4 = 0;
        int n5 = n + n2;
        byte[] byArray2 = this.replacement();
        int n6 = 255;
        int n7 = n3 = byArray2.length > 1 ? (byArray2[0] & 0xFF) << 8 | byArray2[1] & 0xFF : byArray2[0] & 0xFF;
        while (n < n5 && (c = this.index[cArray[n]]) < '\u0100') {
            byArray[n4++] = (byte)c;
            ++n;
        }
        while (n < n5) {
            int n8;
            if ((n8 = this.encodeChar(c = cArray[n++])) >= 65533) {
                if (Character.isHighSurrogate(c) && n < n5 && Character.isLowSurrogate(cArray[n])) {
                    n8 = this.encodeSurrogatePair(c, cArray[n]);
                    ++n;
                    if (n8 > -1) {
                        if (this.currentState == 0) {
                            this.currentState = 1;
                            byArray[n4++] = 14;
                        }
                        byArray[n4++] = (byte)(n8 >> 8);
                        byArray[n4++] = (byte)n8;
                        continue;
                    }
                }
                n8 = n3;
            }
            if (n8 > n6) {
                int n9;
                if (this.currentState == 0) {
                    this.currentState = 1;
                    byArray[n4++] = 14;
                }
                if (this.isFirstOfAPair(c) && n < n5 && 0 != (n9 = this.getBytesForPairedCharacters(c, cArray[n]))) {
                    ++n;
                    n8 = n9;
                }
                byArray[n4++] = (byte)(n8 >> 8);
                byArray[n4++] = (byte)n8;
                continue;
            }
            if (this.currentState == 1) {
                this.currentState = 0;
                byArray[n4++] = 15;
            }
            byArray[n4++] = (byte)n8;
        }
        if (this.currentState == 1) {
            this.currentState = 0;
            byArray[n4++] = 15;
        }
        return n4;
    }

    public int encode_CT1(char[] cArray, int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = n + n2;
        int n5 = byArray.length;
        byte[] byArray2 = this.replacement();
        int n6 = 255;
        while (n < n4) {
            char c;
            int n7;
            if ((n7 = this.encodeChar(c = cArray[n++])) >= 65533) {
                if (Character.isHighSurrogate(c) && n < n4 && Character.isLowSurrogate(cArray[n])) {
                    ++n;
                }
                byArray[n3++] = byArray2[0];
                continue;
            }
            if (n7 > n6) {
                byArray[n3++] = byArray2[0];
                continue;
            }
            byArray[n3++] = (byte)n7;
        }
        return n3;
    }

    public int encode_CT2(char[] cArray, int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = n + n2;
        int n5 = byArray.length;
        byte[] byArray2 = this.replacement();
        int n6 = 255;
        while (n < n4) {
            char c;
            int n7;
            if ((n7 = this.encodeChar(c = cArray[n++])) >= 65533) {
                if (Character.isHighSurrogate(c) && n < n4 && Character.isLowSurrogate(cArray[n])) {
                    n7 = this.encodeSurrogatePair(c, cArray[n]);
                    ++n;
                    if (n7 > -1) {
                        if (this.currentState == 0) {
                            this.currentState = 1;
                            byArray[n3++] = 14;
                        }
                        byArray[n3++] = (byte)(n7 >> 8);
                        byArray[n3++] = (byte)n7;
                        continue;
                    }
                }
                byArray[n3++] = byArray2[0];
                byArray[n3++] = byArray2[1];
                continue;
            }
            if (n7 > 255) {
                byArray[n3++] = (byte)(n7 >> 8);
                byArray[n3++] = (byte)n7;
                continue;
            }
            n7 = this.encodeCT2(c);
            if (n7 > -1) {
                byArray[n3++] = (byte)(n7 >> 8);
                byArray[n3++] = (byte)n7;
                continue;
            }
            byArray[n3++] = byArray2[0];
            byArray[n3++] = byArray2[1];
        }
        return n3;
    }

    public int encode_CT2_Ex(char[] cArray, int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = n + n2;
        int n5 = byArray.length;
        byte[] byArray2 = this.replacement();
        int n6 = 255;
        while (n < n4) {
            char c;
            int n7;
            if ((n7 = this.encodeChar(c = cArray[n++])) >= 65533) {
                if (Character.isHighSurrogate(c) && n < n4 && Character.isLowSurrogate(cArray[n])) {
                    n7 = this.encodeSurrogatePair(c, cArray[n]);
                    ++n;
                    if (n7 > -1) {
                        if (this.currentState == 0) {
                            this.currentState = 1;
                            byArray[n3++] = 14;
                        }
                        byArray[n3++] = (byte)(n7 >> 8);
                        byArray[n3++] = (byte)n7;
                        continue;
                    }
                }
                byArray[n3++] = byArray2[0];
                byArray[n3++] = byArray2[1];
                continue;
            }
            if (n7 > 255) {
                int n8;
                if (this.isFirstOfAPair(c) && n < n4 && 0 != (n8 = this.getBytesForPairedCharacters(c, cArray[n]))) {
                    ++n;
                    n7 = n8;
                }
                byArray[n3++] = (byte)(n7 >> 8);
                byArray[n3++] = (byte)n7;
                continue;
            }
            n7 = this.encodeCT2(c);
            if (n7 > -1) {
                byArray[n3++] = (byte)(n7 >> 8);
                byArray[n3++] = (byte)n7;
                continue;
            }
            byArray[n3++] = byArray2[0];
            byArray[n3++] = byArray2[1];
        }
        return n3;
    }

    static {
        AVERAGE_BYTES_PER_CHARS = new float[]{4.0f, 1.0f, 2.0f};
        MAX_BYTES_PER_CHARS = new float[]{5.0f, 1.0f, 2.0f};
    }
}

