/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCReleasingImage;
import com.ibm.dtfj.javacore.parser.j9.JavaCoreResourceReleaser;
import com.ibm.dtfj.utils.ManagedImage;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCImage
implements JCReleasingImage,
ManagedImage {
    private Vector fAddressSpaces = new Vector();
    private String fosType = null;
    private String fosSubType = null;
    private String fcpuType = null;
    private String fcpuSubType = null;
    private int fcpuCount;
    private boolean fcpuCountSet = false;
    private long fBytesMem;
    private boolean fBytesMemSet = false;
    private long fCreationTime;
    private boolean fCreationTimeSet = false;
    private long fCreationTimeNanos;
    private boolean fCreationTimeNanosSet = false;
    private String fHostName = null;
    private List fIPAddresses = new Vector();
    private List _closables = new Vector();
    private URI source = null;
    private ManagedImageSource imageSource = null;

    public void setSource(URI source) {
        this.source = source;
    }

    @Override
    public URI getSource() {
        try {
            if (this.source == null) {
                return new URI("jc:" + this.fHostName + ":" + this.fCreationTime);
            }
            return this.source;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void addAddressSpace(ImageAddressSpace imageAddressSpace) {
        if (imageAddressSpace != null) {
            this.fAddressSpaces.add(imageAddressSpace);
        }
    }

    @Override
    public Iterator getAddressSpaces() {
        return this.fAddressSpaces.iterator();
    }

    @Override
    public long getCreationTime() throws DataUnavailable {
        if (!this.fCreationTimeSet) {
            throw new DataUnavailable("Creation time not available");
        }
        return this.fCreationTime;
    }

    @Override
    public String getHostName() throws DataUnavailable, CorruptDataException {
        if (this.fHostName == null) {
            throw new DataUnavailable("Host name not available");
        }
        return this.fHostName;
    }

    @Override
    public Iterator getIPAddresses() throws DataUnavailable {
        return this.fIPAddresses.iterator();
    }

    @Override
    public long getInstalledMemory() throws DataUnavailable {
        if (!this.fBytesMemSet) {
            throw new DataUnavailable("Installed memory not available");
        }
        return this.fBytesMem;
    }

    @Override
    public int getProcessorCount() throws DataUnavailable {
        if (!this.fcpuCountSet) {
            throw new DataUnavailable("Processor count not available");
        }
        return this.fcpuCount;
    }

    @Override
    public String getProcessorSubType() throws DataUnavailable, CorruptDataException {
        if (this.fcpuSubType == null) {
            throw new DataUnavailable("Processor subtype not available");
        }
        return this.fcpuSubType;
    }

    @Override
    public String getProcessorType() throws DataUnavailable, CorruptDataException {
        if (this.fcpuType == null) {
            throw new DataUnavailable("Processor type not available");
        }
        return this.fcpuType;
    }

    @Override
    public String getSystemSubType() throws DataUnavailable, CorruptDataException {
        if (this.fosSubType == null) {
            throw new DataUnavailable("System subtype not available");
        }
        return this.fosSubType;
    }

    @Override
    public String getSystemType() throws DataUnavailable, CorruptDataException {
        if (this.fosType == null) {
            throw new DataUnavailable("System type not available");
        }
        return this.fosType;
    }

    public void setAddressSpaces(Vector addressSpaces) {
        this.fAddressSpaces = addressSpaces;
    }

    public void setBytesMem(long bytesMem) {
        this.fBytesMem = bytesMem;
        this.fBytesMemSet = true;
    }

    public void setcpuCount(int cpuCount) {
        this.fcpuCount = cpuCount;
        this.fcpuCountSet = true;
    }

    public void setcpuSubType(String cpuSubType) {
        this.fcpuSubType = cpuSubType;
    }

    public void setcpuType(String cpuType) {
        this.fcpuType = cpuType;
    }

    public void setCreationTime(long creationTime) {
        this.fCreationTime = creationTime;
        this.fCreationTimeSet = true;
    }

    public void setCreationTimeNanos(long nanoTime) {
        this.fCreationTimeNanos = nanoTime;
        this.fCreationTimeNanosSet = true;
    }

    public void setHostName(String hostName) {
        this.fHostName = hostName;
    }

    public void addIPAddresses(InetAddress address) {
        this.fIPAddresses.add(address);
    }

    public void setOSSubType(String osSubType) {
        this.fosSubType = osSubType;
    }

    public void setOSType(String osType) {
        this.fosType = osType;
    }

    @Override
    public void close() {
        for (Object o : this._closables) {
            if (!(o instanceof JavaCoreResourceReleaser)) continue;
            try {
                ((JavaCoreResourceReleaser)o).releaseResources();
            }
            catch (IOException e) {
                Logger.getLogger("com.ibm.dtfj.log").log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (this.imageSource != null && this.imageSource.getExtractedTo() != null) {
            this.imageSource.getExtractedTo().delete();
        }
    }

    @Override
    public void addReleasable(JavaCoreResourceReleaser o) {
        this._closables.add(o);
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public ManagedImageSource getImageSource() {
        return this.imageSource;
    }

    @Override
    public void setImageSource(ManagedImageSource source) {
        this.imageSource = source;
    }

    @Override
    public long getCreationTimeNanos() throws DataUnavailable, CorruptDataException {
        if (!this.fCreationTimeNanosSet) {
            throw new DataUnavailable("Creation time not available");
        }
        return this.fCreationTimeNanos;
    }
}

