/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.binaryreaders;

import com.ibm.dtfj.corereaders.ClosingFileReader;
import java.io.IOException;

public class ARReader {
    private ClosingFileReader _backing;
    private long _firstModuleHeader;

    public ARReader(ClosingFileReader file) {
        this._backing = file;
        try {
            this._backing.seek(0L);
            byte[] magic = new byte[8];
            this._backing.readFully(magic);
            if (!"<bigaf>\n".equals(new String(magic))) {
                throw new IllegalArgumentException();
            }
            this._backing.seek(68L);
            byte[] firstOffset = new byte[20];
            this._backing.readFully(firstOffset);
            this._firstModuleHeader = this._longFromBuffer(firstOffset);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public long offsetOfModule(String name) {
        long next = this._firstModuleHeader;
        while (0L != next) {
            try {
                this._backing.seek(next);
                byte[] buffer = new byte[20];
                this._backing.readFully(buffer);
                long length = this._longFromBuffer(buffer);
                this._backing.readFully(buffer);
                long nextOffset = this._longFromBuffer(buffer);
                this._backing.readFully(buffer);
                long prevOffset = this._longFromBuffer(buffer);
                this._backing.seek(next + 108L);
                buffer = new byte[4];
                this._backing.readFully(buffer);
                int nameLen = (int)this._longFromBuffer(buffer);
                buffer = new byte[nameLen];
                this._backing.readFully(buffer);
                String moduleName = null;
                moduleName = 0 < nameLen && 96 == buffer[0] && 10 == buffer[1] ? "" : new String(buffer, 0, nameLen);
                if (moduleName.equals(name)) {
                    long offset = next + 112L + (long)nameLen;
                    offset = 1L == offset % 2L ? (offset += 3L) : (offset += 2L);
                    return offset;
                }
                next = nextOffset;
            }
            catch (IOException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public long sizeOfModule(String name) {
        long next = this._firstModuleHeader;
        while (0L != next) {
            try {
                this._backing.seek(next);
                byte[] buffer = new byte[20];
                this._backing.readFully(buffer);
                long length = this._longFromBuffer(buffer);
                this._backing.readFully(buffer);
                long nextOffset = this._longFromBuffer(buffer);
                this._backing.readFully(buffer);
                long prevOffset = this._longFromBuffer(buffer);
                this._backing.seek(next + 108L);
                buffer = new byte[4];
                this._backing.readFully(buffer);
                int nameLen = (int)this._longFromBuffer(buffer);
                buffer = new byte[nameLen];
                this._backing.readFully(buffer);
                String moduleName = null;
                moduleName = 0 < nameLen && 96 == buffer[0] && 10 == buffer[1] ? "" : new String(buffer, 0, nameLen);
                if (moduleName.equals(name)) {
                    return length;
                }
                next = nextOffset;
            }
            catch (IOException e) {
                return -1L;
            }
        }
        return -1L;
    }

    private long _longFromBuffer(byte[] buffer) {
        int total = buffer.length;
        while (32 == buffer[total - 1]) {
            --total;
        }
        long length = Long.parseLong(new String(buffer, 0, total));
        return length;
    }
}

