/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.ibm.nio.ch.IBMSocketOptions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.net.ExtendedSocketOptions;
import sun.net.NetHooks;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketAdaptor;
import sun.nio.ch.SocketDispatcher;

class SocketChannelImpl
extends SocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private boolean isReuseAddress;
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_KILLPENDING = 3;
    private static final int ST_KILLED = 4;
    private int state = -1;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private boolean isInputOpen = true;
    private boolean isOutputOpen = true;
    private boolean readyToConnect = false;
    private Socket socket;

    SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    SocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, boolean bl) throws IOException {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 0;
        if (bl) {
            this.localAddress = Net.localAddress(fileDescriptor);
        }
    }

    SocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 2;
        this.localAddress = Net.localAddress(fileDescriptor);
        this.remoteAddress = inetSocketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = SocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return Net.getRevealedLocalAddress(this.localAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(socketOption)) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (socketOption == StandardSocketOptions.IP_TOS) {
                StandardProtocolFamily standardProtocolFamily = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
                Net.setSocketOption(this.fd, standardProtocolFamily, socketOption, t);
                return this;
            }
            if (socketOption == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                this.isReuseAddress = (Boolean)t;
                return this;
            }
            Net.setSocketOption(this.fd, Net.UNSPEC, socketOption, t);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(socketOption) || socketOption == IBMSocketOptions.TCP_KEEPALIVE_VALS) {
            throw new UnsupportedOperationException("'" + socketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (socketOption == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                return (T)Boolean.valueOf(this.isReuseAddress);
            }
            if (socketOption == StandardSocketOptions.IP_TOS) {
                StandardProtocolFamily standardProtocolFamily = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
                return (T)Net.getSocketOption(this.fd, standardProtocolFamily, socketOption);
            }
            return (T)Net.getSocketOption(this.fd, Net.UNSPEC, socketOption);
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReadOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            return this.isInputOpen;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWriteOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isOutputOpen) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readerCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.readerThread = 0L;
            if (this.state == 3) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writerCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.writerThread = 0L;
            if (this.state == 3) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        block22: {
            if (byteBuffer == null) {
                throw new NullPointerException();
            }
            Object object = this.readLock;
            // MONITORENTER : object
            if (!this.ensureReadOpen()) {
                // MONITOREXIT : object
                return -1;
            }
            n2 = 0;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block22;
            int n3 = 0;
            // MONITOREXIT : object2
            this.readerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n2 <= 0 && !this.isInputOpen) {
                // MONITOREXIT : object3
                // MONITOREXIT : object
                return -1;
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.readerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = IOUtil.read(this.fd, byteBuffer, -1L, nd)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.readerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (n2 <= 0 && !this.isInputOpen) {
                // MONITOREXIT : object
                // MONITOREXIT : object
                return -1;
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.readerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (n2 <= 0 && !this.isInputOpen) {
            // MONITOREXIT : object
            // MONITOREXIT : object
            return -1;
        }
        // MONITOREXIT : object
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l;
        long l2;
        block22: {
            if (n < 0) throw new IndexOutOfBoundsException();
            if (n2 < 0) throw new IndexOutOfBoundsException();
            if (n > byteBufferArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            Object object = this.readLock;
            // MONITORENTER : object
            if (!this.ensureReadOpen()) {
                // MONITOREXIT : object
                return -1L;
            }
            l2 = 0L;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block22;
            long l3 = 0L;
            // MONITOREXIT : object2
            this.readerCleanup();
            this.end(l2 > 0L || l2 == -2L);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (l2 <= 0L && !this.isInputOpen) {
                // MONITOREXIT : object3
                // MONITOREXIT : object
                return -1L;
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(l2));
            // MONITOREXIT : object
            return l3;
        }
        try {
            this.readerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((l2 = IOUtil.read(this.fd, byteBufferArray, n, n2, nd)) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(l2);
        }
        catch (Throwable throwable) {
            this.readerCleanup();
            this.end(l2 > 0L || l2 == -2L);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (l2 <= 0L && !this.isInputOpen) {
                // MONITOREXIT : object
                // MONITOREXIT : object
                return -1L;
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(l2)) throw throwable;
            throw new AssertionError();
        }
        this.readerCleanup();
        this.end(l2 > 0L || l2 == -2L);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (l2 <= 0L && !this.isInputOpen) {
            // MONITOREXIT : object
            // MONITOREXIT : object
            return -1L;
        }
        // MONITOREXIT : object
        assert (IOStatus.check(l2));
        // MONITOREXIT : object
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        block21: {
            if (byteBuffer == null) {
                throw new NullPointerException();
            }
            Object object = this.writeLock;
            // MONITORENTER : object
            this.ensureWriteOpen();
            n2 = 0;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block21;
            int n3 = 0;
            // MONITOREXIT : object2
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = IOUtil.write(this.fd, byteBuffer, -1L, nd)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (n2 <= 0 && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l;
        long l2;
        block21: {
            if (n < 0) throw new IndexOutOfBoundsException();
            if (n2 < 0) throw new IndexOutOfBoundsException();
            if (n > byteBufferArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            Object object = this.writeLock;
            // MONITORENTER : object
            this.ensureWriteOpen();
            l2 = 0L;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block21;
            long l3 = 0L;
            // MONITOREXIT : object2
            this.writerCleanup();
            this.end(l2 > 0L || l2 == -2L);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (l2 <= 0L && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(l2));
            // MONITOREXIT : object
            return l3;
        }
        try {
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((l2 = IOUtil.write(this.fd, byteBufferArray, n, n2, nd)) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(l2);
        }
        catch (Throwable throwable) {
            this.writerCleanup();
            this.end(l2 > 0L || l2 == -2L);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (l2 <= 0L && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(l2)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(l2 > 0L || l2 == -2L);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (l2 <= 0L && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object
        assert (IOStatus.check(l2));
        // MONITOREXIT : object
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    int sendOutOfBandData(byte by) throws IOException {
        int n;
        int n2;
        block20: {
            Object object = this.writeLock;
            // MONITORENTER : object
            this.ensureWriteOpen();
            n2 = 0;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block20;
            int n3 = 0;
            // MONITOREXIT : object2
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = SocketChannelImpl.sendOutOfBandData(this.fd, by)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (n2 <= 0 && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (this.state == 1) {
                        throw new ConnectionPendingException();
                    }
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = socketAddress == null ? new InetSocketAddress(0) : Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkListen(inetSocketAddress.getPort());
                    }
                    NetHooks.beforeTcpBind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionPending() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        Object object;
        boolean bl = false;
        Object object2 = this.readLock;
        // MONITORENTER : object2
        Object object3 = this.writeLock;
        // MONITORENTER : object3
        this.ensureOpenAndUnconnected();
        InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
        }
        Object object4 = this.blockingLock();
        // MONITORENTER : object4
        int n = 0;
        try {
            block26: {
                this.begin();
                object = this.stateLock;
                // MONITORENTER : object
                if (this.isOpen()) break block26;
                boolean bl2 = false;
                // MONITOREXIT : object
                this.readerCleanup();
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                // MONITOREXIT : object4
                // MONITOREXIT : object3
                // MONITOREXIT : object2
                return bl2;
            }
            try {
                if (this.localAddress == null) {
                    NetHooks.beforeTcpConnect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                }
                this.readerThread = NativeThread.current();
                // MONITOREXIT : object
                do {
                    if (!((InetAddress)(object = inetSocketAddress.getAddress())).isAnyLocalAddress()) continue;
                    object = InetAddress.getLocalHost();
                } while ((n = Net.connect(this.fd, (InetAddress)object, inetSocketAddress.getPort())) == -3 && this.isOpen());
            }
            catch (Throwable throwable) {
                this.readerCleanup();
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.readerCleanup();
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        object = this.stateLock;
        // MONITORENTER : object
        this.remoteAddress = inetSocketAddress;
        if (n > 0) {
            this.state = 2;
            if (this.isOpen()) {
                this.localAddress = Net.localAddress(this.fd);
            }
            // MONITOREXIT : object
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return true;
        }
        if (!this.isBlocking()) {
            this.state = 1;
            return false;
        }
        assert (false);
        // MONITOREXIT : object
        // MONITOREXIT : object4
        // MONITOREXIT : object3
        // MONITOREXIT : object2
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean finishConnect() throws IOException {
        Object object;
        Object object2 = this.readLock;
        // MONITORENTER : object2
        Object object3 = this.writeLock;
        // MONITORENTER : object3
        Object object4 = this.stateLock;
        // MONITORENTER : object4
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.state == 2) {
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return true;
        }
        if (this.state != 1) {
            throw new NoConnectionPendingException();
        }
        // MONITOREXIT : object4
        int n = 0;
        try {
            block40: {
                this.begin();
                object = this.blockingLock();
                // MONITORENTER : object
                Object object5 = this.stateLock;
                // MONITORENTER : object5
                if (this.isOpen()) break block40;
                boolean bl = false;
                // MONITOREXIT : object5
                // MONITOREXIT : object
                Object object6 = this.stateLock;
                // MONITORENTER : object6
                this.readerThread = 0L;
                if (this.state == 3) {
                    this.kill();
                    n = 0;
                }
                // MONITOREXIT : object6
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                // MONITOREXIT : object3
                // MONITOREXIT : object2
                return bl;
            }
            try {
                this.readerThread = NativeThread.current();
                // MONITOREXIT : object5
                if (!this.isBlocking()) {
                    while ((n = SocketChannelImpl.checkConnect(this.fd, false, this.readyToConnect)) == -3 && this.isOpen()) {
                    }
                } else {
                    while ((n = SocketChannelImpl.checkConnect(this.fd, true, this.readyToConnect)) == 0 || n == -3 && this.isOpen()) {
                    }
                }
                // MONITOREXIT : object
                object = this.stateLock;
            }
            catch (Throwable throwable) {
                Object object7 = this.stateLock;
                // MONITORENTER : object7
                this.readerThread = 0L;
                if (this.state == 3) {
                    this.kill();
                    n = 0;
                }
                // MONITOREXIT : object7
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.readerThread = 0L;
            if (this.state == 3) {
                this.kill();
                n = 0;
            }
            // MONITOREXIT : object
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        if (n <= 0) {
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return false;
        }
        object = this.stateLock;
        // MONITORENTER : object
        this.state = 2;
        if (this.isOpen()) {
            this.localAddress = Net.localAddress(this.fd);
        }
        // MONITOREXIT : object
        // MONITOREXIT : object3
        // MONITOREXIT : object2
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownInput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (this.isInputOpen) {
                Net.shutdown(this.fd, 0);
                if (this.readerThread != 0L) {
                    NativeThread.signal(this.readerThread);
                }
                this.isInputOpen = false;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownOutput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (this.isOutputOpen) {
                Net.shutdown(this.fd, 1);
                if (this.writerThread != 0L) {
                    NativeThread.signal(this.writerThread);
                }
                this.isOutputOpen = false;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isInputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isOutputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.isInputOpen = false;
            this.isOutputOpen = false;
            if (this.readerThread != 0L) {
                NativeThread.signal(this.readerThread);
            }
            if (this.writerThread != 0L) {
                NativeThread.signal(this.writerThread);
            }
            if (this.state != 4) {
                nd.preClose(this.fd);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 4) {
                return;
            }
            if (this.state == -1) {
                this.state = 4;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.readerThread == 0L && this.writerThread == 0L) {
                nd.close(this.fd);
                this.state = 4;
            } else {
                this.state = 3;
            }
        }
    }

    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((n & (Net.POLLERR | Net.POLLHUP)) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            this.readyToConnect = true;
            return (n5 & ~n4) != 0;
        }
        if ((n & Net.POLLIN) != 0 && (n3 & 1) != 0 && this.state == 2) {
            n5 |= 1;
        }
        if ((n & Net.POLLCONN) != 0 && (n3 & 8) != 0) {
            n5 |= 8;
            this.readyToConnect = true;
        }
        if ((n & Net.POLLOUT) != 0 && (n3 & 4) != 0 && this.state == 2) {
            n5 |= 4;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    int poll(int n, long l) throws IOException {
        int n2;
        block10: {
            int n3;
            if (!$assertionsDisabled) {
                if (!Thread.holdsLock(this.blockingLock())) throw new AssertionError();
                if (this.isBlocking()) {
                    throw new AssertionError();
                }
            }
            Object object = this.readLock;
            // MONITORENTER : object
            n2 = 0;
            try {
                this.begin();
                Object object2 = this.stateLock;
                // MONITORENTER : object2
                if (this.isOpen()) break block10;
                n3 = 0;
                // MONITOREXIT : object2
            }
            catch (Throwable throwable) {
                this.readerCleanup();
                this.end(n2 > 0);
                throw throwable;
            }
            this.readerCleanup();
            this.end(n2 > 0);
            // MONITOREXIT : object
            return n3;
        }
        this.readerThread = NativeThread.current();
        // MONITOREXIT : object2
        n2 = Net.poll(this.fd, n, l);
        this.readerCleanup();
        this.end(n2 > 0);
        return n2;
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= Net.POLLIN;
        }
        if ((n & 4) != 0) {
            n2 |= Net.POLLOUT;
        }
        if ((n & 8) != 0) {
            n2 |= Net.POLLCONN;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSuperclass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case 0: {
                        stringBuffer.append("unconnected");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("connection-pending");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("connected");
                        if (!this.isInputOpen) {
                            stringBuffer.append(" ishut");
                        }
                        if (this.isOutputOpen) break;
                        stringBuffer.append(" oshut");
                    }
                }
                InetSocketAddress inetSocketAddress = this.localAddress();
                if (inetSocketAddress != null) {
                    stringBuffer.append(" local=");
                    stringBuffer.append(Net.getRevealedLocalAddressAsString(inetSocketAddress));
                }
                if (this.remoteAddress() != null) {
                    stringBuffer.append(" remote=");
                    stringBuffer.append(this.remoteAddress().toString());
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static native int checkConnect(FileDescriptor var0, boolean var1, boolean var2) throws IOException;

    private static native int sendOutOfBandData(FileDescriptor var0, byte var1) throws IOException;

    static {
        IOUtil.load();
        nd = new SocketDispatcher();
    }

    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet hashSet = new HashSet(8);
            hashSet.add(StandardSocketOptions.SO_SNDBUF);
            hashSet.add(StandardSocketOptions.SO_RCVBUF);
            hashSet.add(StandardSocketOptions.SO_KEEPALIVE);
            hashSet.add(StandardSocketOptions.SO_REUSEADDR);
            hashSet.add(StandardSocketOptions.SO_LINGER);
            hashSet.add(StandardSocketOptions.TCP_NODELAY);
            hashSet.add(StandardSocketOptions.IP_TOS);
            hashSet.add(ExtendedSocketOption.SO_OOBINLINE);
            hashSet.add(IBMSocketOptions.TCP_KEEPALIVE_VALS);
            hashSet.addAll(ExtendedSocketOptions.clientSocketOptions());
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

