/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.StateInvariantError;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PlainView
extends View
implements TabExpander {
    protected FontMetrics metrics;
    Element longLine;
    Font font;
    Segment lineBuffer;
    int tabSize;
    int tabBase;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;
    int firstLineOffset;

    public PlainView(Element element) {
        super(element);
    }

    protected int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 8;
        return n2;
    }

    protected void drawLine(int n, Graphics graphics, int n2, int n3) {
        Element element = this.getElement().getElement(n);
        try {
            if (element.isLeaf()) {
                this.drawElement(n, element, graphics, n2, n3);
            } else {
                int n4 = element.getElementCount();
                for (int i = 0; i < n4; ++i) {
                    Element element2 = element.getElement(i);
                    n2 = this.drawElement(n, element2, graphics, n2, n3);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't render line: " + n);
        }
    }

    private int drawElement(int n, Element element, Graphics graphics, int n2, int n3) throws BadLocationException {
        AttributeSet attributeSet;
        int n4 = element.getStartOffset();
        int n5 = element.getEndOffset();
        n5 = Math.min(this.getDocument().getLength(), n5);
        if (n == 0) {
            n2 += this.firstLineOffset;
        }
        if (Utilities.isComposedTextAttributeDefined(attributeSet = element.getAttributes())) {
            graphics.setColor(this.unselected);
            n2 = Utilities.drawComposedText(this, attributeSet, graphics, n2, n3, n4 - element.getStartOffset(), n5 - element.getStartOffset());
        } else if (this.sel0 == this.sel1 || this.selected == this.unselected) {
            n2 = this.drawUnselectedText(graphics, n2, n3, n4, n5);
        } else if (n4 >= this.sel0 && n4 <= this.sel1 && n5 >= this.sel0 && n5 <= this.sel1) {
            n2 = this.drawSelectedText(graphics, n2, n3, n4, n5);
            graphics.setColor(this.unselected);
        } else if (this.sel0 >= n4 && this.sel0 <= n5) {
            if (this.sel1 >= n4 && this.sel1 <= n5) {
                n2 = this.drawUnselectedText(graphics, n2, n3, n4, this.sel0);
                n2 = this.drawSelectedText(graphics, n2, n3, this.sel0, this.sel1);
                n2 = this.drawUnselectedText(graphics, n2, n3, this.sel1, n5);
            } else {
                n2 = this.drawUnselectedText(graphics, n2, n3, n4, this.sel0);
                n2 = this.drawSelectedText(graphics, n2, n3, this.sel0, n5);
                graphics.setColor(this.unselected);
            }
        } else if (this.sel1 >= n4 && this.sel1 <= n5) {
            n2 = this.drawSelectedText(graphics, n2, n3, n4, this.sel1);
            n2 = this.drawUnselectedText(graphics, n2, n3, this.sel1, n5);
        } else {
            n2 = this.drawUnselectedText(graphics, n2, n3, n4, n5);
        }
        return n2;
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.unselected);
        Document document = this.getDocument();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n3, n4 - n3, segment);
        int n5 = Utilities.drawTabbedText(this, segment, n, n2, graphics, this, n3);
        SegmentCache.releaseSharedSegment(segment);
        return n5;
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selected);
        Document document = this.getDocument();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n3, n4 - n3, segment);
        int n5 = Utilities.drawTabbedText(this, segment, n, n2, graphics, this, n3);
        SegmentCache.releaseSharedSegment(segment);
        return n5;
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    protected void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        if (this.font != font) {
            this.calculateLongestLine();
            this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
        }
    }

    @Override
    public float getPreferredSpan(int n) {
        this.updateMetrics();
        switch (n) {
            case 0: {
                return this.getLineWidth(this.longLine);
            }
            case 1: {
                return this.getElement().getElementCount() * this.metrics.getHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        int n;
        int n2;
        int n3;
        Shape shape2 = shape;
        shape = this.adjustPaintRegion(shape);
        Rectangle rectangle = (Rectangle)shape;
        this.tabBase = rectangle.x;
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        Highlighter highlighter = jTextComponent.getHighlighter();
        graphics.setFont(jTextComponent.getFont());
        this.sel0 = jTextComponent.getSelectionStart();
        this.sel1 = jTextComponent.getSelectionEnd();
        this.unselected = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        Caret caret = jTextComponent.getCaret();
        this.selected = caret.isSelectionVisible() && highlighter != null ? jTextComponent.getSelectedTextColor() : this.unselected;
        this.updateMetrics();
        Rectangle rectangle2 = graphics.getClipBounds();
        int n4 = this.metrics.getHeight();
        int n5 = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
        int n6 = rectangle2.y - rectangle.y;
        if (n4 > 0) {
            n3 = Math.max(0, n5 / n4);
            n2 = Math.max(0, n6 / n4);
            n = rectangle.height / n4;
            if (rectangle.height % n4 != 0) {
                ++n;
            }
        } else {
            n = 0;
            n2 = 0;
            n3 = 0;
        }
        Rectangle rectangle3 = this.lineToRect(shape, n2);
        int n7 = rectangle3.y + this.metrics.getAscent();
        int n8 = rectangle3.x;
        Element element = this.getElement();
        int n9 = element.getElementCount();
        int n10 = Math.min(n9, n - n3);
        --n9;
        LayeredHighlighter layeredHighlighter = highlighter instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
        for (int i = n2; i < n10; ++i) {
            if (layeredHighlighter != null) {
                Element element2 = element.getElement(i);
                if (i == n9) {
                    layeredHighlighter.paintLayeredHighlights(graphics, element2.getStartOffset(), element2.getEndOffset(), shape2, jTextComponent, this);
                } else {
                    layeredHighlighter.paintLayeredHighlights(graphics, element2.getStartOffset(), element2.getEndOffset() - 1, shape2, jTextComponent, this);
                }
            }
            this.drawLine(i, graphics, n8, n7);
            n7 += n4;
            if (i != 0) continue;
            n8 -= this.firstLineOffset;
        }
    }

    Shape adjustPaintRegion(Shape shape) {
        return shape;
    }

    @Override
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Document document = this.getDocument();
        Element element = this.getElement();
        int n2 = element.getElementIndex(n);
        if (n2 < 0) {
            return this.lineToRect(shape, 0);
        }
        Rectangle rectangle = this.lineToRect(shape, n2);
        this.tabBase = rectangle.x;
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n3, n - n3, segment);
        int n4 = Utilities.getTabbedTextWidth(segment, this.metrics, this.tabBase, this, n3);
        SegmentCache.releaseSharedSegment(segment);
        rectangle.x += n4;
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    @Override
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        int n;
        biasArray[0] = Position.Bias.Forward;
        Rectangle rectangle = shape.getBounds();
        Document document = this.getDocument();
        int n2 = (int)f;
        int n3 = (int)f2;
        if (n3 < rectangle.y) {
            return this.getStartOffset();
        }
        if (n3 > rectangle.y + rectangle.height) {
            return this.getEndOffset() - 1;
        }
        Element element = document.getDefaultRootElement();
        int n4 = this.metrics.getHeight();
        int n5 = n = n4 > 0 ? Math.abs((n3 - rectangle.y) / n4) : element.getElementCount() - 1;
        if (n >= element.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element element2 = element.getElement(n);
        boolean bl = false;
        if (n == 0) {
            rectangle.x += this.firstLineOffset;
            rectangle.width -= this.firstLineOffset;
        }
        if (n2 < rectangle.x) {
            return element2.getStartOffset();
        }
        if (n2 > rectangle.x + rectangle.width) {
            return element2.getEndOffset() - 1;
        }
        try {
            int n6 = element2.getStartOffset();
            int n7 = element2.getEndOffset() - 1;
            Segment segment = SegmentCache.getSharedSegment();
            document.getText(n6, n7 - n6, segment);
            this.tabBase = rectangle.x;
            int n8 = n6 + Utilities.getTabbedTextOffset(segment, this.metrics, this.tabBase, n2, this, n6);
            SegmentCache.releaseSharedSegment(segment);
            return n8;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    @Override
    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        this.updateMetrics();
    }

    @Override
    public float nextTabStop(float f, int n) {
        if (this.tabSize == 0) {
            return f;
        }
        int n2 = ((int)f - this.tabBase) / this.tabSize;
        return this.tabBase + (n2 + 1) * this.tabSize;
    }

    protected void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element[] elementArray;
        Container container = this.getContainer();
        this.updateMetrics();
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        Element[] elementArray2 = elementChange != null ? elementChange.getChildrenAdded() : null;
        Element[] elementArray3 = elementArray = elementChange != null ? elementChange.getChildrenRemoved() : null;
        if (elementArray2 != null && elementArray2.length > 0 || elementArray != null && elementArray.length > 0) {
            int n;
            if (elementArray2 != null) {
                n = this.getLineWidth(this.longLine);
                for (int i = 0; i < elementArray2.length; ++i) {
                    int n2 = this.getLineWidth(elementArray2[i]);
                    if (n2 <= n) continue;
                    n = n2;
                    this.longLine = elementArray2[i];
                }
            }
            if (elementArray != null) {
                for (n = 0; n < elementArray.length; ++n) {
                    if (elementArray[n] != this.longLine) continue;
                    this.calculateLongestLine();
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            container.repaint();
        } else {
            Element element2 = this.getElement();
            int n = element2.getElementIndex(documentEvent.getOffset());
            this.damageLineRange(n, n, shape, container);
            if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
                int n3 = this.getLineWidth(this.longLine);
                Element element3 = element2.getElement(n);
                if (element3 == this.longLine) {
                    this.preferenceChanged(null, true, false);
                } else if (this.getLineWidth(element3) > n3) {
                    this.longLine = element3;
                    this.preferenceChanged(null, true, false);
                }
            } else if (documentEvent.getType() == DocumentEvent.EventType.REMOVE && element2.getElement(n) == this.longLine) {
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    protected void damageLineRange(int n, int n2, Shape shape, Component component) {
        if (shape != null) {
            Rectangle rectangle = this.lineToRect(shape, n);
            Rectangle rectangle2 = this.lineToRect(shape, n2);
            if (rectangle != null && rectangle2 != null) {
                Rectangle rectangle3 = rectangle.union(rectangle2);
                component.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            } else {
                component.repaint();
            }
        }
    }

    protected Rectangle lineToRect(Shape shape, int n) {
        Rectangle rectangle = null;
        this.updateMetrics();
        if (this.metrics != null) {
            Rectangle rectangle2 = shape.getBounds();
            if (n == 0) {
                rectangle2.x += this.firstLineOffset;
                rectangle2.width -= this.firstLineOffset;
            }
            rectangle = new Rectangle(rectangle2.x, rectangle2.y + n * this.metrics.getHeight(), rectangle2.width, this.metrics.getHeight());
        }
        return rectangle;
    }

    private void calculateLongestLine() {
        Container container = this.getContainer();
        this.font = container.getFont();
        this.metrics = container.getFontMetrics(this.font);
        Document document = this.getDocument();
        Element element = this.getElement();
        int n = element.getElementCount();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            int n3 = this.getLineWidth(element2);
            if (n3 <= n2) continue;
            n2 = n3;
            this.longLine = element2;
        }
    }

    private int getLineWidth(Element element) {
        int n;
        if (element == null) {
            return 0;
        }
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset();
        Segment segment = SegmentCache.getSharedSegment();
        try {
            element.getDocument().getText(n2, n3 - n2, segment);
            n = Utilities.getTabbedTextWidth(segment, this.metrics, this.tabBase, this, n2);
        }
        catch (BadLocationException badLocationException) {
            n = 0;
        }
        SegmentCache.releaseSharedSegment(segment);
        return n;
    }
}

