/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType$SupportType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogMode;
import com.ibm.gsk.ikeyman.gui.panels.FileNamePanel;
import com.ibm.gsk.ikeyman.gui.panels.KeymanFileFilter;
import com.ibm.gsk.ikeyman.gui.panels.KeymanFileFilter$FilterType;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.util.HashMap;
import java.util.Map;
import javax.swing.filechooser.FileFilter;

class FileNamePanelFactory$DatabaseFileNamePanel
extends FileNamePanel {
    private static Map defaultLocations = new HashMap();

    private static void populateDefault(KeymanSettings$Setting keymanSettings$Setting, Constants$DatabaseType constants$DatabaseType) {
        if (keymanSettings$Setting.getString() != null) {
            defaultLocations.put(constants$DatabaseType, keymanSettings$Setting.getString());
        }
    }

    protected FileNamePanelFactory$DatabaseFileNamePanel(GUIConstants$DialogMode gUIConstants$DialogMode, FileName fileName) {
        super(gUIConstants$DialogMode, fileName);
    }

    protected String getComboLabel() {
        return Messages.getStringWithMnemonics("Label.KeyDatabaseType");
    }

    protected String getFileNameLabel() {
        return Messages.getStringWithMnemonics("Label.FileName");
    }

    protected Object[] getComboValues() {
        if (this.getMode() == GUIConstants$DialogMode.New) {
            return Constants$DatabaseType.values(Constants$DatabaseType$SupportType.Creation);
        }
        return Constants$DatabaseType.values(Constants$DatabaseType$SupportType.Opening);
    }

    protected Constants$DatabaseType getType() {
        return (Constants$DatabaseType)this.getComboValue();
    }

    public ParameterMap getParameters() throws KeyManagerException {
        ParameterMap parameterMap = new ParameterMap();
        if (this.getType() == Constants$DatabaseType.PKCS11Direct) {
            parameterMap.put(Constants$Parameter.Crypto, this.getFile().getAbsolutePath());
        } else if (this.getType() == Constants$DatabaseType.PKCS11Config) {
            parameterMap.put(Constants$Parameter.Crypto, "");
        } else {
            parameterMap.put(Constants$Parameter.DatabaseName, this.getFile().getAbsolutePath());
            parameterMap.put(Constants$Parameter.Type, this.getType());
        }
        return parameterMap;
    }

    protected FileFilter getFileFilter() {
        return new KeymanFileFilter(KeymanFileFilter$FilterType.forDatabaseType(this.getType()));
    }

    protected Map getDefaultLocationMap() {
        return defaultLocations;
    }

    protected String getComboTooltip() {
        return Messages.getString("Tooltip.DbType");
    }

    protected String getFileNameTooltip() {
        return Messages.getString("Tooltip.DbFileName");
    }

    protected boolean fileNameFieldEnabled() {
        return this.fieldsEnabled();
    }

    protected FileName getDefaultFileName() {
        if (this.getType() == Constants$DatabaseType.PKCS11Config || this.getType() == Constants$DatabaseType.MSCapi) {
            return null;
        }
        return super.getDefaultFileName();
    }

    protected boolean locationFieldEnabled() {
        return this.fieldsEnabled();
    }

    protected boolean browseButtonEnabled() {
        return this.fieldsEnabled();
    }

    private boolean fieldsEnabled() {
        return this.getType() != Constants$DatabaseType.PKCS11Config && this.getType() != Constants$DatabaseType.MSCapi;
    }

    public void updateDefaultLocation() {
        if (this.getType().useLastOpenedLocation()) {
            super.updateDefaultLocation();
        }
    }

    static {
        FileNamePanelFactory$DatabaseFileNamePanel.populateDefault(KeymanSettings$Setting.DefaultCMSFileLocation, Constants$DatabaseType.CMS);
        FileNamePanelFactory$DatabaseFileNamePanel.populateDefault(KeymanSettings$Setting.DefaultJKSFileLocation, Constants$DatabaseType.JKS);
        FileNamePanelFactory$DatabaseFileNamePanel.populateDefault(KeymanSettings$Setting.DefaultPKCS12FileLocation, Constants$DatabaseType.PKCS12);
        FileNamePanelFactory$DatabaseFileNamePanel.populateDefault(KeymanSettings$Setting.DefaultPKCS12FileLocation, Constants$DatabaseType.PKCS12S2);
        FileNamePanelFactory$DatabaseFileNamePanel.populateDefault(KeymanSettings$Setting.DefaultJCEKSFileLocation, Constants$DatabaseType.JCEKS);
        KeymanSettings$Setting keymanSettings$Setting = KeymanSettings$Setting.DefaultCryptoModule;
        if (!keymanSettings$Setting.getString().equals(keymanSettings$Setting.getDefault())) {
            defaultLocations.put(Constants$DatabaseType.PKCS11Direct, new FileName(keymanSettings$Setting.getString()).getDirectory());
        }
    }
}

