/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.gui.panels.CertRequestButtonPanel;
import com.ibm.gsk.ikeyman.gui.panels.ContentsPanel$1;
import com.ibm.gsk.ikeyman.gui.panels.ContentsPanel$2;
import com.ibm.gsk.ikeyman.gui.panels.ContentsPanel$3;
import com.ibm.gsk.ikeyman.gui.panels.ContentsPanel$ListSelectItem;
import com.ibm.gsk.ikeyman.gui.panels.KeymanPanel;
import com.ibm.gsk.ikeyman.gui.panels.PersonalCertsButtonPanel;
import com.ibm.gsk.ikeyman.gui.panels.SecretKeyButtonPanel;
import com.ibm.gsk.ikeyman.gui.panels.SignerCertsButtonPanel;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ContentsPanel
extends KeymanPanel {
    private static final String comboAction = "ComboAction";
    private static final long serialVersionUID = 1L;
    private KeymanPanel eastPanel = null;
    private JList itemList = null;
    private PersonalCertsButtonPanel personalCertsButtonPanel = null;
    private CertRequestButtonPanel certRequestButtonPanel = null;
    private SignerCertsButtonPanel signerCertsButtonPanel = null;
    private SecretKeyButtonPanel secretKeyButtonPanel = null;
    private Entry[] personalCerts = null;
    private Entry[] signerCerts = null;
    private Entry[] certRequests = null;
    private Entry[] secretKeys = null;
    private DatabaseDescriptorFactory$DatabaseDescriptor descriptor = null;
    private JScrollPane jScrollPane = null;
    private JPanel centrePanel = null;
    private JComboBox listSelectCombo = null;

    public ContentsPanel() {
        this.initialize();
        this.listSelectCombo.setSelectedIndex(0);
    }

    private void initialize() {
        this.setSize(588, 473);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("Label.KeyDatabaseContent"), 2, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.add((Component)this.getEastPanel(), "East");
        this.add((Component)this.getCentrePanel(), "Center");
        this.setName(ControlNames.ContentsPanel.toString());
    }

    private JPanel getEastPanel() {
        if (this.eastPanel == null) {
            this.eastPanel = new KeymanPanel();
            this.eastPanel.setLayout(new CardLayout());
            this.eastPanel.add((Component)this.getPersonalCertsButtonPanel(), this.getPersonalCertsButtonPanel().getName());
            this.eastPanel.add((Component)this.getCertRequestButtonPanel(), this.getCertRequestButtonPanel().getName());
            this.eastPanel.add((Component)this.getSignerCertsButtonPanel(), this.getSignerCertsButtonPanel().getName());
            this.eastPanel.add((Component)this.getSecretKeyButtonPanel(), this.getSecretKeyButtonPanel().getName());
        }
        return this.eastPanel;
    }

    private JComboBox getListSelectCombo() {
        if (this.listSelectCombo == null) {
            this.listSelectCombo = new JComboBox<ContentsPanel$ListSelectItem>(ContentsPanel$ListSelectItem.getSupportedValues());
            this.listSelectCombo.setActionCommand(comboAction);
            this.listSelectCombo.addActionListener(this);
            this.listSelectCombo.setToolTipText(Messages.getString("Tooltip.ObjectsInDB"));
            this.listSelectCombo.getAccessibleContext().setAccessibleName(Messages.getString("Accessibility.Name.ListSelectCombo"));
            this.listSelectCombo.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.ObjectsInDB"));
            this.listSelectCombo.setName(ControlNames.ContentsPanelListSelectCombo.toString());
        }
        return this.listSelectCombo;
    }

    private JList getItemList() {
        if (this.itemList == null) {
            this.itemList = new JList();
            this.itemList.addMouseListener(new ContentsPanel$1(this));
            this.itemList.setCellRenderer(new ContentsPanel$2(this));
            this.itemList.addListSelectionListener(new ContentsPanel$3(this));
        }
        return this.itemList;
    }

    private void disableUncoverableButtons() {
        ContentsPanel$ListSelectItem contentsPanel$ListSelectItem = (ContentsPanel$ListSelectItem)((Object)this.listSelectCombo.getSelectedItem());
        if (contentsPanel$ListSelectItem != null) {
            if (contentsPanel$ListSelectItem.equals((Object)ContentsPanel$ListSelectItem.PersonalCerts)) {
                this.personalCertsButtonPanel.disableUncoverableButtons();
            } else if (contentsPanel$ListSelectItem.equals((Object)ContentsPanel$ListSelectItem.SignerCerts)) {
                this.signerCertsButtonPanel.disableUncoverableButtons();
            } else if (contentsPanel$ListSelectItem.equals((Object)ContentsPanel$ListSelectItem.CertificateRequests)) {
                this.certRequestButtonPanel.disableUncoverableButtons();
            } else if (contentsPanel$ListSelectItem.equals((Object)ContentsPanel$ListSelectItem.SecretKeys)) {
                this.secretKeyButtonPanel.disableUncoverableButtons();
            }
        }
    }

    private void itemDoubleClickedHandler() {
        if (this.itemList.getSelectedIndex() != -1) {
            Constants$CommandType constants$CommandType = ((ContentsPanel$ListSelectItem)((Object)this.listSelectCombo.getSelectedItem())).getDefaultCommand();
            this.fireActionPerformed(new ActionEvent(this, 0, constants$CommandType.toString()));
        }
    }

    private PersonalCertsButtonPanel getPersonalCertsButtonPanel() {
        if (this.personalCertsButtonPanel == null) {
            this.personalCertsButtonPanel = new PersonalCertsButtonPanel();
            this.personalCertsButtonPanel.setName("personalCertsButtonPanel");
            this.personalCertsButtonPanel.addActionListener(this);
        }
        return this.personalCertsButtonPanel;
    }

    private CertRequestButtonPanel getCertRequestButtonPanel() {
        if (this.certRequestButtonPanel == null) {
            this.certRequestButtonPanel = new CertRequestButtonPanel();
            this.certRequestButtonPanel.setName("certRequestButtonPanel");
            this.certRequestButtonPanel.addActionListener(this);
        }
        return this.certRequestButtonPanel;
    }

    private SignerCertsButtonPanel getSignerCertsButtonPanel() {
        if (this.signerCertsButtonPanel == null) {
            this.signerCertsButtonPanel = new SignerCertsButtonPanel();
            this.signerCertsButtonPanel.setName("signerCertsButtonPanel");
            this.signerCertsButtonPanel.addActionListener(this);
        }
        return this.signerCertsButtonPanel;
    }

    private SecretKeyButtonPanel getSecretKeyButtonPanel() {
        if (this.secretKeyButtonPanel == null) {
            this.secretKeyButtonPanel = new SecretKeyButtonPanel();
            this.secretKeyButtonPanel.setName("secretKeyButtonPanel");
            this.secretKeyButtonPanel.addActionListener(this);
        }
        return this.secretKeyButtonPanel;
    }

    private void updateDisplay() {
        Entry[] entryArray = null;
        String string = null;
        switch ((ContentsPanel$ListSelectItem)((Object)this.listSelectCombo.getSelectedItem())) {
            case PersonalCerts: {
                ((CardLayout)this.eastPanel.getLayout()).show(this.eastPanel, this.getPersonalCertsButtonPanel().getName());
                entryArray = this.personalCerts;
                string = Messages.getString("Tooltip.PersonalCertList");
                break;
            }
            case SignerCerts: {
                ((CardLayout)this.eastPanel.getLayout()).show(this.eastPanel, this.getSignerCertsButtonPanel().getName());
                entryArray = this.signerCerts;
                string = Messages.getString("Tooltip.CAList");
                break;
            }
            case CertificateRequests: {
                ((CardLayout)this.eastPanel.getLayout()).show(this.eastPanel, this.getCertRequestButtonPanel().getName());
                entryArray = this.certRequests;
                string = Messages.getString("Tooltip.CertReqList");
                break;
            }
            case SecretKeys: {
                ((CardLayout)this.eastPanel.getLayout()).show(this.eastPanel, this.getSecretKeyButtonPanel().getName());
                entryArray = this.secretKeys;
                string = Messages.getString("Tooltip.SecretKeyList");
            }
        }
        this.itemList.setToolTipText(string);
        if (entryArray == null) {
            this.eastPanel.setEnabled(false);
            this.itemList.setListData(new String[0]);
        } else {
            this.eastPanel.setEnabled(true);
            this.itemList.setListData(entryArray);
            if (entryArray.length > 0) {
                this.itemList.setSelectedIndex(0);
                this.updateButtons(true);
            } else {
                this.updateButtons(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(comboAction)) {
            this.updateDisplay();
            this.fireActionPerformed(new ActionEvent(this, this.listSelectCombo.getSelectedIndex(), Constants$CommandType.RefreshLists.toString()));
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void refreshDatabase(KeyStoreInfo keyStoreInfo) {
        if (keyStoreInfo != null) {
            this.personalCerts = keyStoreInfo.getPersonalCerts().toArray(new Entry[0]);
            this.signerCerts = keyStoreInfo.getSignerCerts().toArray(new Entry[0]);
            this.certRequests = keyStoreInfo.getCertificateRequests().toArray(new Entry[0]);
            this.secretKeys = keyStoreInfo.getSecretKeys().toArray(new Entry[0]);
            this.descriptor = keyStoreInfo.getDescriptor();
            if (ContentsPanel$ListSelectItem.updateSupportedValues(keyStoreInfo)) {
                this.listSelectCombo.setModel(new DefaultComboBoxModel<ContentsPanel$ListSelectItem>(ContentsPanel$ListSelectItem.getSupportedValues()));
            }
        } else {
            this.personalCerts = null;
            this.signerCerts = null;
            this.certRequests = null;
            this.secretKeys = null;
            this.descriptor = null;
        }
        this.updateDisplay();
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getItemList());
        }
        return this.jScrollPane;
    }

    private JPanel getCentrePanel() {
        if (this.centrePanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.ipady = 270;
            gridBagConstraints.ipadx = 148;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 6, 10);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.ipady = 1;
            gridBagConstraints2.ipadx = 375;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.insets = new Insets(5, 5, 4, 11);
            this.centrePanel = new JPanel();
            this.centrePanel.setLayout(new GridBagLayout());
            this.centrePanel.add((Component)this.getListSelectCombo(), gridBagConstraints2);
            this.centrePanel.add((Component)this.getJScrollPane(), gridBagConstraints);
        }
        return this.centrePanel;
    }

    public Entry getSelectedEntry() {
        return (Entry)this.itemList.getSelectedValue();
    }

    public Collection getSelectedEntries() {
        Object[] objectArray = this.itemList.getSelectedValues();
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (Object object : objectArray) {
            arrayList.add((Entry)object);
        }
        return arrayList;
    }

    private void updateButtons(boolean bl) {
        ContentsPanel$ListSelectItem contentsPanel$ListSelectItem = (ContentsPanel$ListSelectItem)((Object)this.listSelectCombo.getSelectedItem());
        if (contentsPanel$ListSelectItem != null) {
            if (contentsPanel$ListSelectItem.equals((Object)ContentsPanel$ListSelectItem.PersonalCerts)) {
                this.personalCertsButtonPanel.updateButtons(bl, this.descriptor);
            } else if (contentsPanel$ListSelectItem.equals((Object)ContentsPanel$ListSelectItem.SignerCerts)) {
                this.signerCertsButtonPanel.updateButtons(bl, this.descriptor);
            } else if (contentsPanel$ListSelectItem.equals((Object)ContentsPanel$ListSelectItem.CertificateRequests)) {
                this.certRequestButtonPanel.updateButtons(bl, this.descriptor);
            } else if (contentsPanel$ListSelectItem.equals((Object)ContentsPanel$ListSelectItem.SecretKeys)) {
                this.secretKeyButtonPanel.updateButtons(bl, this.descriptor);
            }
        }
    }

    static void access$000(ContentsPanel contentsPanel) {
        contentsPanel.itemDoubleClickedHandler();
    }

    static JList access$100(ContentsPanel contentsPanel) {
        return contentsPanel.itemList;
    }

    static void access$200(ContentsPanel contentsPanel) {
        contentsPanel.disableUncoverableButtons();
    }

    static void access$300(ContentsPanel contentsPanel, boolean bl) {
        contentsPanel.updateButtons(bl);
    }
}

