/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.CommandFactory$DefaultableCommand;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validatable;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validation;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;

class CommandFactory$CreateSsCertCommand
extends CommandFactory$DefaultableCommand {
    private static final Map defaults = new HashMap();

    public CommandFactory$CreateSsCertCommand(ParameterMap parameterMap) {
        super(parameterMap, ValidatorFactory.newValidator(new ValidatorFactory$Validation[]{ValidatorFactory.required(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.DatabaseName, Constants$Parameter.TokenLabel, Constants$Parameter.RelativeSlotNumber}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Crypto, ValidatorFactory.not(ValidatorFactory.itemPresent(Constants$Parameter.DatabaseName))), ValidatorFactory.required(Constants$Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.Password, Constants$Parameter.Stashed}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.DN, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Type, ValidatorFactory.itemPresent(Constants$Parameter.DatabaseName)), ValidatorFactory.optional(Constants$Parameter.Expire, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Size, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.X509Version, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.DefaultCert, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.CA, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SigAlg, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SanDnsName, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SanEmailAddress, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.SanIpAddress, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.EKU, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.KU, ValidatorFactory.always())}), defaults);
        Debug.entering();
        Debug.exiting();
    }

    protected String addKey(KeyStoreItem keyStoreItem, CommandParameters commandParameters) throws KeyManagerException {
        Debug.entering(new Object[]{keyStoreItem, commandParameters});
        if (keyStoreItem.getAliases().contains(commandParameters.getLabel())) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.ENTRY_EXISTS_FOR_LABEL, new String[]{commandParameters.getLabel()});
        }
        KeyPair keyPair = keyStoreItem.getKeyCreator().generateKeyPair(commandParameters);
        CertificateKeyItem certificateKeyItem = EntryFactory.newKeyItem(commandParameters, keyPair, commandParameters.getSigAlg().toString(), keyStoreItem.getKeyCreator().getProvider());
        keyStoreItem.add(certificateKeyItem);
        Debug.exiting(certificateKeyItem.getLabel());
        return certificateKeyItem.getLabel();
    }

    static {
        defaults.put(Constants$Parameter.Size, KeymanSettings$Setting.DefaultKeySize.getInteger() + "");
        defaults.put(Constants$Parameter.X509Version, KeymanSettings.X509_VERSION_DEFAULT);
        defaults.put(Constants$Parameter.Expire, KeymanSettings$Setting.DefaultCertExpire.getInteger());
        defaults.put(Constants$Parameter.SigAlg, KeymanSettings.DEFAULT_SIGNATURE_ALGORITHM);
        defaults.put(Constants$Parameter.CA, KeymanSettings$Setting.DefaultSSCertBasicConstraints.getBoolean());
    }
}

