/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.SystemException;

abstract class GIOPUtil {
    static final int GIOP_MAGIC = 1195986768;
    static final byte BYTE_ORDER_MASK = 1;
    static final byte FRAG_MASK = 2;
    static final byte LITTLE_ENDIAN = 1;
    static final byte FRAGMENT_TO_FOLLOW = 2;
    static final byte REQUEST = 0;
    static final byte REPLY = 1;
    static final byte CANCEL_REQUEST = 2;
    static final byte LOCATE_REQUEST = 3;
    static final byte LOCATE_REPLY = 4;
    static final byte CLOSE_CONNECTION = 5;
    static final byte MESSAGE_ERROR = 6;
    static final byte FRAGMENT = 7;
    static final int REQ_ID = 0;
    static final int FLAGS = 1;
    static final int OP = 2;
    static final int PRNCPL = 3;
    static final int SVC_CTX = 4;
    static final int LOC_STAT = 5;
    static final int OBJ_KEY = 6;
    static final int TGT = 7;
    static final int REP_STAT = 8;
    static final int EXC_ID = 9;
    static final int IOR = 10;
    static final int ADDR_MODE = 11;
    static final int REPOS_ID = 12;
    static final int EXC_CL_NAME = 13;
    static final int MINOR_CODE = 14;
    static final int EXC_STATUS = 15;

    GIOPUtil() {
    }

    static int msgGiopMagic(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | (byArray[3] & 0xFF) << 0;
    }

    static byte msgGiopMajor(byte[] byArray) {
        return byArray[4];
    }

    static byte msgGiopMinor(byte[] byArray) {
        return byArray[5];
    }

    static boolean msgIsLittleEndian(byte[] byArray) {
        return 1 == (byArray[6] & 1);
    }

    static boolean fragToFollow(byte[] byArray) {
        return 2 == (2 & byArray[6]);
    }

    static byte msgType(byte[] byArray) {
        return byArray[7];
    }

    static int msgSize(byte[] byArray) {
        return GIOPUtil.msgIsLittleEndian(byArray) ? (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF : (byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
    }

    static int msgGiopMagic(WsByteBuffer wsByteBuffer) {
        return (wsByteBuffer.get(0) & 0xFF) << 24 | (wsByteBuffer.get(1) & 0xFF) << 16 | (wsByteBuffer.get(2) & 0xFF) << 8 | (wsByteBuffer.get(3) & 0xFF) << 0;
    }

    static byte msgGiopMajor(WsByteBuffer wsByteBuffer) {
        return wsByteBuffer.get(4);
    }

    static byte msgGiopMinor(WsByteBuffer wsByteBuffer) {
        return wsByteBuffer.get(5);
    }

    static boolean msgIsLittleEndian(WsByteBuffer wsByteBuffer) {
        return 1 == (wsByteBuffer.get(6) & 1);
    }

    static boolean fragToFollow(WsByteBuffer wsByteBuffer) {
        return 2 == (2 & wsByteBuffer.get(6));
    }

    static byte msgType(WsByteBuffer wsByteBuffer) {
        return wsByteBuffer.get(7);
    }

    static int msgSize(WsByteBuffer wsByteBuffer) {
        return GIOPUtil.msgIsLittleEndian(wsByteBuffer) ? (wsByteBuffer.get(11) & 0xFF) << 24 | (wsByteBuffer.get(10) & 0xFF) << 16 | (wsByteBuffer.get(9) & 0xFF) << 8 | wsByteBuffer.get(8) & 0xFF : (wsByteBuffer.get(8) & 0xFF) << 24 | (wsByteBuffer.get(9) & 0xFF) << 16 | (wsByteBuffer.get(10) & 0xFF) << 8 | wsByteBuffer.get(11) & 0xFF;
    }

    static String messageTypeName(int n) {
        switch (n) {
            case 0: {
                return "request";
            }
            case 1: {
                return "reply";
            }
            case 2: {
                return "cancel request";
            }
            case 3: {
                return "locate request";
            }
            case 4: {
                return "locate reply";
            }
            case 5: {
                return "close connection";
            }
            case 6: {
                return "message error";
            }
            case 7: {
                return "fragment";
            }
        }
        return "unknown";
    }

    static SystemException fragmentTimeoutException(int n, byte by) {
        CompletionStatus completionStatus;
        switch (by) {
            case 0: 
            case 3: {
                completionStatus = CompletionStatus.COMPLETED_NO;
                break;
            }
            case 1: 
            case 4: {
                completionStatus = CompletionStatus.COMPLETED_YES;
                break;
            }
            default: {
                completionStatus = CompletionStatus.COMPLETED_MAYBE;
            }
        }
        return new NO_RESPONSE("Fragment timed out for request id " + n, 1229126402, completionStatus);
    }
}

